/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.audit.internal.http;

import com.google.common.base.Function;
import com.oracle.bmc.audit.model.Configuration;
import com.oracle.bmc.audit.requests.GetConfigurationRequest;
import com.oracle.bmc.audit.responses.GetConfigurationResponse;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetConfigurationConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetConfigurationConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetConfigurationRequest interceptRequest(GetConfigurationRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetConfigurationRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCompartmentId(), (String)"compartmentId is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20190901").path("configuration");
        target = target.queryParam("compartmentId", HttpUtils.attemptEncodeQueryParam(request.getCompartmentId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        return ib;
    }

    public static Function<Response, GetConfigurationResponse> fromResponse() {
        Function<Response, GetConfigurationResponse> transformer = new Function<Response, GetConfigurationResponse>(){

            public GetConfigurationResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for GetConfigurationResponse");
                Function<Response, WithHeaders<Configuration>> responseFn = RESPONSE_CONVERSION_FACTORY.create(Configuration.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                GetConfigurationResponse.Builder builder = GetConfigurationResponse.builder();
                builder.configuration((Configuration)response.getItem());
                GetConfigurationResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

