/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.audit.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.Date;
import javax.ws.rs.client.Invocation;

public class ListEventsRequest
extends BmcRequest {
    private String compartmentId;
    private Date startTime;
    private Date endTime;
    private String page;
    private String opcRequestId;

    @ConstructorProperties(value={"compartmentId", "startTime", "endTime", "page", "opcRequestId"})
    ListEventsRequest(String compartmentId, Date startTime, Date endTime, String page, String opcRequestId) {
        this.compartmentId = compartmentId;
        this.startTime = startTime;
        this.endTime = endTime;
        this.page = page;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private String compartmentId;
        private Date startTime;
        private Date endTime;
        private String page;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListEventsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.startTime(o.getStartTime());
            this.endTime(o.getEndTime());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListEventsRequest build() {
            ListEventsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder startTime(Date startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder endTime(Date endTime) {
            this.endTime = endTime;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ListEventsRequest buildWithoutInvocationCallback() {
            return new ListEventsRequest(this.compartmentId, this.startTime, this.endTime, this.page, this.opcRequestId);
        }

        public String toString() {
            return "ListEventsRequest.Builder(compartmentId=" + this.compartmentId + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", page=" + this.page + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

