/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.audit.requests;

import com.oracle.bmc.audit.model.UpdateConfigurationDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateConfigurationRequest
extends BmcRequest {
    private String compartmentId;
    private UpdateConfigurationDetails updateConfigurationDetails;

    @ConstructorProperties(value={"compartmentId", "updateConfigurationDetails"})
    UpdateConfigurationRequest(String compartmentId, UpdateConfigurationDetails updateConfigurationDetails) {
        this.compartmentId = compartmentId;
        this.updateConfigurationDetails = updateConfigurationDetails;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public UpdateConfigurationDetails getUpdateConfigurationDetails() {
        return this.updateConfigurationDetails;
    }

    public static class Builder {
        private String compartmentId;
        private UpdateConfigurationDetails updateConfigurationDetails;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateConfigurationRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.updateConfigurationDetails(o.getUpdateConfigurationDetails());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateConfigurationRequest build() {
            UpdateConfigurationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder updateConfigurationDetails(UpdateConfigurationDetails updateConfigurationDetails) {
            this.updateConfigurationDetails = updateConfigurationDetails;
            return this;
        }

        public UpdateConfigurationRequest buildWithoutInvocationCallback() {
            return new UpdateConfigurationRequest(this.compartmentId, this.updateConfigurationDetails);
        }

        public String toString() {
            return "UpdateConfigurationRequest.Builder(compartmentId=" + this.compartmentId + ", updateConfigurationDetails=" + this.updateConfigurationDetails + ")";
        }
    }
}

