/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.audit.responses;

import com.oracle.bmc.audit.model.AuditEvent;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListEventsResponse {
    private String opcNextPage;
    private String opcRequestId;
    private List<AuditEvent> items;

    @ConstructorProperties(value={"opcNextPage", "opcRequestId", "items"})
    ListEventsResponse(String opcNextPage, String opcRequestId, List<AuditEvent> items) {
        this.opcNextPage = opcNextPage;
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<AuditEvent> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcNextPage;
        private String opcRequestId;
        private List<AuditEvent> items;

        public Builder copy(ListEventsResponse o) {
            this.opcNextPage(o.getOpcNextPage());
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<AuditEvent> items) {
            this.items = items;
            return this;
        }

        public ListEventsResponse build() {
            return new ListEventsResponse(this.opcNextPage, this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListEventsResponse.Builder(opcNextPage=" + this.opcNextPage + ", opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

