/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth;

import com.oracle.bmc.auth.X509CertificateSupplier;
import com.oracle.bmc.auth.internal.X509CertificateWithOriginalPem;
import com.oracle.bmc.http.signing.internal.PEMFileRSAPrivateKeySupplier;
import java.beans.ConstructorProperties;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.Refreshable;
import lombok.NonNull;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLBasedX509CertificateSupplier
implements X509CertificateSupplier,
Refreshable {
    private static final Logger LOG = LoggerFactory.getLogger(URLBasedX509CertificateSupplier.class);
    private static final boolean EXPERIMENTAL_SUPPRESS_X509_WORKAROUND = Boolean.getBoolean("oci.sdk.experimental.suppressX509Workaround");
    private final AtomicReference<X509CertificateSupplier.CertificateAndPrivateKeyPair> certificateAndKeyPair = new AtomicReference<Object>(null);
    private final ResourceDetails certificateDetails;
    private final ResourceDetails privateKeyDetails;
    private final char[] privateKeyPassphraseCharacters;

    public URLBasedX509CertificateSupplier(ResourceDetails certificateResourceDetails, ResourceDetails privateKeyResourceDetails, char[] privateKeyPassphraseCharacters) {
        this.certificateDetails = certificateResourceDetails;
        this.privateKeyDetails = privateKeyResourceDetails;
        this.privateKeyPassphraseCharacters = privateKeyPassphraseCharacters;
        this.refresh();
    }

    public URLBasedX509CertificateSupplier(URL certificateUrl, URL privateKeyUrl, char[] privateKeyPassphraseCharacters) {
        this(ResourceDetails.builder().url(certificateUrl).build(), ResourceDetails.builder().url(privateKeyUrl).build(), privateKeyPassphraseCharacters);
    }

    @Deprecated
    public URLBasedX509CertificateSupplier(URL certificateUrl, URL privateKeyUrl, String privateKeyPassphrase) {
        this(certificateUrl, privateKeyUrl, privateKeyPassphrase != null ? privateKeyPassphrase.toCharArray() : null);
    }

    @Override
    @Deprecated
    public X509Certificate getCertificate() {
        return this.certificateAndKeyPair.get().getCertificate();
    }

    @Override
    public void refresh() {
        String rawCertificate = URLBasedX509CertificateSupplier.readRawCertificate(this.certificateDetails);
        X509Certificate certificate = URLBasedX509CertificateSupplier.readCertificate(rawCertificate);
        RSAPrivateKey privateKey = URLBasedX509CertificateSupplier.readPrivateKey(this.privateKeyDetails, this.privateKeyPassphraseCharacters);
        if (EXPERIMENTAL_SUPPRESS_X509_WORKAROUND) {
            this.certificateAndKeyPair.set(new X509CertificateSupplier.CertificateAndPrivateKeyPair(certificate, privateKey));
        } else {
            X509CertificateWithOriginalPem wrappedCertificate = new X509CertificateWithOriginalPem(certificate, rawCertificate);
            this.certificateAndKeyPair.set(new X509CertificateSupplier.CertificateAndPrivateKeyPair(wrappedCertificate, privateKey));
        }
    }

    @Override
    public boolean isCurrent() {
        return false;
    }

    private static X509Certificate readCertificate(String certificate) {
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            return (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(certificate.getBytes()));
        }
        catch (CertificateException e) {
            throw new IllegalArgumentException("Invalid certificate.", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readRawCertificate(ResourceDetails certificateResourceDetails) {
        try (InputStream is = URLBasedX509CertificateSupplier.getResourceStream(certificateResourceDetails);){
            String string = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Open stream of certificate failed.", e);
        }
    }

    private static InputStream getResourceStream(@NonNull ResourceDetails resourceDetails) throws IOException {
        if (resourceDetails == null) {
            throw new NullPointerException("resourceDetails is marked @NonNull but is null");
        }
        Objects.requireNonNull(resourceDetails.getUrl(), "Resource url cannot be null.");
        URLConnection urlConnection = resourceDetails.getUrl().openConnection();
        if (resourceDetails.getHeaders() != null) {
            resourceDetails.getHeaders().forEach(urlConnection::setRequestProperty);
        }
        return urlConnection.getInputStream();
    }

    private static RSAPrivateKey readPrivateKey(ResourceDetails privateKeyResouceDetails, char[] privateKeyPassphrase) {
        if (privateKeyResouceDetails == null || privateKeyResouceDetails.getUrl() == null) {
            return null;
        }
        try {
            return (RSAPrivateKey)new PEMFileRSAPrivateKeySupplier(URLBasedX509CertificateSupplier.getResourceStream(privateKeyResouceDetails), privateKeyPassphrase).getKey(null).orNull();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("No file for private key", e);
        }
    }

    @Override
    @Deprecated
    public RSAPrivateKey getPrivateKey() {
        return this.getCertificateAndKeyPair().getPrivateKey();
    }

    @Override
    public X509CertificateSupplier.CertificateAndPrivateKeyPair getCertificateAndKeyPair() {
        return this.certificateAndKeyPair.get();
    }

    static {
        LOG.info("suppressX509Workaround flag set to {}", (Object)EXPERIMENTAL_SUPPRESS_X509_WORKAROUND);
    }

    public static class ResourceDetails {
        private final URL url;
        private final Map<String, String> headers;

        @ConstructorProperties(value={"url", "headers"})
        ResourceDetails(URL url, Map<String, String> headers) {
            this.url = url;
            this.headers = headers;
        }

        public static ResourceDetailsBuilder builder() {
            return new ResourceDetailsBuilder();
        }

        public URL getUrl() {
            return this.url;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResourceDetails)) {
                return false;
            }
            ResourceDetails other = (ResourceDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            URL this$url = this.getUrl();
            URL other$url = other.getUrl();
            if (this$url == null ? other$url != null : !((Object)this$url).equals(other$url)) {
                return false;
            }
            Map<String, String> this$headers = this.getHeaders();
            Map<String, String> other$headers = other.getHeaders();
            return !(this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ResourceDetails;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            URL $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : ((Object)$url).hashCode());
            Map<String, String> $headers = this.getHeaders();
            result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
            return result;
        }

        public String toString() {
            return "URLBasedX509CertificateSupplier.ResourceDetails(url=" + this.getUrl() + ", headers=" + this.getHeaders() + ")";
        }

        public static class ResourceDetailsBuilder {
            private URL url;
            private Map<String, String> headers;

            ResourceDetailsBuilder() {
            }

            public ResourceDetailsBuilder url(URL url) {
                this.url = url;
                return this;
            }

            public ResourceDetailsBuilder headers(Map<String, String> headers) {
                this.headers = headers;
                return this;
            }

            public ResourceDetails build() {
                return new ResourceDetails(this.url, this.headers);
            }

            public String toString() {
                return "URLBasedX509CertificateSupplier.ResourceDetails.ResourceDetailsBuilder(url=" + this.url + ", headers=" + this.headers + ")";
            }
        }
    }
}

