/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth.exception;

import com.google.common.base.Preconditions;
import com.oracle.bmc.auth.exception.AuthClientException;
import com.oracle.bmc.model.BmcException;

public class AuthClientForbiddenException
extends AuthClientException {
    private static final long serialVersionUID = 1L;
    private static final int STATUS_CODE_FORBIDDEN = 403;
    private static final String MESSAGE = "Client is forbidden. ";

    public AuthClientForbiddenException(BmcException e) {
        this(MESSAGE + e.getMessage(), e);
    }

    public AuthClientForbiddenException(String message, BmcException cause) {
        super(message, AuthClientForbiddenException.validate(cause));
    }

    private static BmcException validate(BmcException cause) {
        Preconditions.checkArgument((boolean)AuthClientForbiddenException.matches(cause));
        return cause;
    }

    public static boolean matches(BmcException cause) {
        return cause.getStatusCode() == 403;
    }
}

