/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth.internal;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.SessionKeySupplier;
import com.oracle.bmc.auth.internal.AuthUtils;
import com.oracle.bmc.auth.internal.FederationClient;
import com.oracle.bmc.auth.internal.SecurityTokenAdapter;
import com.oracle.bmc.auth.internal.X509FederationClient;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.DefaultRequestSigner;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.model.BmcException;
import com.oracle.bmc.requests.BmcRequest;
import java.beans.ConstructorProperties;
import java.security.KeyPair;
import java.security.interfaces.RSAPublicKey;
import java.util.Collections;
import javax.annotation.concurrent.Immutable;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractResourcePrincipalsFederationClient<T extends AbstractAuthenticationDetailsProvider>
implements FederationClient {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractResourcePrincipalsFederationClient.class);
    protected static final Function<Response, WithHeaders<X509FederationClient.SecurityToken>> SECURITY_TOKEN_FN = new ResponseConversionFunctionFactory().create(X509FederationClient.SecurityToken.class);
    private final T provider;
    private final SessionKeySupplier sessionKeySupplier;
    private final RestClient federationRestClient;
    private final RestClient resourcePrincipalsRestClient;
    private volatile SecurityTokenAdapter securityTokenAdapter = null;

    public AbstractResourcePrincipalsFederationClient(T provider, String resourcePrincipalTokenEndpoint, String federationEndpoint, SessionKeySupplier sessionKeySupplier, BasicAuthenticationDetailsProvider basicAuthenticationDetailsProvider, ClientConfigurator clientConfigurator) {
        Preconditions.checkNotNull((Object)resourcePrincipalTokenEndpoint);
        this.provider = (AbstractAuthenticationDetailsProvider)Preconditions.checkNotNull(provider);
        this.sessionKeySupplier = (SessionKeySupplier)Preconditions.checkNotNull((Object)sessionKeySupplier);
        RequestSigner requestSigner = DefaultRequestSigner.createRequestSigner(basicAuthenticationDetailsProvider);
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).build();
        this.federationRestClient = restClientFactory.create(requestSigner, Collections.emptyMap());
        this.federationRestClient.setEndpoint(resourcePrincipalTokenEndpoint);
        this.resourcePrincipalsRestClient = restClientFactory.create(requestSigner, Collections.emptyMap());
        this.resourcePrincipalsRestClient.setEndpoint(resourcePrincipalTokenEndpoint);
        this.securityTokenAdapter = new SecurityTokenAdapter(null, sessionKeySupplier);
    }

    @Override
    public String getSecurityToken() {
        if (this.securityTokenAdapter.isValid()) {
            return this.securityTokenAdapter.getSecurityToken();
        }
        return this.refreshAndGetSecurityTokenInner(true);
    }

    @Override
    public String getStringClaim(String key) {
        this.refreshAndGetSecurityToken();
        return this.securityTokenAdapter.getStringClaim(key);
    }

    @Override
    public String refreshAndGetSecurityToken() {
        return this.refreshAndGetSecurityTokenInner(false);
    }

    private SecurityTokenAdapter getSecurityTokenFromServer() {
        LOG.info("Getting security token from the auth server");
        KeyPair keyPair = this.sessionKeySupplier.getKeyPair();
        if (keyPair == null) {
            throw new IllegalStateException("Keypair for session was not provided");
        }
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        if (publicKey == null) {
            throw new IllegalArgumentException("Public key is not present");
        }
        WebTarget target = this.getResourcePrincipalsTarget(this.resourcePrincipalsRestClient, this.provider);
        Invocation.Builder ib = target.request();
        Response response = AbstractResourcePrincipalsFederationClient.makeCall(this.resourcePrincipalsRestClient, ib);
        ResponseHelper.throwIfNotSuccessful(response);
        GetResourcePrincipalTokenResponse getResourcePrincipalTokenResponse = ResponseHelper.readEntity(response, GetResourcePrincipalTokenResponse.class);
        String servicePrincipalSessionToken = getResourcePrincipalTokenResponse.getServicePrincipalSessionToken();
        String resourcePrincipalToken = getResourcePrincipalTokenResponse.getResourcePrincipalToken();
        GetResourcePrincipalSessionTokenRequest getResourcePrincipalSessionTokenRequest = new GetResourcePrincipalSessionTokenRequest(resourcePrincipalToken, servicePrincipalSessionToken, AuthUtils.base64EncodeNoChunking(publicKey));
        target = this.getFederationClientTarget(this.federationRestClient);
        ib = target.request();
        response = AbstractResourcePrincipalsFederationClient.makeCall(this.federationRestClient, ib, getResourcePrincipalSessionTokenRequest);
        ResponseHelper.throwIfNotSuccessful(response);
        X509FederationClient.SecurityToken securityToken = (X509FederationClient.SecurityToken)((WithHeaders)SECURITY_TOKEN_FN.apply((Object)response)).getItem();
        return new SecurityTokenAdapter(securityToken.getToken(), this.sessionKeySupplier);
    }

    protected abstract WebTarget getResourcePrincipalsTarget(RestClient var1, T var2);

    protected abstract WebTarget getFederationClientTarget(RestClient var1);

    protected static Response makeCall(RestClient restClient, Invocation.Builder ib, GetResourcePrincipalSessionTokenRequest request) {
        WrappedInvocationBuilder wrappedIb = new WrappedInvocationBuilder(ib);
        return AbstractResourcePrincipalsFederationClient.makeCallInner(restClient, wrappedIb, request);
    }

    protected static Response makeCall(RestClient restClient, Invocation.Builder ib) {
        WrappedInvocationBuilder wrappedIb = new WrappedInvocationBuilder(ib);
        return AbstractResourcePrincipalsFederationClient.makeCallInner(restClient, wrappedIb, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String refreshAndGetSecurityTokenInner(boolean doFinalTokenValidityCheck) {
        AbstractResourcePrincipalsFederationClient abstractResourcePrincipalsFederationClient = this;
        synchronized (abstractResourcePrincipalsFederationClient) {
            if (!doFinalTokenValidityCheck || !this.securityTokenAdapter.isValid()) {
                LOG.info("Refreshing session keys.");
                this.sessionKeySupplier.refreshKeys();
                this.securityTokenAdapter = this.getSecurityTokenFromServer();
                return this.securityTokenAdapter.getSecurityToken();
            }
            return this.securityTokenAdapter.getSecurityToken();
        }
    }

    private static Response makeCallInner(RestClient restClient, WrappedInvocationBuilder wrappedIb, Object request) {
        int MAX_RETRIES = 5;
        BmcException lastException = null;
        for (int retry = 0; retry < 5; ++retry) {
            try {
                if (request != null) {
                    return restClient.post(wrappedIb, request, new BmcRequest());
                }
                return restClient.get(wrappedIb, new BmcRequest());
            }
            catch (BmcException ex) {
                lastException = ex;
                try {
                    Thread.sleep(250L);
                    continue;
                }
                catch (InterruptedException iex) {
                    LOG.debug("Thread interrupted while waiting to make next call to federation service", (Throwable)iex);
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
        throw lastException;
    }

    private static class GetResourcePrincipalTokenResponse {
        @JsonProperty(value="resourcePrincipalToken")
        private String resourcePrincipalToken;
        @JsonProperty(value="servicePrincipalSessionToken")
        private String servicePrincipalSessionToken;

        private GetResourcePrincipalTokenResponse() {
        }

        public void setResourcePrincipalToken(String resourcePrincipalToken) {
            this.resourcePrincipalToken = resourcePrincipalToken;
        }

        public void setServicePrincipalSessionToken(String servicePrincipalSessionToken) {
            this.servicePrincipalSessionToken = servicePrincipalSessionToken;
        }

        public String getResourcePrincipalToken() {
            return this.resourcePrincipalToken;
        }

        public String getServicePrincipalSessionToken() {
            return this.servicePrincipalSessionToken;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Immutable
    private static class GetResourcePrincipalSessionTokenRequest {
        private final String resourcePrincipalToken;
        private final String servicePrincipalSessionToken;
        private final String sessionPublicKey;

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GetResourcePrincipalSessionTokenRequest)) {
                return false;
            }
            GetResourcePrincipalSessionTokenRequest other = (GetResourcePrincipalSessionTokenRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$resourcePrincipalToken = this.getResourcePrincipalToken();
            String other$resourcePrincipalToken = other.getResourcePrincipalToken();
            if (this$resourcePrincipalToken == null ? other$resourcePrincipalToken != null : !this$resourcePrincipalToken.equals(other$resourcePrincipalToken)) {
                return false;
            }
            String this$servicePrincipalSessionToken = this.getServicePrincipalSessionToken();
            String other$servicePrincipalSessionToken = other.getServicePrincipalSessionToken();
            if (this$servicePrincipalSessionToken == null ? other$servicePrincipalSessionToken != null : !this$servicePrincipalSessionToken.equals(other$servicePrincipalSessionToken)) {
                return false;
            }
            String this$sessionPublicKey = this.getSessionPublicKey();
            String other$sessionPublicKey = other.getSessionPublicKey();
            return !(this$sessionPublicKey == null ? other$sessionPublicKey != null : !this$sessionPublicKey.equals(other$sessionPublicKey));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GetResourcePrincipalSessionTokenRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $resourcePrincipalToken = this.getResourcePrincipalToken();
            result = result * 59 + ($resourcePrincipalToken == null ? 43 : $resourcePrincipalToken.hashCode());
            String $servicePrincipalSessionToken = this.getServicePrincipalSessionToken();
            result = result * 59 + ($servicePrincipalSessionToken == null ? 43 : $servicePrincipalSessionToken.hashCode());
            String $sessionPublicKey = this.getSessionPublicKey();
            result = result * 59 + ($sessionPublicKey == null ? 43 : $sessionPublicKey.hashCode());
            return result;
        }

        @ConstructorProperties(value={"resourcePrincipalToken", "servicePrincipalSessionToken", "sessionPublicKey"})
        public GetResourcePrincipalSessionTokenRequest(String resourcePrincipalToken, String servicePrincipalSessionToken, String sessionPublicKey) {
            this.resourcePrincipalToken = resourcePrincipalToken;
            this.servicePrincipalSessionToken = servicePrincipalSessionToken;
            this.sessionPublicKey = sessionPublicKey;
        }

        public String getResourcePrincipalToken() {
            return this.resourcePrincipalToken;
        }

        public String getServicePrincipalSessionToken() {
            return this.servicePrincipalSessionToken;
        }

        public String getSessionPublicKey() {
            return this.sessionPublicKey;
        }
    }
}

