/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth.internal;

import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.oracle.bmc.auth.X509CertificateSupplier;
import com.oracle.bmc.auth.internal.AuthUtils;
import com.oracle.bmc.auth.internal.X509FederationClient;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.internal.Constants;
import com.oracle.bmc.http.signing.internal.KeySupplier;
import com.oracle.bmc.http.signing.internal.RequestSignerImpl;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class RestClientUtils {
    static RestClient createRestClient(String endpoint, ClientConfigurator clientConfigurator, List<ClientConfigurator> additionalClientConfigurators, final String tenancyId, final X509CertificateSupplier leafCertificateSupplier) {
        KeySupplier<RSAPrivateKey> keySupplier = new KeySupplier<RSAPrivateKey>(){

            @Override
            public Optional<RSAPrivateKey> getKey(String keyId) {
                return Optional.of((Object)leafCertificateSupplier.getCertificateAndKeyPair().getPrivateKey());
            }
        };
        Supplier<String> keyIdSupplier = new Supplier<String>(){

            public String get() {
                return RestClientUtils.keyIdForX509Request(tenancyId, leafCertificateSupplier.getCertificateAndKeyPair().getCertificate());
            }
        };
        return RestClientUtils.createRestClient(endpoint, clientConfigurator, additionalClientConfigurators, keySupplier, keyIdSupplier);
    }

    static RestClient createRestClient(String endpoint, ClientConfigurator clientConfigurator, List<ClientConfigurator> additionalClientConfigurators, final X509FederationClient federationClient) {
        KeySupplier<RSAPrivateKey> keySupplier = new KeySupplier<RSAPrivateKey>(){

            @Override
            public Optional<RSAPrivateKey> getKey(String keyId) {
                return Optional.of((Object)federationClient.getLeafCertificateSupplier().getCertificateAndKeyPair().getPrivateKey());
            }
        };
        Supplier<String> keyIdSupplier = new Supplier<String>(){

            public String get() {
                return RestClientUtils.keyIdForX509Request(federationClient.getTenancyId(), federationClient.getLeafCertificateSupplier().getCertificateAndKeyPair().getCertificate());
            }
        };
        return RestClientUtils.createRestClient(endpoint, clientConfigurator, additionalClientConfigurators, keySupplier, keyIdSupplier);
    }

    private static RestClient createRestClient(String endpoint, ClientConfigurator clientConfigurator, List<ClientConfigurator> additionalClientConfigurators, KeySupplier<RSAPrivateKey> keySupplier, Supplier<String> keyIdSupplier) {
        List<String> genericHeaders = RestClientUtils.removeHostHeader(Constants.GENERIC_HEADERS);
        List<String> allHeaders = RestClientUtils.removeHostHeader(Constants.ALL_HEADERS);
        ImmutableMap<String, List<String>> headersToSign = Constants.createHeadersToSignMap(genericHeaders, genericHeaders, genericHeaders, allHeaders, allHeaders, allHeaders);
        RequestSignerImpl.SigningConfiguration signingConfiguration = new RequestSignerImpl.SigningConfiguration((Map<String, List<String>>)headersToSign, (Map<String, List<String>>)Constants.OPTIONAL_SIGNING_HEADERS, false);
        RequestSignerImpl requestSigner = new RequestSignerImpl(keySupplier, signingConfiguration, keyIdSupplier);
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RestClient restClient = restClientFactory.create((RequestSigner)requestSigner, Collections.emptyMap());
        restClient.setEndpoint(endpoint);
        return restClient;
    }

    private static List<String> removeHostHeader(List<String> headers) {
        ArrayList<String> copy = new ArrayList<String>();
        for (String header : headers) {
            if (header.equals("host")) continue;
            copy.add(header);
        }
        return copy;
    }

    private static String keyIdForX509Request(String tenancyId, X509Certificate certificate) {
        return String.format("%s/fed-x509/%s", tenancyId, AuthUtils.getFingerPrint(certificate));
    }
}

