/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth.internal;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.oracle.bmc.auth.SessionKeySupplier;
import com.oracle.bmc.auth.X509CertificateSupplier;
import com.oracle.bmc.auth.internal.AuthUtils;
import com.oracle.bmc.auth.internal.FederationClient;
import com.oracle.bmc.auth.internal.RestClientUtils;
import com.oracle.bmc.auth.internal.SecurityTokenAdapter;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.model.BmcException;
import com.oracle.bmc.requests.BmcRequest;
import java.security.KeyPair;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import javax.security.auth.RefreshFailedException;
import javax.security.auth.Refreshable;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509FederationClient
implements FederationClient {
    private static final Logger LOG = LoggerFactory.getLogger(X509FederationClient.class);
    private static final Function<Response, WithHeaders<SecurityToken>> SECURITY_TOKEN_FN = new ResponseConversionFunctionFactory().create(SecurityToken.class);
    private static final String DEFAULT_PURPOSE = "DEFAULT";
    private final X509CertificateSupplier leafCertificateSupplier;
    private String tenancyId;
    private final Set<X509CertificateSupplier> intermediateCertificateSuppliers;
    private final SessionKeySupplier sessionKeySupplier;
    private final String purpose;
    private final RestClient federationHttpClient;
    private volatile SecurityTokenAdapter securityTokenAdapter = null;

    public X509FederationClient(String federationEndpoint, String tenancyId, X509CertificateSupplier leafCertificateSupplier, SessionKeySupplier sessionKeySupplier, Set<X509CertificateSupplier> intermediateCertificateSuppliers, ClientConfigurator clientConfigurator, List<ClientConfigurator> additionalClientConfigurators) {
        this(federationEndpoint, tenancyId, leafCertificateSupplier, sessionKeySupplier, intermediateCertificateSuppliers, clientConfigurator, additionalClientConfigurators, DEFAULT_PURPOSE);
    }

    public X509FederationClient(String federationEndpoint, String tenancyId, X509CertificateSupplier leafCertificateSupplier, SessionKeySupplier sessionKeySupplier, Set<X509CertificateSupplier> intermediateCertificateSuppliers, ClientConfigurator clientConfigurator, List<ClientConfigurator> additionalClientConfigurators, String purpose) {
        this.leafCertificateSupplier = (X509CertificateSupplier)Preconditions.checkNotNull((Object)leafCertificateSupplier);
        this.sessionKeySupplier = (SessionKeySupplier)Preconditions.checkNotNull((Object)sessionKeySupplier);
        this.intermediateCertificateSuppliers = intermediateCertificateSuppliers;
        this.tenancyId = (String)Preconditions.checkNotNull((Object)tenancyId);
        this.federationHttpClient = RestClientUtils.createRestClient(federationEndpoint, clientConfigurator, additionalClientConfigurators, this);
        this.securityTokenAdapter = new SecurityTokenAdapter(null, sessionKeySupplier);
        this.purpose = (String)Preconditions.checkNotNull((Object)purpose);
    }

    @Override
    public String getSecurityToken() {
        if (this.securityTokenAdapter.isValid()) {
            return this.securityTokenAdapter.getSecurityToken();
        }
        return this.refreshAndGetSecurityTokenInner(true);
    }

    @Override
    public String getStringClaim(String key) {
        this.refreshAndGetSecurityTokenInner(true);
        return this.securityTokenAdapter.getStringClaim(key);
    }

    @Override
    public String refreshAndGetSecurityToken() {
        return this.refreshAndGetSecurityTokenInner(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String refreshAndGetSecurityTokenInner(boolean doFinalTokenValidityCheck) {
        X509FederationClient x509FederationClient = this;
        synchronized (x509FederationClient) {
            if (!doFinalTokenValidityCheck || !this.securityTokenAdapter.isValid()) {
                LOG.info("Refreshing session keys.");
                this.sessionKeySupplier.refreshKeys();
                if (this.leafCertificateSupplier instanceof Refreshable) {
                    try {
                        ((Refreshable)((Object)this.leafCertificateSupplier)).refresh();
                    }
                    catch (RefreshFailedException ex) {
                        throw new BmcException(false, "Can't refresh the leaf certification!", ex, null);
                    }
                    String newTenancyId = AuthUtils.getTenantIdFromCertificate(this.leafCertificateSupplier.getCertificateAndKeyPair().getCertificate());
                    if (!this.tenancyId.equals(newTenancyId)) {
                        throw new IllegalArgumentException("The tenancy id should never be changed in cert file!");
                    }
                }
                for (X509CertificateSupplier supplier : this.intermediateCertificateSuppliers) {
                    if (!(supplier instanceof Refreshable)) continue;
                    try {
                        ((Refreshable)((Object)supplier)).refresh();
                    }
                    catch (RefreshFailedException ex) {
                        throw new BmcException(false, "Can't refresh the intermediate certification!", ex, null);
                    }
                }
                this.securityTokenAdapter = this.getSecurityTokenFromServer();
                return this.securityTokenAdapter.getSecurityToken();
            }
            return this.securityTokenAdapter.getSecurityToken();
        }
    }

    private SecurityTokenAdapter getSecurityTokenFromServer() {
        LOG.info("Getting security token from the auth server");
        KeyPair keyPair = this.sessionKeySupplier.getKeyPair();
        if (keyPair == null) {
            throw new IllegalStateException("Keypair for session was not provided");
        }
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        if (publicKey == null) {
            throw new IllegalArgumentException("Public key is not present");
        }
        X509CertificateSupplier.CertificateAndPrivateKeyPair certificateAndKeyPair = this.leafCertificateSupplier.getCertificateAndKeyPair();
        if (certificateAndKeyPair == null) {
            throw new IllegalArgumentException("Certificate and key pair are not present");
        }
        X509Certificate leafCertificate = certificateAndKeyPair.getCertificate();
        if (leafCertificate == null) {
            throw new IllegalArgumentException("Leaf certificate is not present");
        }
        if (certificateAndKeyPair.getPrivateKey() == null) {
            throw new IllegalArgumentException("Leaf certificate's private key is not present");
        }
        try {
            HashSet<String> intermediateStrings = null;
            if (this.intermediateCertificateSuppliers != null && this.intermediateCertificateSuppliers.size() > 0) {
                LOG.debug("Intermediate certificate(s) were supplied");
                intermediateStrings = new HashSet<String>();
                for (X509CertificateSupplier supplier : this.intermediateCertificateSuppliers) {
                    X509CertificateSupplier.CertificateAndPrivateKeyPair supplierCertificateAndKeyPair = supplier.getCertificateAndKeyPair();
                    if (supplierCertificateAndKeyPair == null || supplierCertificateAndKeyPair.getCertificate() == null) continue;
                    intermediateStrings.add(AuthUtils.base64EncodeNoChunking(supplierCertificateAndKeyPair.getCertificate()));
                }
            }
            X509FederationRequest federationRequest = new X509FederationRequest(AuthUtils.base64EncodeNoChunking(publicKey), AuthUtils.base64EncodeNoChunking(leafCertificate), intermediateStrings, this.purpose);
            WrappedWebTarget target = this.federationHttpClient.getBaseTarget().path("v1").path("x509");
            Invocation.Builder ib = target.request();
            Response response = this.makeCall(ib, federationRequest);
            SecurityToken securityToken = (SecurityToken)((WithHeaders)SECURITY_TOKEN_FN.apply((Object)response)).getItem();
            return new SecurityTokenAdapter(securityToken.getToken(), this.sessionKeySupplier);
        }
        catch (BmcException e) {
            throw e;
        }
        catch (CertificateException e) {
            LOG.info("Failed to get encoded x509 certificate");
            throw new IllegalArgumentException("Failed to get encoded x509 certificate", e);
        }
    }

    @VisibleForTesting
    Response makeCall(Invocation.Builder ib, X509FederationRequest federationRequest) {
        BmcException lastException = null;
        WrappedInvocationBuilder wrappedIb = new WrappedInvocationBuilder(ib);
        for (int retry = 0; retry < 5; ++retry) {
            try {
                return this.federationHttpClient.post(wrappedIb, federationRequest, new BmcRequest());
            }
            catch (BmcException e) {
                lastException = e;
                try {
                    Thread.sleep(250L);
                    continue;
                }
                catch (InterruptedException e1) {
                    LOG.debug("Thread interrupted while waiting to make next call to federation service", (Throwable)e1);
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
        throw lastException;
    }

    public X509CertificateSupplier getLeafCertificateSupplier() {
        return this.leafCertificateSupplier;
    }

    public String getTenancyId() {
        return this.tenancyId;
    }

    public static class SecurityToken {
        private String token;

        public SecurityToken(@JsonProperty(value="token") String token) {
            this.token = token;
        }

        public String getToken() {
            return this.token;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Immutable
    public static class X509FederationRequest {
        private final Set<String> intermediateCertificates;
        private final String certificate;
        private final String publicKey;
        private final String purpose;

        public X509FederationRequest(String publicKey, String certificate, Set<String> intermediateCertificates, String purpose) {
            this.certificate = (String)Preconditions.checkNotNull((Object)certificate);
            this.publicKey = (String)Preconditions.checkNotNull((Object)publicKey);
            this.intermediateCertificates = intermediateCertificates;
            this.purpose = purpose;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof X509FederationRequest)) {
                return false;
            }
            X509FederationRequest other = (X509FederationRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Set<String> this$intermediateCertificates = this.getIntermediateCertificates();
            Set<String> other$intermediateCertificates = other.getIntermediateCertificates();
            if (this$intermediateCertificates == null ? other$intermediateCertificates != null : !((Object)this$intermediateCertificates).equals(other$intermediateCertificates)) {
                return false;
            }
            String this$certificate = this.getCertificate();
            String other$certificate = other.getCertificate();
            if (this$certificate == null ? other$certificate != null : !this$certificate.equals(other$certificate)) {
                return false;
            }
            String this$publicKey = this.getPublicKey();
            String other$publicKey = other.getPublicKey();
            if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) {
                return false;
            }
            String this$purpose = this.getPurpose();
            String other$purpose = other.getPurpose();
            return !(this$purpose == null ? other$purpose != null : !this$purpose.equals(other$purpose));
        }

        protected boolean canEqual(Object other) {
            return other instanceof X509FederationRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Set<String> $intermediateCertificates = this.getIntermediateCertificates();
            result = result * 59 + ($intermediateCertificates == null ? 43 : ((Object)$intermediateCertificates).hashCode());
            String $certificate = this.getCertificate();
            result = result * 59 + ($certificate == null ? 43 : $certificate.hashCode());
            String $publicKey = this.getPublicKey();
            result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
            String $purpose = this.getPurpose();
            result = result * 59 + ($purpose == null ? 43 : $purpose.hashCode());
            return result;
        }

        public Set<String> getIntermediateCertificates() {
            return this.intermediateCertificates;
        }

        public String getCertificate() {
            return this.certificate;
        }

        public String getPublicKey() {
            return this.publicKey;
        }

        public String getPurpose() {
            return this.purpose;
        }
    }
}

