/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.autoscaling;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.autoscaling.AutoScalingAsync;
import com.oracle.bmc.autoscaling.internal.http.ChangeAutoScalingConfigurationCompartmentConverter;
import com.oracle.bmc.autoscaling.internal.http.CreateAutoScalingConfigurationConverter;
import com.oracle.bmc.autoscaling.internal.http.CreateAutoScalingPolicyConverter;
import com.oracle.bmc.autoscaling.internal.http.DeleteAutoScalingConfigurationConverter;
import com.oracle.bmc.autoscaling.internal.http.DeleteAutoScalingPolicyConverter;
import com.oracle.bmc.autoscaling.internal.http.GetAutoScalingConfigurationConverter;
import com.oracle.bmc.autoscaling.internal.http.GetAutoScalingPolicyConverter;
import com.oracle.bmc.autoscaling.internal.http.ListAutoScalingConfigurationsConverter;
import com.oracle.bmc.autoscaling.internal.http.ListAutoScalingPoliciesConverter;
import com.oracle.bmc.autoscaling.internal.http.UpdateAutoScalingConfigurationConverter;
import com.oracle.bmc.autoscaling.internal.http.UpdateAutoScalingPolicyConverter;
import com.oracle.bmc.autoscaling.requests.ChangeAutoScalingConfigurationCompartmentRequest;
import com.oracle.bmc.autoscaling.requests.CreateAutoScalingConfigurationRequest;
import com.oracle.bmc.autoscaling.requests.CreateAutoScalingPolicyRequest;
import com.oracle.bmc.autoscaling.requests.DeleteAutoScalingConfigurationRequest;
import com.oracle.bmc.autoscaling.requests.DeleteAutoScalingPolicyRequest;
import com.oracle.bmc.autoscaling.requests.GetAutoScalingConfigurationRequest;
import com.oracle.bmc.autoscaling.requests.GetAutoScalingPolicyRequest;
import com.oracle.bmc.autoscaling.requests.ListAutoScalingConfigurationsRequest;
import com.oracle.bmc.autoscaling.requests.ListAutoScalingPoliciesRequest;
import com.oracle.bmc.autoscaling.requests.UpdateAutoScalingConfigurationRequest;
import com.oracle.bmc.autoscaling.requests.UpdateAutoScalingPolicyRequest;
import com.oracle.bmc.autoscaling.responses.ChangeAutoScalingConfigurationCompartmentResponse;
import com.oracle.bmc.autoscaling.responses.CreateAutoScalingConfigurationResponse;
import com.oracle.bmc.autoscaling.responses.CreateAutoScalingPolicyResponse;
import com.oracle.bmc.autoscaling.responses.DeleteAutoScalingConfigurationResponse;
import com.oracle.bmc.autoscaling.responses.DeleteAutoScalingPolicyResponse;
import com.oracle.bmc.autoscaling.responses.GetAutoScalingConfigurationResponse;
import com.oracle.bmc.autoscaling.responses.GetAutoScalingPolicyResponse;
import com.oracle.bmc.autoscaling.responses.ListAutoScalingConfigurationsResponse;
import com.oracle.bmc.autoscaling.responses.ListAutoScalingPoliciesResponse;
import com.oracle.bmc.autoscaling.responses.UpdateAutoScalingConfigurationResponse;
import com.oracle.bmc.autoscaling.responses.UpdateAutoScalingPolicyResponse;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.ErrorConsumer;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.SuccessConsumer;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenTransformingFuture;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrappingAsyncHandler;
import com.oracle.bmc.util.internal.TransformingFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoScalingAsyncClient
implements AutoScalingAsync {
    private static final Logger LOG = LoggerFactory.getLogger(AutoScalingAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("AUTOSCALING").serviceEndpointPrefix("").serviceEndpointTemplate("https://autoscaling.{region}.oci.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public AutoScalingAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public AutoScalingAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public AutoScalingAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public AutoScalingAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public AutoScalingAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public AutoScalingAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public AutoScalingAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)((Object)this.authenticationDetailsProvider)).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional<String> endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(SERVICE, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ChangeAutoScalingConfigurationCompartmentResponse> changeAutoScalingConfigurationCompartment(ChangeAutoScalingConfigurationCompartmentRequest request, AsyncHandler<ChangeAutoScalingConfigurationCompartmentRequest, ChangeAutoScalingConfigurationCompartmentResponse> handler) {
        LOG.trace("Called async changeAutoScalingConfigurationCompartment");
        final ChangeAutoScalingConfigurationCompartmentRequest interceptedRequest = ChangeAutoScalingConfigurationCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeAutoScalingConfigurationCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeAutoScalingConfigurationCompartmentResponse> transformer = ChangeAutoScalingConfigurationCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeAutoScalingConfigurationCompartmentRequest, ChangeAutoScalingConfigurationCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeAutoScalingConfigurationCompartmentRequest, ChangeAutoScalingConfigurationCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeAutoScalingConfigurationCompartmentRequest, ChangeAutoScalingConfigurationCompartmentResponse> onSuccess = new SuccessConsumer<ChangeAutoScalingConfigurationCompartmentRequest, ChangeAutoScalingConfigurationCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeAutoScalingConfigurationCompartmentRequest> onError = new ErrorConsumer<ChangeAutoScalingConfigurationCompartmentRequest>(this, interceptedRequest);
                    AutoScalingAsyncClient.this.client.post(ib, interceptedRequest.getChangeCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeAutoScalingConfigurationCompartmentRequest, ChangeAutoScalingConfigurationCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeAutoScalingConfigurationCompartmentRequest, ChangeAutoScalingConfigurationCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeAutoScalingConfigurationCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeAutoScalingConfigurationCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeAutoScalingConfigurationCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return AutoScalingAsyncClient.this.client.post(ib, interceptedRequest.getChangeCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeAutoScalingConfigurationCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateAutoScalingConfigurationResponse> createAutoScalingConfiguration(CreateAutoScalingConfigurationRequest request, AsyncHandler<CreateAutoScalingConfigurationRequest, CreateAutoScalingConfigurationResponse> handler) {
        LOG.trace("Called async createAutoScalingConfiguration");
        final CreateAutoScalingConfigurationRequest interceptedRequest = CreateAutoScalingConfigurationConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateAutoScalingConfigurationConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateAutoScalingConfigurationResponse> transformer = CreateAutoScalingConfigurationConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateAutoScalingConfigurationRequest, CreateAutoScalingConfigurationResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateAutoScalingConfigurationRequest, CreateAutoScalingConfigurationResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateAutoScalingConfigurationRequest, CreateAutoScalingConfigurationResponse> onSuccess = new SuccessConsumer<CreateAutoScalingConfigurationRequest, CreateAutoScalingConfigurationResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateAutoScalingConfigurationRequest> onError = new ErrorConsumer<CreateAutoScalingConfigurationRequest>(this, interceptedRequest);
                    AutoScalingAsyncClient.this.client.post(ib, interceptedRequest.getCreateAutoScalingConfigurationDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateAutoScalingConfigurationRequest, CreateAutoScalingConfigurationResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateAutoScalingConfigurationRequest, CreateAutoScalingConfigurationResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateAutoScalingConfigurationRequest> onError = handler == null ? null : new ErrorConsumer<CreateAutoScalingConfigurationRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateAutoScalingConfigurationDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateAutoScalingConfigurationResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return AutoScalingAsyncClient.this.client.post(ib, interceptedRequest.getCreateAutoScalingConfigurationDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateAutoScalingConfigurationResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateAutoScalingPolicyResponse> createAutoScalingPolicy(CreateAutoScalingPolicyRequest request, AsyncHandler<CreateAutoScalingPolicyRequest, CreateAutoScalingPolicyResponse> handler) {
        LOG.trace("Called async createAutoScalingPolicy");
        final CreateAutoScalingPolicyRequest interceptedRequest = CreateAutoScalingPolicyConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateAutoScalingPolicyConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateAutoScalingPolicyResponse> transformer = CreateAutoScalingPolicyConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateAutoScalingPolicyRequest, CreateAutoScalingPolicyResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateAutoScalingPolicyRequest, CreateAutoScalingPolicyResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateAutoScalingPolicyRequest, CreateAutoScalingPolicyResponse> onSuccess = new SuccessConsumer<CreateAutoScalingPolicyRequest, CreateAutoScalingPolicyResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateAutoScalingPolicyRequest> onError = new ErrorConsumer<CreateAutoScalingPolicyRequest>(this, interceptedRequest);
                    AutoScalingAsyncClient.this.client.post(ib, interceptedRequest.getCreateAutoScalingPolicyDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateAutoScalingPolicyRequest, CreateAutoScalingPolicyResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateAutoScalingPolicyRequest, CreateAutoScalingPolicyResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateAutoScalingPolicyRequest> onError = handler == null ? null : new ErrorConsumer<CreateAutoScalingPolicyRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateAutoScalingPolicyDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateAutoScalingPolicyResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return AutoScalingAsyncClient.this.client.post(ib, interceptedRequest.getCreateAutoScalingPolicyDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateAutoScalingPolicyResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteAutoScalingConfigurationResponse> deleteAutoScalingConfiguration(DeleteAutoScalingConfigurationRequest request, AsyncHandler<DeleteAutoScalingConfigurationRequest, DeleteAutoScalingConfigurationResponse> handler) {
        LOG.trace("Called async deleteAutoScalingConfiguration");
        final DeleteAutoScalingConfigurationRequest interceptedRequest = DeleteAutoScalingConfigurationConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteAutoScalingConfigurationConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteAutoScalingConfigurationResponse> transformer = DeleteAutoScalingConfigurationConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteAutoScalingConfigurationRequest, DeleteAutoScalingConfigurationResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteAutoScalingConfigurationRequest, DeleteAutoScalingConfigurationResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteAutoScalingConfigurationRequest, DeleteAutoScalingConfigurationResponse> onSuccess = new SuccessConsumer<DeleteAutoScalingConfigurationRequest, DeleteAutoScalingConfigurationResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteAutoScalingConfigurationRequest> onError = new ErrorConsumer<DeleteAutoScalingConfigurationRequest>(this, interceptedRequest);
                    AutoScalingAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteAutoScalingConfigurationRequest, DeleteAutoScalingConfigurationResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteAutoScalingConfigurationRequest, DeleteAutoScalingConfigurationResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteAutoScalingConfigurationRequest> onError = handler == null ? null : new ErrorConsumer<DeleteAutoScalingConfigurationRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteAutoScalingConfigurationResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return AutoScalingAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteAutoScalingConfigurationResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteAutoScalingPolicyResponse> deleteAutoScalingPolicy(DeleteAutoScalingPolicyRequest request, AsyncHandler<DeleteAutoScalingPolicyRequest, DeleteAutoScalingPolicyResponse> handler) {
        LOG.trace("Called async deleteAutoScalingPolicy");
        final DeleteAutoScalingPolicyRequest interceptedRequest = DeleteAutoScalingPolicyConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteAutoScalingPolicyConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteAutoScalingPolicyResponse> transformer = DeleteAutoScalingPolicyConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteAutoScalingPolicyRequest, DeleteAutoScalingPolicyResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteAutoScalingPolicyRequest, DeleteAutoScalingPolicyResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteAutoScalingPolicyRequest, DeleteAutoScalingPolicyResponse> onSuccess = new SuccessConsumer<DeleteAutoScalingPolicyRequest, DeleteAutoScalingPolicyResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteAutoScalingPolicyRequest> onError = new ErrorConsumer<DeleteAutoScalingPolicyRequest>(this, interceptedRequest);
                    AutoScalingAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteAutoScalingPolicyRequest, DeleteAutoScalingPolicyResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteAutoScalingPolicyRequest, DeleteAutoScalingPolicyResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteAutoScalingPolicyRequest> onError = handler == null ? null : new ErrorConsumer<DeleteAutoScalingPolicyRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteAutoScalingPolicyResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return AutoScalingAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteAutoScalingPolicyResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetAutoScalingConfigurationResponse> getAutoScalingConfiguration(GetAutoScalingConfigurationRequest request, AsyncHandler<GetAutoScalingConfigurationRequest, GetAutoScalingConfigurationResponse> handler) {
        LOG.trace("Called async getAutoScalingConfiguration");
        final GetAutoScalingConfigurationRequest interceptedRequest = GetAutoScalingConfigurationConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetAutoScalingConfigurationConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetAutoScalingConfigurationResponse> transformer = GetAutoScalingConfigurationConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetAutoScalingConfigurationRequest, GetAutoScalingConfigurationResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetAutoScalingConfigurationRequest, GetAutoScalingConfigurationResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetAutoScalingConfigurationRequest, GetAutoScalingConfigurationResponse> onSuccess = new SuccessConsumer<GetAutoScalingConfigurationRequest, GetAutoScalingConfigurationResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetAutoScalingConfigurationRequest> onError = new ErrorConsumer<GetAutoScalingConfigurationRequest>(this, interceptedRequest);
                    AutoScalingAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetAutoScalingConfigurationRequest, GetAutoScalingConfigurationResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetAutoScalingConfigurationRequest, GetAutoScalingConfigurationResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetAutoScalingConfigurationRequest> onError = handler == null ? null : new ErrorConsumer<GetAutoScalingConfigurationRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetAutoScalingConfigurationResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return AutoScalingAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetAutoScalingConfigurationResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetAutoScalingPolicyResponse> getAutoScalingPolicy(GetAutoScalingPolicyRequest request, AsyncHandler<GetAutoScalingPolicyRequest, GetAutoScalingPolicyResponse> handler) {
        LOG.trace("Called async getAutoScalingPolicy");
        final GetAutoScalingPolicyRequest interceptedRequest = GetAutoScalingPolicyConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetAutoScalingPolicyConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetAutoScalingPolicyResponse> transformer = GetAutoScalingPolicyConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetAutoScalingPolicyRequest, GetAutoScalingPolicyResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetAutoScalingPolicyRequest, GetAutoScalingPolicyResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetAutoScalingPolicyRequest, GetAutoScalingPolicyResponse> onSuccess = new SuccessConsumer<GetAutoScalingPolicyRequest, GetAutoScalingPolicyResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetAutoScalingPolicyRequest> onError = new ErrorConsumer<GetAutoScalingPolicyRequest>(this, interceptedRequest);
                    AutoScalingAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetAutoScalingPolicyRequest, GetAutoScalingPolicyResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetAutoScalingPolicyRequest, GetAutoScalingPolicyResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetAutoScalingPolicyRequest> onError = handler == null ? null : new ErrorConsumer<GetAutoScalingPolicyRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetAutoScalingPolicyResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return AutoScalingAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetAutoScalingPolicyResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListAutoScalingConfigurationsResponse> listAutoScalingConfigurations(ListAutoScalingConfigurationsRequest request, AsyncHandler<ListAutoScalingConfigurationsRequest, ListAutoScalingConfigurationsResponse> handler) {
        LOG.trace("Called async listAutoScalingConfigurations");
        final ListAutoScalingConfigurationsRequest interceptedRequest = ListAutoScalingConfigurationsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListAutoScalingConfigurationsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListAutoScalingConfigurationsResponse> transformer = ListAutoScalingConfigurationsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListAutoScalingConfigurationsRequest, ListAutoScalingConfigurationsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListAutoScalingConfigurationsRequest, ListAutoScalingConfigurationsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListAutoScalingConfigurationsRequest, ListAutoScalingConfigurationsResponse> onSuccess = new SuccessConsumer<ListAutoScalingConfigurationsRequest, ListAutoScalingConfigurationsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListAutoScalingConfigurationsRequest> onError = new ErrorConsumer<ListAutoScalingConfigurationsRequest>(this, interceptedRequest);
                    AutoScalingAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListAutoScalingConfigurationsRequest, ListAutoScalingConfigurationsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListAutoScalingConfigurationsRequest, ListAutoScalingConfigurationsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListAutoScalingConfigurationsRequest> onError = handler == null ? null : new ErrorConsumer<ListAutoScalingConfigurationsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListAutoScalingConfigurationsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return AutoScalingAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListAutoScalingConfigurationsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListAutoScalingPoliciesResponse> listAutoScalingPolicies(ListAutoScalingPoliciesRequest request, AsyncHandler<ListAutoScalingPoliciesRequest, ListAutoScalingPoliciesResponse> handler) {
        LOG.trace("Called async listAutoScalingPolicies");
        final ListAutoScalingPoliciesRequest interceptedRequest = ListAutoScalingPoliciesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListAutoScalingPoliciesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListAutoScalingPoliciesResponse> transformer = ListAutoScalingPoliciesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListAutoScalingPoliciesRequest, ListAutoScalingPoliciesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListAutoScalingPoliciesRequest, ListAutoScalingPoliciesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListAutoScalingPoliciesRequest, ListAutoScalingPoliciesResponse> onSuccess = new SuccessConsumer<ListAutoScalingPoliciesRequest, ListAutoScalingPoliciesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListAutoScalingPoliciesRequest> onError = new ErrorConsumer<ListAutoScalingPoliciesRequest>(this, interceptedRequest);
                    AutoScalingAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListAutoScalingPoliciesRequest, ListAutoScalingPoliciesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListAutoScalingPoliciesRequest, ListAutoScalingPoliciesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListAutoScalingPoliciesRequest> onError = handler == null ? null : new ErrorConsumer<ListAutoScalingPoliciesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListAutoScalingPoliciesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return AutoScalingAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListAutoScalingPoliciesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateAutoScalingConfigurationResponse> updateAutoScalingConfiguration(UpdateAutoScalingConfigurationRequest request, AsyncHandler<UpdateAutoScalingConfigurationRequest, UpdateAutoScalingConfigurationResponse> handler) {
        LOG.trace("Called async updateAutoScalingConfiguration");
        final UpdateAutoScalingConfigurationRequest interceptedRequest = UpdateAutoScalingConfigurationConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateAutoScalingConfigurationConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateAutoScalingConfigurationResponse> transformer = UpdateAutoScalingConfigurationConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateAutoScalingConfigurationRequest, UpdateAutoScalingConfigurationResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateAutoScalingConfigurationRequest, UpdateAutoScalingConfigurationResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateAutoScalingConfigurationRequest, UpdateAutoScalingConfigurationResponse> onSuccess = new SuccessConsumer<UpdateAutoScalingConfigurationRequest, UpdateAutoScalingConfigurationResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateAutoScalingConfigurationRequest> onError = new ErrorConsumer<UpdateAutoScalingConfigurationRequest>(this, interceptedRequest);
                    AutoScalingAsyncClient.this.client.put(ib, interceptedRequest.getUpdateAutoScalingConfigurationDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateAutoScalingConfigurationRequest, UpdateAutoScalingConfigurationResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateAutoScalingConfigurationRequest, UpdateAutoScalingConfigurationResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateAutoScalingConfigurationRequest> onError = handler == null ? null : new ErrorConsumer<UpdateAutoScalingConfigurationRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateAutoScalingConfigurationDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateAutoScalingConfigurationResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return AutoScalingAsyncClient.this.client.put(ib, interceptedRequest.getUpdateAutoScalingConfigurationDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateAutoScalingConfigurationResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateAutoScalingPolicyResponse> updateAutoScalingPolicy(UpdateAutoScalingPolicyRequest request, AsyncHandler<UpdateAutoScalingPolicyRequest, UpdateAutoScalingPolicyResponse> handler) {
        LOG.trace("Called async updateAutoScalingPolicy");
        final UpdateAutoScalingPolicyRequest interceptedRequest = UpdateAutoScalingPolicyConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateAutoScalingPolicyConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateAutoScalingPolicyResponse> transformer = UpdateAutoScalingPolicyConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateAutoScalingPolicyRequest, UpdateAutoScalingPolicyResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateAutoScalingPolicyRequest, UpdateAutoScalingPolicyResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateAutoScalingPolicyRequest, UpdateAutoScalingPolicyResponse> onSuccess = new SuccessConsumer<UpdateAutoScalingPolicyRequest, UpdateAutoScalingPolicyResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateAutoScalingPolicyRequest> onError = new ErrorConsumer<UpdateAutoScalingPolicyRequest>(this, interceptedRequest);
                    AutoScalingAsyncClient.this.client.put(ib, interceptedRequest.getUpdateAutoScalingPolicyDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateAutoScalingPolicyRequest, UpdateAutoScalingPolicyResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateAutoScalingPolicyRequest, UpdateAutoScalingPolicyResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateAutoScalingPolicyRequest> onError = handler == null ? null : new ErrorConsumer<UpdateAutoScalingPolicyRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateAutoScalingPolicyDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateAutoScalingPolicyResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return AutoScalingAsyncClient.this.client.put(ib, interceptedRequest.getUpdateAutoScalingPolicyDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateAutoScalingPolicyResponse>(responseFuture, transformer);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, AutoScalingAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        @Override
        public AutoScalingAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new AutoScalingAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

