/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.autoscaling;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.autoscaling.AutoScaling;
import com.oracle.bmc.autoscaling.AutoScalingPaginators;
import com.oracle.bmc.autoscaling.internal.http.ChangeAutoScalingConfigurationCompartmentConverter;
import com.oracle.bmc.autoscaling.internal.http.CreateAutoScalingConfigurationConverter;
import com.oracle.bmc.autoscaling.internal.http.CreateAutoScalingPolicyConverter;
import com.oracle.bmc.autoscaling.internal.http.DeleteAutoScalingConfigurationConverter;
import com.oracle.bmc.autoscaling.internal.http.DeleteAutoScalingPolicyConverter;
import com.oracle.bmc.autoscaling.internal.http.GetAutoScalingConfigurationConverter;
import com.oracle.bmc.autoscaling.internal.http.GetAutoScalingPolicyConverter;
import com.oracle.bmc.autoscaling.internal.http.ListAutoScalingConfigurationsConverter;
import com.oracle.bmc.autoscaling.internal.http.ListAutoScalingPoliciesConverter;
import com.oracle.bmc.autoscaling.internal.http.UpdateAutoScalingConfigurationConverter;
import com.oracle.bmc.autoscaling.internal.http.UpdateAutoScalingPolicyConverter;
import com.oracle.bmc.autoscaling.requests.ChangeAutoScalingConfigurationCompartmentRequest;
import com.oracle.bmc.autoscaling.requests.CreateAutoScalingConfigurationRequest;
import com.oracle.bmc.autoscaling.requests.CreateAutoScalingPolicyRequest;
import com.oracle.bmc.autoscaling.requests.DeleteAutoScalingConfigurationRequest;
import com.oracle.bmc.autoscaling.requests.DeleteAutoScalingPolicyRequest;
import com.oracle.bmc.autoscaling.requests.GetAutoScalingConfigurationRequest;
import com.oracle.bmc.autoscaling.requests.GetAutoScalingPolicyRequest;
import com.oracle.bmc.autoscaling.requests.ListAutoScalingConfigurationsRequest;
import com.oracle.bmc.autoscaling.requests.ListAutoScalingPoliciesRequest;
import com.oracle.bmc.autoscaling.requests.UpdateAutoScalingConfigurationRequest;
import com.oracle.bmc.autoscaling.requests.UpdateAutoScalingPolicyRequest;
import com.oracle.bmc.autoscaling.responses.ChangeAutoScalingConfigurationCompartmentResponse;
import com.oracle.bmc.autoscaling.responses.CreateAutoScalingConfigurationResponse;
import com.oracle.bmc.autoscaling.responses.CreateAutoScalingPolicyResponse;
import com.oracle.bmc.autoscaling.responses.DeleteAutoScalingConfigurationResponse;
import com.oracle.bmc.autoscaling.responses.DeleteAutoScalingPolicyResponse;
import com.oracle.bmc.autoscaling.responses.GetAutoScalingConfigurationResponse;
import com.oracle.bmc.autoscaling.responses.GetAutoScalingPolicyResponse;
import com.oracle.bmc.autoscaling.responses.ListAutoScalingConfigurationsResponse;
import com.oracle.bmc.autoscaling.responses.ListAutoScalingPoliciesResponse;
import com.oracle.bmc.autoscaling.responses.UpdateAutoScalingConfigurationResponse;
import com.oracle.bmc.autoscaling.responses.UpdateAutoScalingPolicyResponse;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoScalingClient
implements AutoScaling {
    private static final Logger LOG = LoggerFactory.getLogger(AutoScalingClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("AUTOSCALING").serviceEndpointPrefix("").serviceEndpointTemplate("https://autoscaling.{region}.oci.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final AutoScalingPaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public AutoScalingClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public AutoScalingClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public AutoScalingClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public AutoScalingClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public AutoScalingClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public AutoScalingClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public AutoScalingClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        this.paginators = new AutoScalingPaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)((Object)this.authenticationDetailsProvider)).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional<String> endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(SERVICE, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public ChangeAutoScalingConfigurationCompartmentResponse changeAutoScalingConfigurationCompartment(ChangeAutoScalingConfigurationCompartmentRequest request) {
        LOG.trace("Called changeAutoScalingConfigurationCompartment");
        ChangeAutoScalingConfigurationCompartmentRequest interceptedRequest = ChangeAutoScalingConfigurationCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeAutoScalingConfigurationCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeAutoScalingConfigurationCompartmentResponse> transformer = ChangeAutoScalingConfigurationCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getChangeCompartmentDetails(), retriedRequest);
                return (ChangeAutoScalingConfigurationCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateAutoScalingConfigurationResponse createAutoScalingConfiguration(CreateAutoScalingConfigurationRequest request) {
        LOG.trace("Called createAutoScalingConfiguration");
        CreateAutoScalingConfigurationRequest interceptedRequest = CreateAutoScalingConfigurationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateAutoScalingConfigurationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateAutoScalingConfigurationResponse> transformer = CreateAutoScalingConfigurationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateAutoScalingConfigurationDetails(), retriedRequest);
                return (CreateAutoScalingConfigurationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateAutoScalingPolicyResponse createAutoScalingPolicy(CreateAutoScalingPolicyRequest request) {
        LOG.trace("Called createAutoScalingPolicy");
        CreateAutoScalingPolicyRequest interceptedRequest = CreateAutoScalingPolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateAutoScalingPolicyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateAutoScalingPolicyResponse> transformer = CreateAutoScalingPolicyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateAutoScalingPolicyDetails(), retriedRequest);
                return (CreateAutoScalingPolicyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteAutoScalingConfigurationResponse deleteAutoScalingConfiguration(DeleteAutoScalingConfigurationRequest request) {
        LOG.trace("Called deleteAutoScalingConfiguration");
        DeleteAutoScalingConfigurationRequest interceptedRequest = DeleteAutoScalingConfigurationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteAutoScalingConfigurationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteAutoScalingConfigurationResponse> transformer = DeleteAutoScalingConfigurationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteAutoScalingConfigurationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteAutoScalingPolicyResponse deleteAutoScalingPolicy(DeleteAutoScalingPolicyRequest request) {
        LOG.trace("Called deleteAutoScalingPolicy");
        DeleteAutoScalingPolicyRequest interceptedRequest = DeleteAutoScalingPolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteAutoScalingPolicyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteAutoScalingPolicyResponse> transformer = DeleteAutoScalingPolicyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteAutoScalingPolicyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetAutoScalingConfigurationResponse getAutoScalingConfiguration(GetAutoScalingConfigurationRequest request) {
        LOG.trace("Called getAutoScalingConfiguration");
        GetAutoScalingConfigurationRequest interceptedRequest = GetAutoScalingConfigurationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetAutoScalingConfigurationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetAutoScalingConfigurationResponse> transformer = GetAutoScalingConfigurationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetAutoScalingConfigurationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetAutoScalingPolicyResponse getAutoScalingPolicy(GetAutoScalingPolicyRequest request) {
        LOG.trace("Called getAutoScalingPolicy");
        GetAutoScalingPolicyRequest interceptedRequest = GetAutoScalingPolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetAutoScalingPolicyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetAutoScalingPolicyResponse> transformer = GetAutoScalingPolicyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetAutoScalingPolicyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListAutoScalingConfigurationsResponse listAutoScalingConfigurations(ListAutoScalingConfigurationsRequest request) {
        LOG.trace("Called listAutoScalingConfigurations");
        ListAutoScalingConfigurationsRequest interceptedRequest = ListAutoScalingConfigurationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAutoScalingConfigurationsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListAutoScalingConfigurationsResponse> transformer = ListAutoScalingConfigurationsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListAutoScalingConfigurationsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListAutoScalingPoliciesResponse listAutoScalingPolicies(ListAutoScalingPoliciesRequest request) {
        LOG.trace("Called listAutoScalingPolicies");
        ListAutoScalingPoliciesRequest interceptedRequest = ListAutoScalingPoliciesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAutoScalingPoliciesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListAutoScalingPoliciesResponse> transformer = ListAutoScalingPoliciesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListAutoScalingPoliciesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateAutoScalingConfigurationResponse updateAutoScalingConfiguration(UpdateAutoScalingConfigurationRequest request) {
        LOG.trace("Called updateAutoScalingConfiguration");
        UpdateAutoScalingConfigurationRequest interceptedRequest = UpdateAutoScalingConfigurationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateAutoScalingConfigurationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateAutoScalingConfigurationResponse> transformer = UpdateAutoScalingConfigurationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateAutoScalingConfigurationDetails(), retriedRequest);
                return (UpdateAutoScalingConfigurationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateAutoScalingPolicyResponse updateAutoScalingPolicy(UpdateAutoScalingPolicyRequest request) {
        LOG.trace("Called updateAutoScalingPolicy");
        UpdateAutoScalingPolicyRequest interceptedRequest = UpdateAutoScalingPolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateAutoScalingPolicyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateAutoScalingPolicyResponse> transformer = UpdateAutoScalingPolicyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateAutoScalingPolicyDetails(), retriedRequest);
                return (UpdateAutoScalingPolicyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public AutoScalingPaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, AutoScalingClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        @Override
        public AutoScalingClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new AutoScalingClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

