/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.autoscaling;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.autoscaling.AutoScaling;
import com.oracle.bmc.autoscaling.model.AutoScalingConfigurationSummary;
import com.oracle.bmc.autoscaling.model.AutoScalingPolicySummary;
import com.oracle.bmc.autoscaling.requests.ListAutoScalingConfigurationsRequest;
import com.oracle.bmc.autoscaling.requests.ListAutoScalingPoliciesRequest;
import com.oracle.bmc.autoscaling.responses.ListAutoScalingConfigurationsResponse;
import com.oracle.bmc.autoscaling.responses.ListAutoScalingPoliciesResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class AutoScalingPaginators {
    private final AutoScaling client;

    public Iterable<ListAutoScalingConfigurationsResponse> listAutoScalingConfigurationsResponseIterator(final ListAutoScalingConfigurationsRequest request) {
        return new ResponseIterable<ListAutoScalingConfigurationsRequest.Builder, ListAutoScalingConfigurationsRequest, ListAutoScalingConfigurationsResponse>(new Supplier<ListAutoScalingConfigurationsRequest.Builder>(){

            public ListAutoScalingConfigurationsRequest.Builder get() {
                return ListAutoScalingConfigurationsRequest.builder().copy(request);
            }
        }, new Function<ListAutoScalingConfigurationsResponse, String>(){

            public String apply(ListAutoScalingConfigurationsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListAutoScalingConfigurationsRequest.Builder>, ListAutoScalingConfigurationsRequest>(){

            public ListAutoScalingConfigurationsRequest apply(RequestBuilderAndToken<ListAutoScalingConfigurationsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListAutoScalingConfigurationsRequest, ListAutoScalingConfigurationsResponse>(){

            public ListAutoScalingConfigurationsResponse apply(ListAutoScalingConfigurationsRequest request) {
                return AutoScalingPaginators.this.client.listAutoScalingConfigurations(request);
            }
        });
    }

    public Iterable<AutoScalingConfigurationSummary> listAutoScalingConfigurationsRecordIterator(final ListAutoScalingConfigurationsRequest request) {
        return new ResponseRecordIterable<ListAutoScalingConfigurationsRequest.Builder, ListAutoScalingConfigurationsRequest, ListAutoScalingConfigurationsResponse, AutoScalingConfigurationSummary>(new Supplier<ListAutoScalingConfigurationsRequest.Builder>(){

            public ListAutoScalingConfigurationsRequest.Builder get() {
                return ListAutoScalingConfigurationsRequest.builder().copy(request);
            }
        }, new Function<ListAutoScalingConfigurationsResponse, String>(){

            public String apply(ListAutoScalingConfigurationsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListAutoScalingConfigurationsRequest.Builder>, ListAutoScalingConfigurationsRequest>(){

            public ListAutoScalingConfigurationsRequest apply(RequestBuilderAndToken<ListAutoScalingConfigurationsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListAutoScalingConfigurationsRequest, ListAutoScalingConfigurationsResponse>(){

            public ListAutoScalingConfigurationsResponse apply(ListAutoScalingConfigurationsRequest request) {
                return AutoScalingPaginators.this.client.listAutoScalingConfigurations(request);
            }
        }, new Function<ListAutoScalingConfigurationsResponse, List<AutoScalingConfigurationSummary>>(){

            public List<AutoScalingConfigurationSummary> apply(ListAutoScalingConfigurationsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListAutoScalingPoliciesResponse> listAutoScalingPoliciesResponseIterator(final ListAutoScalingPoliciesRequest request) {
        return new ResponseIterable<ListAutoScalingPoliciesRequest.Builder, ListAutoScalingPoliciesRequest, ListAutoScalingPoliciesResponse>(new Supplier<ListAutoScalingPoliciesRequest.Builder>(){

            public ListAutoScalingPoliciesRequest.Builder get() {
                return ListAutoScalingPoliciesRequest.builder().copy(request);
            }
        }, new Function<ListAutoScalingPoliciesResponse, String>(){

            public String apply(ListAutoScalingPoliciesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListAutoScalingPoliciesRequest.Builder>, ListAutoScalingPoliciesRequest>(){

            public ListAutoScalingPoliciesRequest apply(RequestBuilderAndToken<ListAutoScalingPoliciesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListAutoScalingPoliciesRequest, ListAutoScalingPoliciesResponse>(){

            public ListAutoScalingPoliciesResponse apply(ListAutoScalingPoliciesRequest request) {
                return AutoScalingPaginators.this.client.listAutoScalingPolicies(request);
            }
        });
    }

    public Iterable<AutoScalingPolicySummary> listAutoScalingPoliciesRecordIterator(final ListAutoScalingPoliciesRequest request) {
        return new ResponseRecordIterable<ListAutoScalingPoliciesRequest.Builder, ListAutoScalingPoliciesRequest, ListAutoScalingPoliciesResponse, AutoScalingPolicySummary>(new Supplier<ListAutoScalingPoliciesRequest.Builder>(){

            public ListAutoScalingPoliciesRequest.Builder get() {
                return ListAutoScalingPoliciesRequest.builder().copy(request);
            }
        }, new Function<ListAutoScalingPoliciesResponse, String>(){

            public String apply(ListAutoScalingPoliciesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListAutoScalingPoliciesRequest.Builder>, ListAutoScalingPoliciesRequest>(){

            public ListAutoScalingPoliciesRequest apply(RequestBuilderAndToken<ListAutoScalingPoliciesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListAutoScalingPoliciesRequest, ListAutoScalingPoliciesResponse>(){

            public ListAutoScalingPoliciesResponse apply(ListAutoScalingPoliciesRequest request) {
                return AutoScalingPaginators.this.client.listAutoScalingPolicies(request);
            }
        }, new Function<ListAutoScalingPoliciesResponse, List<AutoScalingPolicySummary>>(){

            public List<AutoScalingPolicySummary> apply(ListAutoScalingPoliciesResponse response) {
                return response.getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public AutoScalingPaginators(AutoScaling client) {
        this.client = client;
    }
}

