/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.autoscaling.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.autoscaling.model.AutoScalingConfiguration;
import com.oracle.bmc.autoscaling.requests.UpdateAutoScalingConfigurationRequest;
import com.oracle.bmc.autoscaling.responses.UpdateAutoScalingConfigurationResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateAutoScalingConfigurationConverter {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateAutoScalingConfigurationConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static UpdateAutoScalingConfigurationRequest interceptRequest(UpdateAutoScalingConfigurationRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, UpdateAutoScalingConfigurationRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getAutoScalingConfigurationId(), (String)"autoScalingConfigurationId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getUpdateAutoScalingConfigurationDetails(), (String)"updateAutoScalingConfigurationDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20181001").path("autoScalingConfigurations").path(HttpUtils.encodePathSegment(request.getAutoScalingConfigurationId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getIfMatch() != null) {
            ib.header("if-match", request.getIfMatch());
        }
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", request.getOpcRequestId());
        }
        if (request.getOpcRetryToken() != null) {
            ib.header("opc-retry-token", request.getOpcRetryToken());
        }
        return ib;
    }

    public static Function<Response, UpdateAutoScalingConfigurationResponse> fromResponse() {
        Function<Response, UpdateAutoScalingConfigurationResponse> transformer = new Function<Response, UpdateAutoScalingConfigurationResponse>(){

            public UpdateAutoScalingConfigurationResponse apply(Response rawResponse) {
                Optional<List<String>> opcRequestIdHeader;
                LOG.trace("Transform function invoked for UpdateAutoScalingConfigurationResponse");
                Function<Response, WithHeaders<AutoScalingConfiguration>> responseFn = RESPONSE_CONVERSION_FACTORY.create(AutoScalingConfiguration.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                UpdateAutoScalingConfigurationResponse.Builder builder = UpdateAutoScalingConfigurationResponse.builder();
                builder.autoScalingConfiguration((AutoScalingConfiguration)response.getItem());
                Optional<List<String>> etagHeader = HeaderUtils.get(headers, "etag");
                if (etagHeader.isPresent()) {
                    builder.etag(HeaderUtils.toValue("etag", (String)((List)etagHeader.get()).get(0), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id")).isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                UpdateAutoScalingConfigurationResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

