/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.autoscaling.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.autoscaling.model.AutoScalingPolicy;
import com.oracle.bmc.autoscaling.requests.UpdateAutoScalingPolicyRequest;
import com.oracle.bmc.autoscaling.responses.UpdateAutoScalingPolicyResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateAutoScalingPolicyConverter {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateAutoScalingPolicyConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static UpdateAutoScalingPolicyRequest interceptRequest(UpdateAutoScalingPolicyRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, UpdateAutoScalingPolicyRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getAutoScalingConfigurationId(), (String)"autoScalingConfigurationId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getAutoScalingPolicyId(), (String)"autoScalingPolicyId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getUpdateAutoScalingPolicyDetails(), (String)"updateAutoScalingPolicyDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20181001").path("autoScalingConfigurations").path(HttpUtils.encodePathSegment(request.getAutoScalingConfigurationId())).path("policies").path(HttpUtils.encodePathSegment(request.getAutoScalingPolicyId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getIfMatch() != null) {
            ib.header("if-match", request.getIfMatch());
        }
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", request.getOpcRequestId());
        }
        if (request.getOpcRetryToken() != null) {
            ib.header("opc-retry-token", request.getOpcRetryToken());
        }
        return ib;
    }

    public static Function<Response, UpdateAutoScalingPolicyResponse> fromResponse() {
        Function<Response, UpdateAutoScalingPolicyResponse> transformer = new Function<Response, UpdateAutoScalingPolicyResponse>(){

            public UpdateAutoScalingPolicyResponse apply(Response rawResponse) {
                Optional<List<String>> opcRequestIdHeader;
                LOG.trace("Transform function invoked for UpdateAutoScalingPolicyResponse");
                Function<Response, WithHeaders<AutoScalingPolicy>> responseFn = RESPONSE_CONVERSION_FACTORY.create(AutoScalingPolicy.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                UpdateAutoScalingPolicyResponse.Builder builder = UpdateAutoScalingPolicyResponse.builder();
                builder.autoScalingPolicy((AutoScalingPolicy)response.getItem());
                Optional<List<String>> etagHeader = HeaderUtils.get(headers, "etag");
                if (etagHeader.isPresent()) {
                    builder.etag(HeaderUtils.toValue("etag", (String)((List)etagHeader.get()).get(0), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id")).isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                UpdateAutoScalingPolicyResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

