/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.autoscaling.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetAutoScalingPolicyRequest
extends BmcRequest {
    private String autoScalingConfigurationId;
    private String autoScalingPolicyId;
    private String opcRequestId;

    @ConstructorProperties(value={"autoScalingConfigurationId", "autoScalingPolicyId", "opcRequestId"})
    GetAutoScalingPolicyRequest(String autoScalingConfigurationId, String autoScalingPolicyId, String opcRequestId) {
        this.autoScalingConfigurationId = autoScalingConfigurationId;
        this.autoScalingPolicyId = autoScalingPolicyId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getAutoScalingConfigurationId() {
        return this.autoScalingConfigurationId;
    }

    public String getAutoScalingPolicyId() {
        return this.autoScalingPolicyId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private String autoScalingConfigurationId;
        private String autoScalingPolicyId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetAutoScalingPolicyRequest o) {
            this.autoScalingConfigurationId(o.getAutoScalingConfigurationId());
            this.autoScalingPolicyId(o.getAutoScalingPolicyId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetAutoScalingPolicyRequest build() {
            GetAutoScalingPolicyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder autoScalingConfigurationId(String autoScalingConfigurationId) {
            this.autoScalingConfigurationId = autoScalingConfigurationId;
            return this;
        }

        public Builder autoScalingPolicyId(String autoScalingPolicyId) {
            this.autoScalingPolicyId = autoScalingPolicyId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetAutoScalingPolicyRequest buildWithoutInvocationCallback() {
            return new GetAutoScalingPolicyRequest(this.autoScalingConfigurationId, this.autoScalingPolicyId, this.opcRequestId);
        }

        public String toString() {
            return "GetAutoScalingPolicyRequest.Builder(autoScalingConfigurationId=" + this.autoScalingConfigurationId + ", autoScalingPolicyId=" + this.autoScalingPolicyId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

