/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.autoscaling.responses;

import com.oracle.bmc.autoscaling.model.AutoScalingPolicy;
import java.beans.ConstructorProperties;

public class GetAutoScalingPolicyResponse {
    private String etag;
    private String opcRequestId;
    private AutoScalingPolicy autoScalingPolicy;

    @ConstructorProperties(value={"etag", "opcRequestId", "autoScalingPolicy"})
    GetAutoScalingPolicyResponse(String etag, String opcRequestId, AutoScalingPolicy autoScalingPolicy) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.autoScalingPolicy = autoScalingPolicy;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public AutoScalingPolicy getAutoScalingPolicy() {
        return this.autoScalingPolicy;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private AutoScalingPolicy autoScalingPolicy;

        public Builder copy(GetAutoScalingPolicyResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.autoScalingPolicy(o.getAutoScalingPolicy());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder autoScalingPolicy(AutoScalingPolicy autoScalingPolicy) {
            this.autoScalingPolicy = autoScalingPolicy;
            return this;
        }

        public GetAutoScalingPolicyResponse build() {
            return new GetAutoScalingPolicyResponse(this.etag, this.opcRequestId, this.autoScalingPolicy);
        }

        public String toString() {
            return "GetAutoScalingPolicyResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", autoScalingPolicy=" + this.autoScalingPolicy + ")";
        }
    }
}

