/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.autoscaling.responses;

import com.oracle.bmc.autoscaling.model.AutoScalingConfigurationSummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListAutoScalingConfigurationsResponse {
    private String opcNextPage;
    private String opcRequestId;
    private List<AutoScalingConfigurationSummary> items;

    @ConstructorProperties(value={"opcNextPage", "opcRequestId", "items"})
    ListAutoScalingConfigurationsResponse(String opcNextPage, String opcRequestId, List<AutoScalingConfigurationSummary> items) {
        this.opcNextPage = opcNextPage;
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<AutoScalingConfigurationSummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcNextPage;
        private String opcRequestId;
        private List<AutoScalingConfigurationSummary> items;

        public Builder copy(ListAutoScalingConfigurationsResponse o) {
            this.opcNextPage(o.getOpcNextPage());
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<AutoScalingConfigurationSummary> items) {
            this.items = items;
            return this;
        }

        public ListAutoScalingConfigurationsResponse build() {
            return new ListAutoScalingConfigurationsResponse(this.opcNextPage, this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListAutoScalingConfigurationsResponse.Builder(opcNextPage=" + this.opcNextPage + ", opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

