/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.autoscaling.responses;

import com.oracle.bmc.autoscaling.model.AutoScalingPolicySummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListAutoScalingPoliciesResponse {
    private String opcNextPage;
    private String opcRequestId;
    private List<AutoScalingPolicySummary> items;

    @ConstructorProperties(value={"opcNextPage", "opcRequestId", "items"})
    ListAutoScalingPoliciesResponse(String opcNextPage, String opcRequestId, List<AutoScalingPolicySummary> items) {
        this.opcNextPage = opcNextPage;
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<AutoScalingPolicySummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcNextPage;
        private String opcRequestId;
        private List<AutoScalingPolicySummary> items;

        public Builder copy(ListAutoScalingPoliciesResponse o) {
            this.opcNextPage(o.getOpcNextPage());
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<AutoScalingPolicySummary> items) {
            this.items = items;
            return this;
        }

        public ListAutoScalingPoliciesResponse build() {
            return new ListAutoScalingPoliciesResponse(this.opcNextPage, this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListAutoScalingPoliciesResponse.Builder(opcNextPage=" + this.opcNextPage + ", opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

