/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.autoscaling.responses;

import com.oracle.bmc.autoscaling.model.AutoScalingConfiguration;
import java.beans.ConstructorProperties;

public class UpdateAutoScalingConfigurationResponse {
    private String etag;
    private String opcRequestId;
    private AutoScalingConfiguration autoScalingConfiguration;

    @ConstructorProperties(value={"etag", "opcRequestId", "autoScalingConfiguration"})
    UpdateAutoScalingConfigurationResponse(String etag, String opcRequestId, AutoScalingConfiguration autoScalingConfiguration) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.autoScalingConfiguration = autoScalingConfiguration;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public AutoScalingConfiguration getAutoScalingConfiguration() {
        return this.autoScalingConfiguration;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private AutoScalingConfiguration autoScalingConfiguration;

        public Builder copy(UpdateAutoScalingConfigurationResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.autoScalingConfiguration(o.getAutoScalingConfiguration());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder autoScalingConfiguration(AutoScalingConfiguration autoScalingConfiguration) {
            this.autoScalingConfiguration = autoScalingConfiguration;
            return this;
        }

        public UpdateAutoScalingConfigurationResponse build() {
            return new UpdateAutoScalingConfigurationResponse(this.etag, this.opcRequestId, this.autoScalingConfiguration);
        }

        public String toString() {
            return "UpdateAutoScalingConfigurationResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", autoScalingConfiguration=" + this.autoScalingConfiguration + ")";
        }
    }
}

