/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.budget;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.budget.BudgetAsync;
import com.oracle.bmc.budget.internal.http.CreateAlertRuleConverter;
import com.oracle.bmc.budget.internal.http.CreateBudgetConverter;
import com.oracle.bmc.budget.internal.http.DeleteAlertRuleConverter;
import com.oracle.bmc.budget.internal.http.DeleteBudgetConverter;
import com.oracle.bmc.budget.internal.http.GetAlertRuleConverter;
import com.oracle.bmc.budget.internal.http.GetBudgetConverter;
import com.oracle.bmc.budget.internal.http.ListAlertRulesConverter;
import com.oracle.bmc.budget.internal.http.ListBudgetsConverter;
import com.oracle.bmc.budget.internal.http.UpdateAlertRuleConverter;
import com.oracle.bmc.budget.internal.http.UpdateBudgetConverter;
import com.oracle.bmc.budget.requests.CreateAlertRuleRequest;
import com.oracle.bmc.budget.requests.CreateBudgetRequest;
import com.oracle.bmc.budget.requests.DeleteAlertRuleRequest;
import com.oracle.bmc.budget.requests.DeleteBudgetRequest;
import com.oracle.bmc.budget.requests.GetAlertRuleRequest;
import com.oracle.bmc.budget.requests.GetBudgetRequest;
import com.oracle.bmc.budget.requests.ListAlertRulesRequest;
import com.oracle.bmc.budget.requests.ListBudgetsRequest;
import com.oracle.bmc.budget.requests.UpdateAlertRuleRequest;
import com.oracle.bmc.budget.requests.UpdateBudgetRequest;
import com.oracle.bmc.budget.responses.CreateAlertRuleResponse;
import com.oracle.bmc.budget.responses.CreateBudgetResponse;
import com.oracle.bmc.budget.responses.DeleteAlertRuleResponse;
import com.oracle.bmc.budget.responses.DeleteBudgetResponse;
import com.oracle.bmc.budget.responses.GetAlertRuleResponse;
import com.oracle.bmc.budget.responses.GetBudgetResponse;
import com.oracle.bmc.budget.responses.ListAlertRulesResponse;
import com.oracle.bmc.budget.responses.ListBudgetsResponse;
import com.oracle.bmc.budget.responses.UpdateAlertRuleResponse;
import com.oracle.bmc.budget.responses.UpdateBudgetResponse;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.ErrorConsumer;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.SuccessConsumer;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenTransformingFuture;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrappingAsyncHandler;
import com.oracle.bmc.util.internal.TransformingFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BudgetAsyncClient
implements BudgetAsync {
    private static final Logger LOG = LoggerFactory.getLogger(BudgetAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("BUDGET").serviceEndpointPrefix("").serviceEndpointTemplate("https://usage.{region}.oci.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public BudgetAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public BudgetAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public BudgetAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public BudgetAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public BudgetAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public BudgetAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public BudgetAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)((Object)this.authenticationDetailsProvider)).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional<String> endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(SERVICE, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<CreateAlertRuleResponse> createAlertRule(CreateAlertRuleRequest request, AsyncHandler<CreateAlertRuleRequest, CreateAlertRuleResponse> handler) {
        LOG.trace("Called async createAlertRule");
        final CreateAlertRuleRequest interceptedRequest = CreateAlertRuleConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateAlertRuleConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateAlertRuleResponse> transformer = CreateAlertRuleConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateAlertRuleRequest, CreateAlertRuleResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateAlertRuleRequest, CreateAlertRuleResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateAlertRuleRequest, CreateAlertRuleResponse> onSuccess = new SuccessConsumer<CreateAlertRuleRequest, CreateAlertRuleResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateAlertRuleRequest> onError = new ErrorConsumer<CreateAlertRuleRequest>(this, interceptedRequest);
                    BudgetAsyncClient.this.client.post(ib, interceptedRequest.getCreateAlertRuleDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateAlertRuleRequest, CreateAlertRuleResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateAlertRuleRequest, CreateAlertRuleResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateAlertRuleRequest> onError = handler == null ? null : new ErrorConsumer<CreateAlertRuleRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateAlertRuleDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateAlertRuleResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BudgetAsyncClient.this.client.post(ib, interceptedRequest.getCreateAlertRuleDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateAlertRuleResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateBudgetResponse> createBudget(CreateBudgetRequest request, AsyncHandler<CreateBudgetRequest, CreateBudgetResponse> handler) {
        LOG.trace("Called async createBudget");
        final CreateBudgetRequest interceptedRequest = CreateBudgetConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateBudgetConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateBudgetResponse> transformer = CreateBudgetConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateBudgetRequest, CreateBudgetResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateBudgetRequest, CreateBudgetResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateBudgetRequest, CreateBudgetResponse> onSuccess = new SuccessConsumer<CreateBudgetRequest, CreateBudgetResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateBudgetRequest> onError = new ErrorConsumer<CreateBudgetRequest>(this, interceptedRequest);
                    BudgetAsyncClient.this.client.post(ib, interceptedRequest.getCreateBudgetDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateBudgetRequest, CreateBudgetResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateBudgetRequest, CreateBudgetResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateBudgetRequest> onError = handler == null ? null : new ErrorConsumer<CreateBudgetRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateBudgetDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateBudgetResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BudgetAsyncClient.this.client.post(ib, interceptedRequest.getCreateBudgetDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateBudgetResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteAlertRuleResponse> deleteAlertRule(DeleteAlertRuleRequest request, AsyncHandler<DeleteAlertRuleRequest, DeleteAlertRuleResponse> handler) {
        LOG.trace("Called async deleteAlertRule");
        final DeleteAlertRuleRequest interceptedRequest = DeleteAlertRuleConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteAlertRuleConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteAlertRuleResponse> transformer = DeleteAlertRuleConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteAlertRuleRequest, DeleteAlertRuleResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteAlertRuleRequest, DeleteAlertRuleResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteAlertRuleRequest, DeleteAlertRuleResponse> onSuccess = new SuccessConsumer<DeleteAlertRuleRequest, DeleteAlertRuleResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteAlertRuleRequest> onError = new ErrorConsumer<DeleteAlertRuleRequest>(this, interceptedRequest);
                    BudgetAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteAlertRuleRequest, DeleteAlertRuleResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteAlertRuleRequest, DeleteAlertRuleResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteAlertRuleRequest> onError = handler == null ? null : new ErrorConsumer<DeleteAlertRuleRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteAlertRuleResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BudgetAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteAlertRuleResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteBudgetResponse> deleteBudget(DeleteBudgetRequest request, AsyncHandler<DeleteBudgetRequest, DeleteBudgetResponse> handler) {
        LOG.trace("Called async deleteBudget");
        final DeleteBudgetRequest interceptedRequest = DeleteBudgetConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteBudgetConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteBudgetResponse> transformer = DeleteBudgetConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteBudgetRequest, DeleteBudgetResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteBudgetRequest, DeleteBudgetResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteBudgetRequest, DeleteBudgetResponse> onSuccess = new SuccessConsumer<DeleteBudgetRequest, DeleteBudgetResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteBudgetRequest> onError = new ErrorConsumer<DeleteBudgetRequest>(this, interceptedRequest);
                    BudgetAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteBudgetRequest, DeleteBudgetResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteBudgetRequest, DeleteBudgetResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteBudgetRequest> onError = handler == null ? null : new ErrorConsumer<DeleteBudgetRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteBudgetResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BudgetAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteBudgetResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetAlertRuleResponse> getAlertRule(GetAlertRuleRequest request, AsyncHandler<GetAlertRuleRequest, GetAlertRuleResponse> handler) {
        LOG.trace("Called async getAlertRule");
        final GetAlertRuleRequest interceptedRequest = GetAlertRuleConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetAlertRuleConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetAlertRuleResponse> transformer = GetAlertRuleConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetAlertRuleRequest, GetAlertRuleResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetAlertRuleRequest, GetAlertRuleResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetAlertRuleRequest, GetAlertRuleResponse> onSuccess = new SuccessConsumer<GetAlertRuleRequest, GetAlertRuleResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetAlertRuleRequest> onError = new ErrorConsumer<GetAlertRuleRequest>(this, interceptedRequest);
                    BudgetAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetAlertRuleRequest, GetAlertRuleResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetAlertRuleRequest, GetAlertRuleResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetAlertRuleRequest> onError = handler == null ? null : new ErrorConsumer<GetAlertRuleRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetAlertRuleResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BudgetAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetAlertRuleResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetBudgetResponse> getBudget(GetBudgetRequest request, AsyncHandler<GetBudgetRequest, GetBudgetResponse> handler) {
        LOG.trace("Called async getBudget");
        final GetBudgetRequest interceptedRequest = GetBudgetConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetBudgetConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetBudgetResponse> transformer = GetBudgetConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetBudgetRequest, GetBudgetResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetBudgetRequest, GetBudgetResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetBudgetRequest, GetBudgetResponse> onSuccess = new SuccessConsumer<GetBudgetRequest, GetBudgetResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetBudgetRequest> onError = new ErrorConsumer<GetBudgetRequest>(this, interceptedRequest);
                    BudgetAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetBudgetRequest, GetBudgetResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetBudgetRequest, GetBudgetResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetBudgetRequest> onError = handler == null ? null : new ErrorConsumer<GetBudgetRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetBudgetResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BudgetAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetBudgetResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListAlertRulesResponse> listAlertRules(ListAlertRulesRequest request, AsyncHandler<ListAlertRulesRequest, ListAlertRulesResponse> handler) {
        LOG.trace("Called async listAlertRules");
        final ListAlertRulesRequest interceptedRequest = ListAlertRulesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListAlertRulesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListAlertRulesResponse> transformer = ListAlertRulesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListAlertRulesRequest, ListAlertRulesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListAlertRulesRequest, ListAlertRulesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListAlertRulesRequest, ListAlertRulesResponse> onSuccess = new SuccessConsumer<ListAlertRulesRequest, ListAlertRulesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListAlertRulesRequest> onError = new ErrorConsumer<ListAlertRulesRequest>(this, interceptedRequest);
                    BudgetAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListAlertRulesRequest, ListAlertRulesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListAlertRulesRequest, ListAlertRulesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListAlertRulesRequest> onError = handler == null ? null : new ErrorConsumer<ListAlertRulesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListAlertRulesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BudgetAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListAlertRulesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListBudgetsResponse> listBudgets(ListBudgetsRequest request, AsyncHandler<ListBudgetsRequest, ListBudgetsResponse> handler) {
        LOG.trace("Called async listBudgets");
        final ListBudgetsRequest interceptedRequest = ListBudgetsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListBudgetsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListBudgetsResponse> transformer = ListBudgetsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListBudgetsRequest, ListBudgetsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListBudgetsRequest, ListBudgetsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListBudgetsRequest, ListBudgetsResponse> onSuccess = new SuccessConsumer<ListBudgetsRequest, ListBudgetsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListBudgetsRequest> onError = new ErrorConsumer<ListBudgetsRequest>(this, interceptedRequest);
                    BudgetAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListBudgetsRequest, ListBudgetsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListBudgetsRequest, ListBudgetsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListBudgetsRequest> onError = handler == null ? null : new ErrorConsumer<ListBudgetsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListBudgetsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BudgetAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListBudgetsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateAlertRuleResponse> updateAlertRule(UpdateAlertRuleRequest request, AsyncHandler<UpdateAlertRuleRequest, UpdateAlertRuleResponse> handler) {
        LOG.trace("Called async updateAlertRule");
        final UpdateAlertRuleRequest interceptedRequest = UpdateAlertRuleConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateAlertRuleConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateAlertRuleResponse> transformer = UpdateAlertRuleConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateAlertRuleRequest, UpdateAlertRuleResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateAlertRuleRequest, UpdateAlertRuleResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateAlertRuleRequest, UpdateAlertRuleResponse> onSuccess = new SuccessConsumer<UpdateAlertRuleRequest, UpdateAlertRuleResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateAlertRuleRequest> onError = new ErrorConsumer<UpdateAlertRuleRequest>(this, interceptedRequest);
                    BudgetAsyncClient.this.client.put(ib, interceptedRequest.getUpdateAlertRuleDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateAlertRuleRequest, UpdateAlertRuleResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateAlertRuleRequest, UpdateAlertRuleResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateAlertRuleRequest> onError = handler == null ? null : new ErrorConsumer<UpdateAlertRuleRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateAlertRuleDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateAlertRuleResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BudgetAsyncClient.this.client.put(ib, interceptedRequest.getUpdateAlertRuleDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateAlertRuleResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateBudgetResponse> updateBudget(UpdateBudgetRequest request, AsyncHandler<UpdateBudgetRequest, UpdateBudgetResponse> handler) {
        LOG.trace("Called async updateBudget");
        final UpdateBudgetRequest interceptedRequest = UpdateBudgetConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateBudgetConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateBudgetResponse> transformer = UpdateBudgetConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateBudgetRequest, UpdateBudgetResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateBudgetRequest, UpdateBudgetResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateBudgetRequest, UpdateBudgetResponse> onSuccess = new SuccessConsumer<UpdateBudgetRequest, UpdateBudgetResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateBudgetRequest> onError = new ErrorConsumer<UpdateBudgetRequest>(this, interceptedRequest);
                    BudgetAsyncClient.this.client.put(ib, interceptedRequest.getUpdateBudgetDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateBudgetRequest, UpdateBudgetResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateBudgetRequest, UpdateBudgetResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateBudgetRequest> onError = handler == null ? null : new ErrorConsumer<UpdateBudgetRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateBudgetDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateBudgetResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BudgetAsyncClient.this.client.put(ib, interceptedRequest.getUpdateBudgetDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateBudgetResponse>(responseFuture, transformer);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, BudgetAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        @Override
        public BudgetAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new BudgetAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

