/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.budget.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum SortOrder {
    Asc("ASC"),
    Desc("DESC");

    private final String value;
    private static Map<String, SortOrder> map;

    private SortOrder(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    @JsonCreator
    public static SortOrder create(String key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        throw new RuntimeException("Invalid SortOrder: " + key);
    }

    static {
        map = new HashMap<String, SortOrder>();
        for (SortOrder v : SortOrder.values()) {
            map.put(v.getValue(), v);
        }
    }
}

