/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.budget.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetBudgetRequest
extends BmcRequest {
    private String budgetId;
    private String opcRequestId;

    @ConstructorProperties(value={"budgetId", "opcRequestId"})
    GetBudgetRequest(String budgetId, String opcRequestId) {
        this.budgetId = budgetId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getBudgetId() {
        return this.budgetId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private String budgetId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetBudgetRequest o) {
            this.budgetId(o.getBudgetId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetBudgetRequest build() {
            GetBudgetRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder budgetId(String budgetId) {
            this.budgetId = budgetId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetBudgetRequest buildWithoutInvocationCallback() {
            return new GetBudgetRequest(this.budgetId, this.opcRequestId);
        }

        public String toString() {
            return "GetBudgetRequest.Builder(budgetId=" + this.budgetId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

