/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.budget.requests;

import com.oracle.bmc.budget.model.UpdateAlertRuleDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateAlertRuleRequest
extends BmcRequest {
    private String budgetId;
    private String alertRuleId;
    private UpdateAlertRuleDetails updateAlertRuleDetails;
    private String ifMatch;
    private String opcRequestId;

    @ConstructorProperties(value={"budgetId", "alertRuleId", "updateAlertRuleDetails", "ifMatch", "opcRequestId"})
    UpdateAlertRuleRequest(String budgetId, String alertRuleId, UpdateAlertRuleDetails updateAlertRuleDetails, String ifMatch, String opcRequestId) {
        this.budgetId = budgetId;
        this.alertRuleId = alertRuleId;
        this.updateAlertRuleDetails = updateAlertRuleDetails;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getBudgetId() {
        return this.budgetId;
    }

    public String getAlertRuleId() {
        return this.alertRuleId;
    }

    public UpdateAlertRuleDetails getUpdateAlertRuleDetails() {
        return this.updateAlertRuleDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private String budgetId;
        private String alertRuleId;
        private UpdateAlertRuleDetails updateAlertRuleDetails;
        private String ifMatch;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateAlertRuleRequest o) {
            this.budgetId(o.getBudgetId());
            this.alertRuleId(o.getAlertRuleId());
            this.updateAlertRuleDetails(o.getUpdateAlertRuleDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateAlertRuleRequest build() {
            UpdateAlertRuleRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder budgetId(String budgetId) {
            this.budgetId = budgetId;
            return this;
        }

        public Builder alertRuleId(String alertRuleId) {
            this.alertRuleId = alertRuleId;
            return this;
        }

        public Builder updateAlertRuleDetails(UpdateAlertRuleDetails updateAlertRuleDetails) {
            this.updateAlertRuleDetails = updateAlertRuleDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public UpdateAlertRuleRequest buildWithoutInvocationCallback() {
            return new UpdateAlertRuleRequest(this.budgetId, this.alertRuleId, this.updateAlertRuleDetails, this.ifMatch, this.opcRequestId);
        }

        public String toString() {
            return "UpdateAlertRuleRequest.Builder(budgetId=" + this.budgetId + ", alertRuleId=" + this.alertRuleId + ", updateAlertRuleDetails=" + this.updateAlertRuleDetails + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

