/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.budget.responses;

import com.oracle.bmc.budget.model.AlertRule;
import java.beans.ConstructorProperties;

public class CreateAlertRuleResponse {
    private String opcRequestId;
    private String etag;
    private AlertRule alertRule;

    @ConstructorProperties(value={"opcRequestId", "etag", "alertRule"})
    CreateAlertRuleResponse(String opcRequestId, String etag, AlertRule alertRule) {
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.alertRule = alertRule;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public AlertRule getAlertRule() {
        return this.alertRule;
    }

    public static class Builder {
        private String opcRequestId;
        private String etag;
        private AlertRule alertRule;

        public Builder copy(CreateAlertRuleResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.alertRule(o.getAlertRule());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder alertRule(AlertRule alertRule) {
            this.alertRule = alertRule;
            return this;
        }

        public CreateAlertRuleResponse build() {
            return new CreateAlertRuleResponse(this.opcRequestId, this.etag, this.alertRule);
        }

        public String toString() {
            return "CreateAlertRuleResponse.Builder(opcRequestId=" + this.opcRequestId + ", etag=" + this.etag + ", alertRule=" + this.alertRule + ")";
        }
    }
}

