/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.budget.responses;

import com.oracle.bmc.budget.model.Budget;
import java.beans.ConstructorProperties;

public class CreateBudgetResponse {
    private String opcRequestId;
    private String etag;
    private Budget budget;

    @ConstructorProperties(value={"opcRequestId", "etag", "budget"})
    CreateBudgetResponse(String opcRequestId, String etag, Budget budget) {
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.budget = budget;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public Budget getBudget() {
        return this.budget;
    }

    public static class Builder {
        private String opcRequestId;
        private String etag;
        private Budget budget;

        public Builder copy(CreateBudgetResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.budget(o.getBudget());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder budget(Budget budget) {
            this.budget = budget;
            return this;
        }

        public CreateBudgetResponse build() {
            return new CreateBudgetResponse(this.opcRequestId, this.etag, this.budget);
        }

        public String toString() {
            return "CreateBudgetResponse.Builder(opcRequestId=" + this.opcRequestId + ", etag=" + this.etag + ", budget=" + this.budget + ")";
        }
    }
}

