/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.budget.responses;

import com.oracle.bmc.budget.model.Budget;
import java.beans.ConstructorProperties;

public class GetBudgetResponse {
    private String etag;
    private String opcRequestId;
    private Budget budget;

    @ConstructorProperties(value={"etag", "opcRequestId", "budget"})
    GetBudgetResponse(String etag, String opcRequestId, Budget budget) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.budget = budget;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Budget getBudget() {
        return this.budget;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private Budget budget;

        public Builder copy(GetBudgetResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.budget(o.getBudget());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder budget(Budget budget) {
            this.budget = budget;
            return this;
        }

        public GetBudgetResponse build() {
            return new GetBudgetResponse(this.etag, this.opcRequestId, this.budget);
        }

        public String toString() {
            return "GetBudgetResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", budget=" + this.budget + ")";
        }
    }
}

