/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.budget.responses;

import com.oracle.bmc.budget.model.AlertRuleSummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListAlertRulesResponse {
    private String opcRequestId;
    private String opcNextPage;
    private List<AlertRuleSummary> items;

    @ConstructorProperties(value={"opcRequestId", "opcNextPage", "items"})
    ListAlertRulesResponse(String opcRequestId, String opcNextPage, List<AlertRuleSummary> items) {
        this.opcRequestId = opcRequestId;
        this.opcNextPage = opcNextPage;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public List<AlertRuleSummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcRequestId;
        private String opcNextPage;
        private List<AlertRuleSummary> items;

        public Builder copy(ListAlertRulesResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.opcNextPage(o.getOpcNextPage());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder items(List<AlertRuleSummary> items) {
            this.items = items;
            return this;
        }

        public ListAlertRulesResponse build() {
            return new ListAlertRulesResponse(this.opcRequestId, this.opcNextPage, this.items);
        }

        public String toString() {
            return "ListAlertRulesResponse.Builder(opcRequestId=" + this.opcRequestId + ", opcNextPage=" + this.opcNextPage + ", items=" + this.items + ")";
        }
    }
}

