/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.budget.responses;

import com.oracle.bmc.budget.model.BudgetSummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListBudgetsResponse {
    private String opcRequestId;
    private String opcNextPage;
    private List<BudgetSummary> items;

    @ConstructorProperties(value={"opcRequestId", "opcNextPage", "items"})
    ListBudgetsResponse(String opcRequestId, String opcNextPage, List<BudgetSummary> items) {
        this.opcRequestId = opcRequestId;
        this.opcNextPage = opcNextPage;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public List<BudgetSummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcRequestId;
        private String opcNextPage;
        private List<BudgetSummary> items;

        public Builder copy(ListBudgetsResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.opcNextPage(o.getOpcNextPage());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder items(List<BudgetSummary> items) {
            this.items = items;
            return this;
        }

        public ListBudgetsResponse build() {
            return new ListBudgetsResponse(this.opcRequestId, this.opcNextPage, this.items);
        }

        public String toString() {
            return "ListBudgetsResponse.Builder(opcRequestId=" + this.opcRequestId + ", opcNextPage=" + this.opcNextPage + ", items=" + this.items + ")";
        }
    }
}

