/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.containerengine.ContainerEngineAsync;
import com.oracle.bmc.containerengine.internal.http.CreateClusterConverter;
import com.oracle.bmc.containerengine.internal.http.CreateKubeconfigConverter;
import com.oracle.bmc.containerengine.internal.http.CreateNodePoolConverter;
import com.oracle.bmc.containerengine.internal.http.DeleteClusterConverter;
import com.oracle.bmc.containerengine.internal.http.DeleteNodePoolConverter;
import com.oracle.bmc.containerengine.internal.http.DeleteWorkRequestConverter;
import com.oracle.bmc.containerengine.internal.http.GetClusterConverter;
import com.oracle.bmc.containerengine.internal.http.GetClusterOptionsConverter;
import com.oracle.bmc.containerengine.internal.http.GetNodePoolConverter;
import com.oracle.bmc.containerengine.internal.http.GetNodePoolOptionsConverter;
import com.oracle.bmc.containerengine.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.containerengine.internal.http.ListClustersConverter;
import com.oracle.bmc.containerengine.internal.http.ListNodePoolsConverter;
import com.oracle.bmc.containerengine.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.containerengine.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.containerengine.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.containerengine.internal.http.UpdateClusterConverter;
import com.oracle.bmc.containerengine.internal.http.UpdateNodePoolConverter;
import com.oracle.bmc.containerengine.requests.CreateClusterRequest;
import com.oracle.bmc.containerengine.requests.CreateKubeconfigRequest;
import com.oracle.bmc.containerengine.requests.CreateNodePoolRequest;
import com.oracle.bmc.containerengine.requests.DeleteClusterRequest;
import com.oracle.bmc.containerengine.requests.DeleteNodePoolRequest;
import com.oracle.bmc.containerengine.requests.DeleteWorkRequestRequest;
import com.oracle.bmc.containerengine.requests.GetClusterOptionsRequest;
import com.oracle.bmc.containerengine.requests.GetClusterRequest;
import com.oracle.bmc.containerengine.requests.GetNodePoolOptionsRequest;
import com.oracle.bmc.containerengine.requests.GetNodePoolRequest;
import com.oracle.bmc.containerengine.requests.GetWorkRequestRequest;
import com.oracle.bmc.containerengine.requests.ListClustersRequest;
import com.oracle.bmc.containerengine.requests.ListNodePoolsRequest;
import com.oracle.bmc.containerengine.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.containerengine.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.containerengine.requests.ListWorkRequestsRequest;
import com.oracle.bmc.containerengine.requests.UpdateClusterRequest;
import com.oracle.bmc.containerengine.requests.UpdateNodePoolRequest;
import com.oracle.bmc.containerengine.responses.CreateClusterResponse;
import com.oracle.bmc.containerengine.responses.CreateKubeconfigResponse;
import com.oracle.bmc.containerengine.responses.CreateNodePoolResponse;
import com.oracle.bmc.containerengine.responses.DeleteClusterResponse;
import com.oracle.bmc.containerengine.responses.DeleteNodePoolResponse;
import com.oracle.bmc.containerengine.responses.DeleteWorkRequestResponse;
import com.oracle.bmc.containerengine.responses.GetClusterOptionsResponse;
import com.oracle.bmc.containerengine.responses.GetClusterResponse;
import com.oracle.bmc.containerengine.responses.GetNodePoolOptionsResponse;
import com.oracle.bmc.containerengine.responses.GetNodePoolResponse;
import com.oracle.bmc.containerengine.responses.GetWorkRequestResponse;
import com.oracle.bmc.containerengine.responses.ListClustersResponse;
import com.oracle.bmc.containerengine.responses.ListNodePoolsResponse;
import com.oracle.bmc.containerengine.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.containerengine.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.containerengine.responses.ListWorkRequestsResponse;
import com.oracle.bmc.containerengine.responses.UpdateClusterResponse;
import com.oracle.bmc.containerengine.responses.UpdateNodePoolResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.ErrorConsumer;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.SuccessConsumer;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenTransformingFuture;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrappingAsyncHandler;
import com.oracle.bmc.util.internal.TransformingFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerEngineAsyncClient
implements ContainerEngineAsync {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerEngineAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("CONTAINERENGINE").serviceEndpointPrefix("containerengine").serviceEndpointTemplate("https://containerengine.{region}.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public ContainerEngineAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public ContainerEngineAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public ContainerEngineAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public ContainerEngineAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public ContainerEngineAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public ContainerEngineAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public ContainerEngineAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)((Object)this.authenticationDetailsProvider)).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional<String> endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(SERVICE, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<CreateClusterResponse> createCluster(CreateClusterRequest request, AsyncHandler<CreateClusterRequest, CreateClusterResponse> handler) {
        LOG.trace("Called async createCluster");
        final CreateClusterRequest interceptedRequest = CreateClusterConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateClusterConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateClusterResponse> transformer = CreateClusterConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateClusterRequest, CreateClusterResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateClusterRequest, CreateClusterResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateClusterRequest, CreateClusterResponse> onSuccess = new SuccessConsumer<CreateClusterRequest, CreateClusterResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateClusterRequest> onError = new ErrorConsumer<CreateClusterRequest>(this, interceptedRequest);
                    ContainerEngineAsyncClient.this.client.post(ib, interceptedRequest.getCreateClusterDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateClusterRequest, CreateClusterResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateClusterRequest, CreateClusterResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateClusterRequest> onError = handler == null ? null : new ErrorConsumer<CreateClusterRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateClusterDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateClusterResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ContainerEngineAsyncClient.this.client.post(ib, interceptedRequest.getCreateClusterDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateClusterResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateKubeconfigResponse> createKubeconfig(CreateKubeconfigRequest request, AsyncHandler<CreateKubeconfigRequest, CreateKubeconfigResponse> handler) {
        LOG.trace("Called async createKubeconfig");
        final CreateKubeconfigRequest interceptedRequest = CreateKubeconfigConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateKubeconfigConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateKubeconfigResponse> transformer = CreateKubeconfigConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateKubeconfigRequest, CreateKubeconfigResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateKubeconfigRequest, CreateKubeconfigResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateKubeconfigRequest, CreateKubeconfigResponse> onSuccess = new SuccessConsumer<CreateKubeconfigRequest, CreateKubeconfigResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateKubeconfigRequest> onError = new ErrorConsumer<CreateKubeconfigRequest>(this, interceptedRequest);
                    ContainerEngineAsyncClient.this.client.post(ib, interceptedRequest.getCreateClusterKubeconfigContentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateKubeconfigRequest, CreateKubeconfigResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateKubeconfigRequest, CreateKubeconfigResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateKubeconfigRequest> onError = handler == null ? null : new ErrorConsumer<CreateKubeconfigRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateClusterKubeconfigContentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateKubeconfigResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ContainerEngineAsyncClient.this.client.post(ib, interceptedRequest.getCreateClusterKubeconfigContentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateKubeconfigResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateNodePoolResponse> createNodePool(CreateNodePoolRequest request, AsyncHandler<CreateNodePoolRequest, CreateNodePoolResponse> handler) {
        LOG.trace("Called async createNodePool");
        final CreateNodePoolRequest interceptedRequest = CreateNodePoolConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateNodePoolConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateNodePoolResponse> transformer = CreateNodePoolConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateNodePoolRequest, CreateNodePoolResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateNodePoolRequest, CreateNodePoolResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateNodePoolRequest, CreateNodePoolResponse> onSuccess = new SuccessConsumer<CreateNodePoolRequest, CreateNodePoolResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateNodePoolRequest> onError = new ErrorConsumer<CreateNodePoolRequest>(this, interceptedRequest);
                    ContainerEngineAsyncClient.this.client.post(ib, interceptedRequest.getCreateNodePoolDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateNodePoolRequest, CreateNodePoolResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateNodePoolRequest, CreateNodePoolResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateNodePoolRequest> onError = handler == null ? null : new ErrorConsumer<CreateNodePoolRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateNodePoolDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateNodePoolResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ContainerEngineAsyncClient.this.client.post(ib, interceptedRequest.getCreateNodePoolDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateNodePoolResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteClusterResponse> deleteCluster(DeleteClusterRequest request, AsyncHandler<DeleteClusterRequest, DeleteClusterResponse> handler) {
        LOG.trace("Called async deleteCluster");
        final DeleteClusterRequest interceptedRequest = DeleteClusterConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteClusterConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteClusterResponse> transformer = DeleteClusterConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteClusterRequest, DeleteClusterResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteClusterRequest, DeleteClusterResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteClusterRequest, DeleteClusterResponse> onSuccess = new SuccessConsumer<DeleteClusterRequest, DeleteClusterResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteClusterRequest> onError = new ErrorConsumer<DeleteClusterRequest>(this, interceptedRequest);
                    ContainerEngineAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteClusterRequest, DeleteClusterResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteClusterRequest, DeleteClusterResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteClusterRequest> onError = handler == null ? null : new ErrorConsumer<DeleteClusterRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteClusterResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ContainerEngineAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteClusterResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteNodePoolResponse> deleteNodePool(DeleteNodePoolRequest request, AsyncHandler<DeleteNodePoolRequest, DeleteNodePoolResponse> handler) {
        LOG.trace("Called async deleteNodePool");
        final DeleteNodePoolRequest interceptedRequest = DeleteNodePoolConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteNodePoolConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteNodePoolResponse> transformer = DeleteNodePoolConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteNodePoolRequest, DeleteNodePoolResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteNodePoolRequest, DeleteNodePoolResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteNodePoolRequest, DeleteNodePoolResponse> onSuccess = new SuccessConsumer<DeleteNodePoolRequest, DeleteNodePoolResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteNodePoolRequest> onError = new ErrorConsumer<DeleteNodePoolRequest>(this, interceptedRequest);
                    ContainerEngineAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteNodePoolRequest, DeleteNodePoolResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteNodePoolRequest, DeleteNodePoolResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteNodePoolRequest> onError = handler == null ? null : new ErrorConsumer<DeleteNodePoolRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteNodePoolResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ContainerEngineAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteNodePoolResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteWorkRequestResponse> deleteWorkRequest(DeleteWorkRequestRequest request, AsyncHandler<DeleteWorkRequestRequest, DeleteWorkRequestResponse> handler) {
        LOG.trace("Called async deleteWorkRequest");
        final DeleteWorkRequestRequest interceptedRequest = DeleteWorkRequestConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteWorkRequestResponse> transformer = DeleteWorkRequestConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteWorkRequestRequest, DeleteWorkRequestResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteWorkRequestRequest, DeleteWorkRequestResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteWorkRequestRequest, DeleteWorkRequestResponse> onSuccess = new SuccessConsumer<DeleteWorkRequestRequest, DeleteWorkRequestResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteWorkRequestRequest> onError = new ErrorConsumer<DeleteWorkRequestRequest>(this, interceptedRequest);
                    ContainerEngineAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteWorkRequestRequest, DeleteWorkRequestResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteWorkRequestRequest, DeleteWorkRequestResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteWorkRequestRequest> onError = handler == null ? null : new ErrorConsumer<DeleteWorkRequestRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteWorkRequestResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ContainerEngineAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteWorkRequestResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetClusterResponse> getCluster(GetClusterRequest request, AsyncHandler<GetClusterRequest, GetClusterResponse> handler) {
        LOG.trace("Called async getCluster");
        final GetClusterRequest interceptedRequest = GetClusterConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetClusterConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetClusterResponse> transformer = GetClusterConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetClusterRequest, GetClusterResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetClusterRequest, GetClusterResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetClusterRequest, GetClusterResponse> onSuccess = new SuccessConsumer<GetClusterRequest, GetClusterResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetClusterRequest> onError = new ErrorConsumer<GetClusterRequest>(this, interceptedRequest);
                    ContainerEngineAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetClusterRequest, GetClusterResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetClusterRequest, GetClusterResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetClusterRequest> onError = handler == null ? null : new ErrorConsumer<GetClusterRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetClusterResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ContainerEngineAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetClusterResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetClusterOptionsResponse> getClusterOptions(GetClusterOptionsRequest request, AsyncHandler<GetClusterOptionsRequest, GetClusterOptionsResponse> handler) {
        LOG.trace("Called async getClusterOptions");
        final GetClusterOptionsRequest interceptedRequest = GetClusterOptionsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetClusterOptionsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetClusterOptionsResponse> transformer = GetClusterOptionsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetClusterOptionsRequest, GetClusterOptionsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetClusterOptionsRequest, GetClusterOptionsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetClusterOptionsRequest, GetClusterOptionsResponse> onSuccess = new SuccessConsumer<GetClusterOptionsRequest, GetClusterOptionsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetClusterOptionsRequest> onError = new ErrorConsumer<GetClusterOptionsRequest>(this, interceptedRequest);
                    ContainerEngineAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetClusterOptionsRequest, GetClusterOptionsResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetClusterOptionsRequest, GetClusterOptionsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetClusterOptionsRequest> onError = handler == null ? null : new ErrorConsumer<GetClusterOptionsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetClusterOptionsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ContainerEngineAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetClusterOptionsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetNodePoolResponse> getNodePool(GetNodePoolRequest request, AsyncHandler<GetNodePoolRequest, GetNodePoolResponse> handler) {
        LOG.trace("Called async getNodePool");
        final GetNodePoolRequest interceptedRequest = GetNodePoolConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetNodePoolConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetNodePoolResponse> transformer = GetNodePoolConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetNodePoolRequest, GetNodePoolResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetNodePoolRequest, GetNodePoolResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetNodePoolRequest, GetNodePoolResponse> onSuccess = new SuccessConsumer<GetNodePoolRequest, GetNodePoolResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetNodePoolRequest> onError = new ErrorConsumer<GetNodePoolRequest>(this, interceptedRequest);
                    ContainerEngineAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetNodePoolRequest, GetNodePoolResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetNodePoolRequest, GetNodePoolResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetNodePoolRequest> onError = handler == null ? null : new ErrorConsumer<GetNodePoolRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetNodePoolResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ContainerEngineAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetNodePoolResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetNodePoolOptionsResponse> getNodePoolOptions(GetNodePoolOptionsRequest request, AsyncHandler<GetNodePoolOptionsRequest, GetNodePoolOptionsResponse> handler) {
        LOG.trace("Called async getNodePoolOptions");
        final GetNodePoolOptionsRequest interceptedRequest = GetNodePoolOptionsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetNodePoolOptionsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetNodePoolOptionsResponse> transformer = GetNodePoolOptionsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetNodePoolOptionsRequest, GetNodePoolOptionsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetNodePoolOptionsRequest, GetNodePoolOptionsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetNodePoolOptionsRequest, GetNodePoolOptionsResponse> onSuccess = new SuccessConsumer<GetNodePoolOptionsRequest, GetNodePoolOptionsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetNodePoolOptionsRequest> onError = new ErrorConsumer<GetNodePoolOptionsRequest>(this, interceptedRequest);
                    ContainerEngineAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetNodePoolOptionsRequest, GetNodePoolOptionsResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetNodePoolOptionsRequest, GetNodePoolOptionsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetNodePoolOptionsRequest> onError = handler == null ? null : new ErrorConsumer<GetNodePoolOptionsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetNodePoolOptionsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ContainerEngineAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetNodePoolOptionsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        LOG.trace("Called async getWorkRequest");
        final GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetWorkRequestRequest, GetWorkRequestResponse> onSuccess = new SuccessConsumer<GetWorkRequestRequest, GetWorkRequestResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetWorkRequestRequest> onError = new ErrorConsumer<GetWorkRequestRequest>(this, interceptedRequest);
                    ContainerEngineAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetWorkRequestRequest, GetWorkRequestResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetWorkRequestRequest, GetWorkRequestResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetWorkRequestRequest> onError = handler == null ? null : new ErrorConsumer<GetWorkRequestRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetWorkRequestResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ContainerEngineAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetWorkRequestResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListClustersResponse> listClusters(ListClustersRequest request, AsyncHandler<ListClustersRequest, ListClustersResponse> handler) {
        LOG.trace("Called async listClusters");
        final ListClustersRequest interceptedRequest = ListClustersConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListClustersConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListClustersResponse> transformer = ListClustersConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListClustersRequest, ListClustersResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListClustersRequest, ListClustersResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListClustersRequest, ListClustersResponse> onSuccess = new SuccessConsumer<ListClustersRequest, ListClustersResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListClustersRequest> onError = new ErrorConsumer<ListClustersRequest>(this, interceptedRequest);
                    ContainerEngineAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListClustersRequest, ListClustersResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListClustersRequest, ListClustersResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListClustersRequest> onError = handler == null ? null : new ErrorConsumer<ListClustersRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListClustersResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ContainerEngineAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListClustersResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListNodePoolsResponse> listNodePools(ListNodePoolsRequest request, AsyncHandler<ListNodePoolsRequest, ListNodePoolsResponse> handler) {
        LOG.trace("Called async listNodePools");
        final ListNodePoolsRequest interceptedRequest = ListNodePoolsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListNodePoolsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListNodePoolsResponse> transformer = ListNodePoolsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListNodePoolsRequest, ListNodePoolsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListNodePoolsRequest, ListNodePoolsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListNodePoolsRequest, ListNodePoolsResponse> onSuccess = new SuccessConsumer<ListNodePoolsRequest, ListNodePoolsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListNodePoolsRequest> onError = new ErrorConsumer<ListNodePoolsRequest>(this, interceptedRequest);
                    ContainerEngineAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListNodePoolsRequest, ListNodePoolsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListNodePoolsRequest, ListNodePoolsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListNodePoolsRequest> onError = handler == null ? null : new ErrorConsumer<ListNodePoolsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListNodePoolsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ContainerEngineAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListNodePoolsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        LOG.trace("Called async listWorkRequestErrors");
        final ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> onSuccess = new SuccessConsumer<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListWorkRequestErrorsRequest> onError = new ErrorConsumer<ListWorkRequestErrorsRequest>(this, interceptedRequest);
                    ContainerEngineAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListWorkRequestErrorsRequest> onError = handler == null ? null : new ErrorConsumer<ListWorkRequestErrorsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListWorkRequestErrorsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ContainerEngineAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListWorkRequestErrorsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        LOG.trace("Called async listWorkRequestLogs");
        final ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> onSuccess = new SuccessConsumer<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListWorkRequestLogsRequest> onError = new ErrorConsumer<ListWorkRequestLogsRequest>(this, interceptedRequest);
                    ContainerEngineAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListWorkRequestLogsRequest> onError = handler == null ? null : new ErrorConsumer<ListWorkRequestLogsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListWorkRequestLogsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ContainerEngineAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListWorkRequestLogsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        LOG.trace("Called async listWorkRequests");
        final ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListWorkRequestsRequest, ListWorkRequestsResponse> onSuccess = new SuccessConsumer<ListWorkRequestsRequest, ListWorkRequestsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListWorkRequestsRequest> onError = new ErrorConsumer<ListWorkRequestsRequest>(this, interceptedRequest);
                    ContainerEngineAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListWorkRequestsRequest, ListWorkRequestsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListWorkRequestsRequest, ListWorkRequestsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListWorkRequestsRequest> onError = handler == null ? null : new ErrorConsumer<ListWorkRequestsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListWorkRequestsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ContainerEngineAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListWorkRequestsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateClusterResponse> updateCluster(UpdateClusterRequest request, AsyncHandler<UpdateClusterRequest, UpdateClusterResponse> handler) {
        LOG.trace("Called async updateCluster");
        final UpdateClusterRequest interceptedRequest = UpdateClusterConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateClusterConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateClusterResponse> transformer = UpdateClusterConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateClusterRequest, UpdateClusterResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateClusterRequest, UpdateClusterResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateClusterRequest, UpdateClusterResponse> onSuccess = new SuccessConsumer<UpdateClusterRequest, UpdateClusterResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateClusterRequest> onError = new ErrorConsumer<UpdateClusterRequest>(this, interceptedRequest);
                    ContainerEngineAsyncClient.this.client.put(ib, interceptedRequest.getUpdateClusterDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateClusterRequest, UpdateClusterResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateClusterRequest, UpdateClusterResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateClusterRequest> onError = handler == null ? null : new ErrorConsumer<UpdateClusterRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateClusterDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateClusterResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ContainerEngineAsyncClient.this.client.put(ib, interceptedRequest.getUpdateClusterDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateClusterResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateNodePoolResponse> updateNodePool(UpdateNodePoolRequest request, AsyncHandler<UpdateNodePoolRequest, UpdateNodePoolResponse> handler) {
        LOG.trace("Called async updateNodePool");
        final UpdateNodePoolRequest interceptedRequest = UpdateNodePoolConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateNodePoolConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateNodePoolResponse> transformer = UpdateNodePoolConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateNodePoolRequest, UpdateNodePoolResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateNodePoolRequest, UpdateNodePoolResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateNodePoolRequest, UpdateNodePoolResponse> onSuccess = new SuccessConsumer<UpdateNodePoolRequest, UpdateNodePoolResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateNodePoolRequest> onError = new ErrorConsumer<UpdateNodePoolRequest>(this, interceptedRequest);
                    ContainerEngineAsyncClient.this.client.put(ib, interceptedRequest.getUpdateNodePoolDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateNodePoolRequest, UpdateNodePoolResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateNodePoolRequest, UpdateNodePoolResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateNodePoolRequest> onError = handler == null ? null : new ErrorConsumer<UpdateNodePoolRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateNodePoolDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateNodePoolResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ContainerEngineAsyncClient.this.client.put(ib, interceptedRequest.getUpdateNodePoolDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateNodePoolResponse>(responseFuture, transformer);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ContainerEngineAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        @Override
        public ContainerEngineAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new ContainerEngineAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

