/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.containerengine.ContainerEngine;
import com.oracle.bmc.containerengine.model.ClusterSummary;
import com.oracle.bmc.containerengine.model.NodePoolSummary;
import com.oracle.bmc.containerengine.model.WorkRequestSummary;
import com.oracle.bmc.containerengine.requests.ListClustersRequest;
import com.oracle.bmc.containerengine.requests.ListNodePoolsRequest;
import com.oracle.bmc.containerengine.requests.ListWorkRequestsRequest;
import com.oracle.bmc.containerengine.responses.ListClustersResponse;
import com.oracle.bmc.containerengine.responses.ListNodePoolsResponse;
import com.oracle.bmc.containerengine.responses.ListWorkRequestsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class ContainerEnginePaginators {
    private final ContainerEngine client;

    public Iterable<ListClustersResponse> listClustersResponseIterator(final ListClustersRequest request) {
        return new ResponseIterable<ListClustersRequest.Builder, ListClustersRequest, ListClustersResponse>(new Supplier<ListClustersRequest.Builder>(){

            public ListClustersRequest.Builder get() {
                return ListClustersRequest.builder().copy(request);
            }
        }, new Function<ListClustersResponse, String>(){

            public String apply(ListClustersResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListClustersRequest.Builder>, ListClustersRequest>(){

            public ListClustersRequest apply(RequestBuilderAndToken<ListClustersRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListClustersRequest, ListClustersResponse>(){

            public ListClustersResponse apply(ListClustersRequest request) {
                return ContainerEnginePaginators.this.client.listClusters(request);
            }
        });
    }

    public Iterable<ClusterSummary> listClustersRecordIterator(final ListClustersRequest request) {
        return new ResponseRecordIterable<ListClustersRequest.Builder, ListClustersRequest, ListClustersResponse, ClusterSummary>(new Supplier<ListClustersRequest.Builder>(){

            public ListClustersRequest.Builder get() {
                return ListClustersRequest.builder().copy(request);
            }
        }, new Function<ListClustersResponse, String>(){

            public String apply(ListClustersResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListClustersRequest.Builder>, ListClustersRequest>(){

            public ListClustersRequest apply(RequestBuilderAndToken<ListClustersRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListClustersRequest, ListClustersResponse>(){

            public ListClustersResponse apply(ListClustersRequest request) {
                return ContainerEnginePaginators.this.client.listClusters(request);
            }
        }, new Function<ListClustersResponse, List<ClusterSummary>>(){

            public List<ClusterSummary> apply(ListClustersResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListNodePoolsResponse> listNodePoolsResponseIterator(final ListNodePoolsRequest request) {
        return new ResponseIterable<ListNodePoolsRequest.Builder, ListNodePoolsRequest, ListNodePoolsResponse>(new Supplier<ListNodePoolsRequest.Builder>(){

            public ListNodePoolsRequest.Builder get() {
                return ListNodePoolsRequest.builder().copy(request);
            }
        }, new Function<ListNodePoolsResponse, String>(){

            public String apply(ListNodePoolsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListNodePoolsRequest.Builder>, ListNodePoolsRequest>(){

            public ListNodePoolsRequest apply(RequestBuilderAndToken<ListNodePoolsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListNodePoolsRequest, ListNodePoolsResponse>(){

            public ListNodePoolsResponse apply(ListNodePoolsRequest request) {
                return ContainerEnginePaginators.this.client.listNodePools(request);
            }
        });
    }

    public Iterable<NodePoolSummary> listNodePoolsRecordIterator(final ListNodePoolsRequest request) {
        return new ResponseRecordIterable<ListNodePoolsRequest.Builder, ListNodePoolsRequest, ListNodePoolsResponse, NodePoolSummary>(new Supplier<ListNodePoolsRequest.Builder>(){

            public ListNodePoolsRequest.Builder get() {
                return ListNodePoolsRequest.builder().copy(request);
            }
        }, new Function<ListNodePoolsResponse, String>(){

            public String apply(ListNodePoolsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListNodePoolsRequest.Builder>, ListNodePoolsRequest>(){

            public ListNodePoolsRequest apply(RequestBuilderAndToken<ListNodePoolsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListNodePoolsRequest, ListNodePoolsResponse>(){

            public ListNodePoolsResponse apply(ListNodePoolsRequest request) {
                return ContainerEnginePaginators.this.client.listNodePools(request);
            }
        }, new Function<ListNodePoolsResponse, List<NodePoolSummary>>(){

            public List<NodePoolSummary> apply(ListNodePoolsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable<ListWorkRequestsRequest.Builder, ListWorkRequestsRequest, ListWorkRequestsResponse>(new Supplier<ListWorkRequestsRequest.Builder>(){

            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, new Function<ListWorkRequestsResponse, String>(){

            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return ContainerEnginePaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable<ListWorkRequestsRequest.Builder, ListWorkRequestsRequest, ListWorkRequestsResponse, WorkRequestSummary>(new Supplier<ListWorkRequestsRequest.Builder>(){

            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, new Function<ListWorkRequestsResponse, String>(){

            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return ContainerEnginePaginators.this.client.listWorkRequests(request);
            }
        }, new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public ContainerEnginePaginators(ContainerEngine client) {
        this.client = client;
    }
}

