/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.oracle.bmc.containerengine.ContainerEngine;
import com.oracle.bmc.containerengine.model.ClusterLifecycleState;
import com.oracle.bmc.containerengine.requests.GetClusterRequest;
import com.oracle.bmc.containerengine.requests.GetWorkRequestRequest;
import com.oracle.bmc.containerengine.responses.GetClusterResponse;
import com.oracle.bmc.containerengine.responses.GetWorkRequestResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.Validate;

public class ContainerEngineWaiters {
    private final ExecutorService executorService;
    private final ContainerEngine client;

    public Waiter<GetClusterRequest, GetClusterResponse> forCluster(GetClusterRequest request, ClusterLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forCluster(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetClusterRequest, GetClusterResponse> forCluster(GetClusterRequest request, ClusterLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forCluster(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetClusterRequest, GetClusterResponse> forCluster(GetClusterRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ClusterLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forCluster(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetClusterRequest, GetClusterResponse> forCluster(BmcGenericWaiter waiter, GetClusterRequest request, ClusterLifecycleState ... targetStates) {
        final HashSet<ClusterLifecycleState> targetStatesSet = new HashSet<ClusterLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetClusterRequest, GetClusterResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetClusterRequest, GetClusterResponse>(){

            public GetClusterResponse apply(GetClusterRequest request) {
                return ContainerEngineWaiters.this.client.getCluster(request);
            }
        }, new Predicate<GetClusterResponse>(){

            public boolean apply(GetClusterResponse response) {
                return targetStatesSet.contains((Object)response.getCluster().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)ClusterLifecycleState.Deleted)), request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter(terminationStrategy, delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl<GetWorkRequestRequest, GetWorkRequestResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return ContainerEngineWaiters.this.client.getWorkRequest(request);
            }
        }, new Predicate<GetWorkRequestResponse>(){

            public boolean apply(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), request);
    }

    @ConstructorProperties(value={"executorService", "client"})
    public ContainerEngineWaiters(ExecutorService executorService, ContainerEngine client) {
        this.executorService = executorService;
        this.client = client;
    }
}

