/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.containerengine.requests.CreateKubeconfigRequest;
import com.oracle.bmc.containerengine.responses.CreateKubeconfigResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.io.InputStream;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateKubeconfigConverter {
    private static final Logger LOG = LoggerFactory.getLogger(CreateKubeconfigConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static CreateKubeconfigRequest interceptRequest(CreateKubeconfigRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, CreateKubeconfigRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getClusterId(), (String)"clusterId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20180222").path("clusters").path(HttpUtils.encodePathSegment(request.getClusterId())).path("kubeconfig").path("content");
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/x-yaml");
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, CreateKubeconfigResponse> fromResponse() {
        Function<Response, CreateKubeconfigResponse> transformer = new Function<Response, CreateKubeconfigResponse>(){

            public CreateKubeconfigResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for CreateKubeconfigResponse");
                Function<Response, WithHeaders<InputStream>> responseFn = RESPONSE_CONVERSION_FACTORY.create(InputStream.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                CreateKubeconfigResponse.Builder builder = CreateKubeconfigResponse.builder();
                builder.inputStream((InputStream)response.getItem());
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                CreateKubeconfigResponse responseWrapper = builder.build();
                return responseWrapper;
            }
        };
        return transformer;
    }
}

