/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.containerengine.model.NodePoolOptions;
import com.oracle.bmc.containerengine.requests.GetNodePoolOptionsRequest;
import com.oracle.bmc.containerengine.responses.GetNodePoolOptionsResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetNodePoolOptionsConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetNodePoolOptionsConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetNodePoolOptionsRequest interceptRequest(GetNodePoolOptionsRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetNodePoolOptionsRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getNodePoolOptionId(), (String)"nodePoolOptionId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20180222").path("nodePoolOptions").path(HttpUtils.encodePathSegment(request.getNodePoolOptionId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GetNodePoolOptionsResponse> fromResponse() {
        Function<Response, GetNodePoolOptionsResponse> transformer = new Function<Response, GetNodePoolOptionsResponse>(){

            public GetNodePoolOptionsResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for GetNodePoolOptionsResponse");
                Function<Response, WithHeaders<NodePoolOptions>> responseFn = RESPONSE_CONVERSION_FACTORY.create(NodePoolOptions.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                GetNodePoolOptionsResponse.Builder builder = GetNodePoolOptionsResponse.builder();
                builder.nodePoolOptions((NodePoolOptions)response.getItem());
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                GetNodePoolOptionsResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

