/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.containerengine.model.WorkRequestError;
import com.oracle.bmc.containerengine.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.containerengine.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListWorkRequestErrorsConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListWorkRequestErrorsConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListWorkRequestErrorsRequest interceptRequest(ListWorkRequestErrorsRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListWorkRequestErrorsRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCompartmentId(), (String)"compartmentId is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20180222").path("workRequests").path(HttpUtils.encodePathSegment(request.getWorkRequestId())).path("errors");
        target = target.queryParam("compartmentId", HttpUtils.attemptEncodeQueryParam(request.getCompartmentId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, ListWorkRequestErrorsResponse> fromResponse() {
        Function<Response, ListWorkRequestErrorsResponse> transformer = new Function<Response, ListWorkRequestErrorsResponse>(){

            public ListWorkRequestErrorsResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for ListWorkRequestErrorsResponse");
                Function<Response, WithHeaders<List<WorkRequestError>>> responseFn = RESPONSE_CONVERSION_FACTORY.create(new GenericType<List<WorkRequestError>>(){});
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                ListWorkRequestErrorsResponse.Builder builder = ListWorkRequestErrorsResponse.builder();
                builder.items((List)response.getItem());
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                ListWorkRequestErrorsResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

