/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine.requests;

import com.oracle.bmc.containerengine.model.CreateClusterDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateClusterRequest
extends BmcRequest {
    private CreateClusterDetails createClusterDetails;
    private String opcRetryToken;
    private String opcRequestId;

    @ConstructorProperties(value={"createClusterDetails", "opcRetryToken", "opcRequestId"})
    CreateClusterRequest(CreateClusterDetails createClusterDetails, String opcRetryToken, String opcRequestId) {
        this.createClusterDetails = createClusterDetails;
        this.opcRetryToken = opcRetryToken;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CreateClusterDetails getCreateClusterDetails() {
        return this.createClusterDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private CreateClusterDetails createClusterDetails;
        private String opcRetryToken;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateClusterRequest o) {
            this.createClusterDetails(o.getCreateClusterDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateClusterRequest build() {
            CreateClusterRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder createClusterDetails(CreateClusterDetails createClusterDetails) {
            this.createClusterDetails = createClusterDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public CreateClusterRequest buildWithoutInvocationCallback() {
            return new CreateClusterRequest(this.createClusterDetails, this.opcRetryToken, this.opcRequestId);
        }

        public String toString() {
            return "CreateClusterRequest.Builder(createClusterDetails=" + this.createClusterDetails + ", opcRetryToken=" + this.opcRetryToken + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

