/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine.requests;

import com.oracle.bmc.containerengine.model.CreateNodePoolDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateNodePoolRequest
extends BmcRequest {
    private CreateNodePoolDetails createNodePoolDetails;
    private String opcRetryToken;
    private String opcRequestId;

    @ConstructorProperties(value={"createNodePoolDetails", "opcRetryToken", "opcRequestId"})
    CreateNodePoolRequest(CreateNodePoolDetails createNodePoolDetails, String opcRetryToken, String opcRequestId) {
        this.createNodePoolDetails = createNodePoolDetails;
        this.opcRetryToken = opcRetryToken;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CreateNodePoolDetails getCreateNodePoolDetails() {
        return this.createNodePoolDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private CreateNodePoolDetails createNodePoolDetails;
        private String opcRetryToken;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateNodePoolRequest o) {
            this.createNodePoolDetails(o.getCreateNodePoolDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateNodePoolRequest build() {
            CreateNodePoolRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder createNodePoolDetails(CreateNodePoolDetails createNodePoolDetails) {
            this.createNodePoolDetails = createNodePoolDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public CreateNodePoolRequest buildWithoutInvocationCallback() {
            return new CreateNodePoolRequest(this.createNodePoolDetails, this.opcRetryToken, this.opcRequestId);
        }

        public String toString() {
            return "CreateNodePoolRequest.Builder(createNodePoolDetails=" + this.createNodePoolDetails + ", opcRetryToken=" + this.opcRetryToken + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

