/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteNodePoolRequest
extends BmcRequest {
    private String nodePoolId;
    private String ifMatch;
    private String opcRequestId;

    @ConstructorProperties(value={"nodePoolId", "ifMatch", "opcRequestId"})
    DeleteNodePoolRequest(String nodePoolId, String ifMatch, String opcRequestId) {
        this.nodePoolId = nodePoolId;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNodePoolId() {
        return this.nodePoolId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private String nodePoolId;
        private String ifMatch;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteNodePoolRequest o) {
            this.nodePoolId(o.getNodePoolId());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteNodePoolRequest build() {
            DeleteNodePoolRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder nodePoolId(String nodePoolId) {
            this.nodePoolId = nodePoolId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public DeleteNodePoolRequest buildWithoutInvocationCallback() {
            return new DeleteNodePoolRequest(this.nodePoolId, this.ifMatch, this.opcRequestId);
        }

        public String toString() {
            return "DeleteNodePoolRequest.Builder(nodePoolId=" + this.nodePoolId + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

