/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetNodePoolOptionsRequest
extends BmcRequest {
    private String nodePoolOptionId;
    private String opcRequestId;

    @ConstructorProperties(value={"nodePoolOptionId", "opcRequestId"})
    GetNodePoolOptionsRequest(String nodePoolOptionId, String opcRequestId) {
        this.nodePoolOptionId = nodePoolOptionId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNodePoolOptionId() {
        return this.nodePoolOptionId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private String nodePoolOptionId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetNodePoolOptionsRequest o) {
            this.nodePoolOptionId(o.getNodePoolOptionId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetNodePoolOptionsRequest build() {
            GetNodePoolOptionsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder nodePoolOptionId(String nodePoolOptionId) {
            this.nodePoolOptionId = nodePoolOptionId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetNodePoolOptionsRequest buildWithoutInvocationCallback() {
            return new GetNodePoolOptionsRequest(this.nodePoolOptionId, this.opcRequestId);
        }

        public String toString() {
            return "GetNodePoolOptionsRequest.Builder(nodePoolOptionId=" + this.nodePoolOptionId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

