/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListWorkRequestErrorsRequest
extends BmcRequest {
    private String compartmentId;
    private String workRequestId;
    private String opcRequestId;

    @ConstructorProperties(value={"compartmentId", "workRequestId", "opcRequestId"})
    ListWorkRequestErrorsRequest(String compartmentId, String workRequestId, String opcRequestId) {
        this.compartmentId = compartmentId;
        this.workRequestId = workRequestId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getWorkRequestId() {
        return this.workRequestId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private String compartmentId;
        private String workRequestId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListWorkRequestErrorsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.workRequestId(o.getWorkRequestId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListWorkRequestErrorsRequest build() {
            ListWorkRequestErrorsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder workRequestId(String workRequestId) {
            this.workRequestId = workRequestId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ListWorkRequestErrorsRequest buildWithoutInvocationCallback() {
            return new ListWorkRequestErrorsRequest(this.compartmentId, this.workRequestId, this.opcRequestId);
        }

        public String toString() {
            return "ListWorkRequestErrorsRequest.Builder(compartmentId=" + this.compartmentId + ", workRequestId=" + this.workRequestId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

