/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine.requests;

import com.oracle.bmc.containerengine.model.UpdateClusterDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateClusterRequest
extends BmcRequest {
    private String clusterId;
    private UpdateClusterDetails updateClusterDetails;
    private String ifMatch;
    private String opcRequestId;

    @ConstructorProperties(value={"clusterId", "updateClusterDetails", "ifMatch", "opcRequestId"})
    UpdateClusterRequest(String clusterId, UpdateClusterDetails updateClusterDetails, String ifMatch, String opcRequestId) {
        this.clusterId = clusterId;
        this.updateClusterDetails = updateClusterDetails;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public UpdateClusterDetails getUpdateClusterDetails() {
        return this.updateClusterDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private String clusterId;
        private UpdateClusterDetails updateClusterDetails;
        private String ifMatch;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateClusterRequest o) {
            this.clusterId(o.getClusterId());
            this.updateClusterDetails(o.getUpdateClusterDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateClusterRequest build() {
            UpdateClusterRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public Builder updateClusterDetails(UpdateClusterDetails updateClusterDetails) {
            this.updateClusterDetails = updateClusterDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public UpdateClusterRequest buildWithoutInvocationCallback() {
            return new UpdateClusterRequest(this.clusterId, this.updateClusterDetails, this.ifMatch, this.opcRequestId);
        }

        public String toString() {
            return "UpdateClusterRequest.Builder(clusterId=" + this.clusterId + ", updateClusterDetails=" + this.updateClusterDetails + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

