/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine.responses;

import java.beans.ConstructorProperties;
import java.io.InputStream;

public class CreateKubeconfigResponse {
    private String opcRequestId;
    private InputStream inputStream;

    @ConstructorProperties(value={"opcRequestId", "inputStream"})
    CreateKubeconfigResponse(String opcRequestId, InputStream inputStream) {
        this.opcRequestId = opcRequestId;
        this.inputStream = inputStream;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public static class Builder {
        private String opcRequestId;
        private InputStream inputStream;

        public Builder copy(CreateKubeconfigResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.inputStream(o.getInputStream());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder inputStream(InputStream inputStream) {
            this.inputStream = inputStream;
            return this;
        }

        public CreateKubeconfigResponse build() {
            return new CreateKubeconfigResponse(this.opcRequestId, this.inputStream);
        }

        public String toString() {
            return "CreateKubeconfigResponse.Builder(opcRequestId=" + this.opcRequestId + ", inputStream=" + this.inputStream + ")";
        }
    }
}

