/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine.responses;

import com.oracle.bmc.containerengine.model.ClusterOptions;
import java.beans.ConstructorProperties;

public class GetClusterOptionsResponse {
    private String opcRequestId;
    private ClusterOptions clusterOptions;

    @ConstructorProperties(value={"opcRequestId", "clusterOptions"})
    GetClusterOptionsResponse(String opcRequestId, ClusterOptions clusterOptions) {
        this.opcRequestId = opcRequestId;
        this.clusterOptions = clusterOptions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public ClusterOptions getClusterOptions() {
        return this.clusterOptions;
    }

    public static class Builder {
        private String opcRequestId;
        private ClusterOptions clusterOptions;

        public Builder copy(GetClusterOptionsResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.clusterOptions(o.getClusterOptions());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder clusterOptions(ClusterOptions clusterOptions) {
            this.clusterOptions = clusterOptions;
            return this;
        }

        public GetClusterOptionsResponse build() {
            return new GetClusterOptionsResponse(this.opcRequestId, this.clusterOptions);
        }

        public String toString() {
            return "GetClusterOptionsResponse.Builder(opcRequestId=" + this.opcRequestId + ", clusterOptions=" + this.clusterOptions + ")";
        }
    }
}

