/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine.responses;

import com.oracle.bmc.containerengine.model.Cluster;
import java.beans.ConstructorProperties;

public class GetClusterResponse {
    private String etag;
    private String opcRequestId;
    private Cluster cluster;

    @ConstructorProperties(value={"etag", "opcRequestId", "cluster"})
    GetClusterResponse(String etag, String opcRequestId, Cluster cluster) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.cluster = cluster;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private Cluster cluster;

        public Builder copy(GetClusterResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.cluster(o.getCluster());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder cluster(Cluster cluster) {
            this.cluster = cluster;
            return this;
        }

        public GetClusterResponse build() {
            return new GetClusterResponse(this.etag, this.opcRequestId, this.cluster);
        }

        public String toString() {
            return "GetClusterResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", cluster=" + this.cluster + ")";
        }
    }
}

