/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine.responses;

import com.oracle.bmc.containerengine.model.WorkRequest;
import java.beans.ConstructorProperties;

public class GetWorkRequestResponse {
    private String etag;
    private String opcRequestId;
    private Integer retryAfter;
    private WorkRequest workRequest;

    @ConstructorProperties(value={"etag", "opcRequestId", "retryAfter", "workRequest"})
    GetWorkRequestResponse(String etag, String opcRequestId, Integer retryAfter, WorkRequest workRequest) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.retryAfter = retryAfter;
        this.workRequest = workRequest;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Integer getRetryAfter() {
        return this.retryAfter;
    }

    public WorkRequest getWorkRequest() {
        return this.workRequest;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private Integer retryAfter;
        private WorkRequest workRequest;

        public Builder copy(GetWorkRequestResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.retryAfter(o.getRetryAfter());
            this.workRequest(o.getWorkRequest());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder retryAfter(Integer retryAfter) {
            this.retryAfter = retryAfter;
            return this;
        }

        public Builder workRequest(WorkRequest workRequest) {
            this.workRequest = workRequest;
            return this;
        }

        public GetWorkRequestResponse build() {
            return new GetWorkRequestResponse(this.etag, this.opcRequestId, this.retryAfter, this.workRequest);
        }

        public String toString() {
            return "GetWorkRequestResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", retryAfter=" + this.retryAfter + ", workRequest=" + this.workRequest + ")";
        }
    }
}

