/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine.responses;

import com.oracle.bmc.containerengine.model.WorkRequestError;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListWorkRequestErrorsResponse {
    private String opcRequestId;
    private List<WorkRequestError> items;

    @ConstructorProperties(value={"opcRequestId", "items"})
    ListWorkRequestErrorsResponse(String opcRequestId, List<WorkRequestError> items) {
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<WorkRequestError> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcRequestId;
        private List<WorkRequestError> items;

        public Builder copy(ListWorkRequestErrorsResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<WorkRequestError> items) {
            this.items = items;
            return this;
        }

        public ListWorkRequestErrorsResponse build() {
            return new ListWorkRequestErrorsResponse(this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListWorkRequestErrorsResponse.Builder(opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

