/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine.responses;

import com.oracle.bmc.containerengine.model.WorkRequestLogEntry;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListWorkRequestLogsResponse {
    private String opcRequestId;
    private List<WorkRequestLogEntry> items;

    @ConstructorProperties(value={"opcRequestId", "items"})
    ListWorkRequestLogsResponse(String opcRequestId, List<WorkRequestLogEntry> items) {
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<WorkRequestLogEntry> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcRequestId;
        private List<WorkRequestLogEntry> items;

        public Builder copy(ListWorkRequestLogsResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<WorkRequestLogEntry> items) {
            this.items = items;
            return this;
        }

        public ListWorkRequestLogsResponse build() {
            return new ListWorkRequestLogsResponse(this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListWorkRequestLogsResponse.Builder(opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

