/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.core.BlockstorageAsync;
import com.oracle.bmc.core.internal.http.ChangeBootVolumeBackupCompartmentConverter;
import com.oracle.bmc.core.internal.http.ChangeBootVolumeCompartmentConverter;
import com.oracle.bmc.core.internal.http.ChangeVolumeBackupCompartmentConverter;
import com.oracle.bmc.core.internal.http.ChangeVolumeCompartmentConverter;
import com.oracle.bmc.core.internal.http.ChangeVolumeGroupBackupCompartmentConverter;
import com.oracle.bmc.core.internal.http.ChangeVolumeGroupCompartmentConverter;
import com.oracle.bmc.core.internal.http.CopyVolumeBackupConverter;
import com.oracle.bmc.core.internal.http.CreateBootVolumeBackupConverter;
import com.oracle.bmc.core.internal.http.CreateBootVolumeConverter;
import com.oracle.bmc.core.internal.http.CreateVolumeBackupConverter;
import com.oracle.bmc.core.internal.http.CreateVolumeBackupPolicyAssignmentConverter;
import com.oracle.bmc.core.internal.http.CreateVolumeBackupPolicyConverter;
import com.oracle.bmc.core.internal.http.CreateVolumeConverter;
import com.oracle.bmc.core.internal.http.CreateVolumeGroupBackupConverter;
import com.oracle.bmc.core.internal.http.CreateVolumeGroupConverter;
import com.oracle.bmc.core.internal.http.DeleteBootVolumeBackupConverter;
import com.oracle.bmc.core.internal.http.DeleteBootVolumeConverter;
import com.oracle.bmc.core.internal.http.DeleteBootVolumeKmsKeyConverter;
import com.oracle.bmc.core.internal.http.DeleteVolumeBackupConverter;
import com.oracle.bmc.core.internal.http.DeleteVolumeBackupPolicyAssignmentConverter;
import com.oracle.bmc.core.internal.http.DeleteVolumeBackupPolicyConverter;
import com.oracle.bmc.core.internal.http.DeleteVolumeConverter;
import com.oracle.bmc.core.internal.http.DeleteVolumeGroupBackupConverter;
import com.oracle.bmc.core.internal.http.DeleteVolumeGroupConverter;
import com.oracle.bmc.core.internal.http.DeleteVolumeKmsKeyConverter;
import com.oracle.bmc.core.internal.http.GetBootVolumeBackupConverter;
import com.oracle.bmc.core.internal.http.GetBootVolumeConverter;
import com.oracle.bmc.core.internal.http.GetBootVolumeKmsKeyConverter;
import com.oracle.bmc.core.internal.http.GetVolumeBackupConverter;
import com.oracle.bmc.core.internal.http.GetVolumeBackupPolicyAssetAssignmentConverter;
import com.oracle.bmc.core.internal.http.GetVolumeBackupPolicyAssignmentConverter;
import com.oracle.bmc.core.internal.http.GetVolumeBackupPolicyConverter;
import com.oracle.bmc.core.internal.http.GetVolumeConverter;
import com.oracle.bmc.core.internal.http.GetVolumeGroupBackupConverter;
import com.oracle.bmc.core.internal.http.GetVolumeGroupConverter;
import com.oracle.bmc.core.internal.http.GetVolumeKmsKeyConverter;
import com.oracle.bmc.core.internal.http.ListBootVolumeBackupsConverter;
import com.oracle.bmc.core.internal.http.ListBootVolumesConverter;
import com.oracle.bmc.core.internal.http.ListVolumeBackupPoliciesConverter;
import com.oracle.bmc.core.internal.http.ListVolumeBackupsConverter;
import com.oracle.bmc.core.internal.http.ListVolumeGroupBackupsConverter;
import com.oracle.bmc.core.internal.http.ListVolumeGroupsConverter;
import com.oracle.bmc.core.internal.http.ListVolumesConverter;
import com.oracle.bmc.core.internal.http.UpdateBootVolumeBackupConverter;
import com.oracle.bmc.core.internal.http.UpdateBootVolumeConverter;
import com.oracle.bmc.core.internal.http.UpdateBootVolumeKmsKeyConverter;
import com.oracle.bmc.core.internal.http.UpdateVolumeBackupConverter;
import com.oracle.bmc.core.internal.http.UpdateVolumeBackupPolicyConverter;
import com.oracle.bmc.core.internal.http.UpdateVolumeConverter;
import com.oracle.bmc.core.internal.http.UpdateVolumeGroupBackupConverter;
import com.oracle.bmc.core.internal.http.UpdateVolumeGroupConverter;
import com.oracle.bmc.core.internal.http.UpdateVolumeKmsKeyConverter;
import com.oracle.bmc.core.requests.ChangeBootVolumeBackupCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeBootVolumeCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeVolumeBackupCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeVolumeCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeVolumeGroupBackupCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeVolumeGroupCompartmentRequest;
import com.oracle.bmc.core.requests.CopyVolumeBackupRequest;
import com.oracle.bmc.core.requests.CreateBootVolumeBackupRequest;
import com.oracle.bmc.core.requests.CreateBootVolumeRequest;
import com.oracle.bmc.core.requests.CreateVolumeBackupPolicyAssignmentRequest;
import com.oracle.bmc.core.requests.CreateVolumeBackupPolicyRequest;
import com.oracle.bmc.core.requests.CreateVolumeBackupRequest;
import com.oracle.bmc.core.requests.CreateVolumeGroupBackupRequest;
import com.oracle.bmc.core.requests.CreateVolumeGroupRequest;
import com.oracle.bmc.core.requests.CreateVolumeRequest;
import com.oracle.bmc.core.requests.DeleteBootVolumeBackupRequest;
import com.oracle.bmc.core.requests.DeleteBootVolumeKmsKeyRequest;
import com.oracle.bmc.core.requests.DeleteBootVolumeRequest;
import com.oracle.bmc.core.requests.DeleteVolumeBackupPolicyAssignmentRequest;
import com.oracle.bmc.core.requests.DeleteVolumeBackupPolicyRequest;
import com.oracle.bmc.core.requests.DeleteVolumeBackupRequest;
import com.oracle.bmc.core.requests.DeleteVolumeGroupBackupRequest;
import com.oracle.bmc.core.requests.DeleteVolumeGroupRequest;
import com.oracle.bmc.core.requests.DeleteVolumeKmsKeyRequest;
import com.oracle.bmc.core.requests.DeleteVolumeRequest;
import com.oracle.bmc.core.requests.GetBootVolumeBackupRequest;
import com.oracle.bmc.core.requests.GetBootVolumeKmsKeyRequest;
import com.oracle.bmc.core.requests.GetBootVolumeRequest;
import com.oracle.bmc.core.requests.GetVolumeBackupPolicyAssetAssignmentRequest;
import com.oracle.bmc.core.requests.GetVolumeBackupPolicyAssignmentRequest;
import com.oracle.bmc.core.requests.GetVolumeBackupPolicyRequest;
import com.oracle.bmc.core.requests.GetVolumeBackupRequest;
import com.oracle.bmc.core.requests.GetVolumeGroupBackupRequest;
import com.oracle.bmc.core.requests.GetVolumeGroupRequest;
import com.oracle.bmc.core.requests.GetVolumeKmsKeyRequest;
import com.oracle.bmc.core.requests.GetVolumeRequest;
import com.oracle.bmc.core.requests.ListBootVolumeBackupsRequest;
import com.oracle.bmc.core.requests.ListBootVolumesRequest;
import com.oracle.bmc.core.requests.ListVolumeBackupPoliciesRequest;
import com.oracle.bmc.core.requests.ListVolumeBackupsRequest;
import com.oracle.bmc.core.requests.ListVolumeGroupBackupsRequest;
import com.oracle.bmc.core.requests.ListVolumeGroupsRequest;
import com.oracle.bmc.core.requests.ListVolumesRequest;
import com.oracle.bmc.core.requests.UpdateBootVolumeBackupRequest;
import com.oracle.bmc.core.requests.UpdateBootVolumeKmsKeyRequest;
import com.oracle.bmc.core.requests.UpdateBootVolumeRequest;
import com.oracle.bmc.core.requests.UpdateVolumeBackupPolicyRequest;
import com.oracle.bmc.core.requests.UpdateVolumeBackupRequest;
import com.oracle.bmc.core.requests.UpdateVolumeGroupBackupRequest;
import com.oracle.bmc.core.requests.UpdateVolumeGroupRequest;
import com.oracle.bmc.core.requests.UpdateVolumeKmsKeyRequest;
import com.oracle.bmc.core.requests.UpdateVolumeRequest;
import com.oracle.bmc.core.responses.ChangeBootVolumeBackupCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeBootVolumeCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeVolumeBackupCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeVolumeCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeVolumeGroupBackupCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeVolumeGroupCompartmentResponse;
import com.oracle.bmc.core.responses.CopyVolumeBackupResponse;
import com.oracle.bmc.core.responses.CreateBootVolumeBackupResponse;
import com.oracle.bmc.core.responses.CreateBootVolumeResponse;
import com.oracle.bmc.core.responses.CreateVolumeBackupPolicyAssignmentResponse;
import com.oracle.bmc.core.responses.CreateVolumeBackupPolicyResponse;
import com.oracle.bmc.core.responses.CreateVolumeBackupResponse;
import com.oracle.bmc.core.responses.CreateVolumeGroupBackupResponse;
import com.oracle.bmc.core.responses.CreateVolumeGroupResponse;
import com.oracle.bmc.core.responses.CreateVolumeResponse;
import com.oracle.bmc.core.responses.DeleteBootVolumeBackupResponse;
import com.oracle.bmc.core.responses.DeleteBootVolumeKmsKeyResponse;
import com.oracle.bmc.core.responses.DeleteBootVolumeResponse;
import com.oracle.bmc.core.responses.DeleteVolumeBackupPolicyAssignmentResponse;
import com.oracle.bmc.core.responses.DeleteVolumeBackupPolicyResponse;
import com.oracle.bmc.core.responses.DeleteVolumeBackupResponse;
import com.oracle.bmc.core.responses.DeleteVolumeGroupBackupResponse;
import com.oracle.bmc.core.responses.DeleteVolumeGroupResponse;
import com.oracle.bmc.core.responses.DeleteVolumeKmsKeyResponse;
import com.oracle.bmc.core.responses.DeleteVolumeResponse;
import com.oracle.bmc.core.responses.GetBootVolumeBackupResponse;
import com.oracle.bmc.core.responses.GetBootVolumeKmsKeyResponse;
import com.oracle.bmc.core.responses.GetBootVolumeResponse;
import com.oracle.bmc.core.responses.GetVolumeBackupPolicyAssetAssignmentResponse;
import com.oracle.bmc.core.responses.GetVolumeBackupPolicyAssignmentResponse;
import com.oracle.bmc.core.responses.GetVolumeBackupPolicyResponse;
import com.oracle.bmc.core.responses.GetVolumeBackupResponse;
import com.oracle.bmc.core.responses.GetVolumeGroupBackupResponse;
import com.oracle.bmc.core.responses.GetVolumeGroupResponse;
import com.oracle.bmc.core.responses.GetVolumeKmsKeyResponse;
import com.oracle.bmc.core.responses.GetVolumeResponse;
import com.oracle.bmc.core.responses.ListBootVolumeBackupsResponse;
import com.oracle.bmc.core.responses.ListBootVolumesResponse;
import com.oracle.bmc.core.responses.ListVolumeBackupPoliciesResponse;
import com.oracle.bmc.core.responses.ListVolumeBackupsResponse;
import com.oracle.bmc.core.responses.ListVolumeGroupBackupsResponse;
import com.oracle.bmc.core.responses.ListVolumeGroupsResponse;
import com.oracle.bmc.core.responses.ListVolumesResponse;
import com.oracle.bmc.core.responses.UpdateBootVolumeBackupResponse;
import com.oracle.bmc.core.responses.UpdateBootVolumeKmsKeyResponse;
import com.oracle.bmc.core.responses.UpdateBootVolumeResponse;
import com.oracle.bmc.core.responses.UpdateVolumeBackupPolicyResponse;
import com.oracle.bmc.core.responses.UpdateVolumeBackupResponse;
import com.oracle.bmc.core.responses.UpdateVolumeGroupBackupResponse;
import com.oracle.bmc.core.responses.UpdateVolumeGroupResponse;
import com.oracle.bmc.core.responses.UpdateVolumeKmsKeyResponse;
import com.oracle.bmc.core.responses.UpdateVolumeResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.ErrorConsumer;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.SuccessConsumer;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenTransformingFuture;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrappingAsyncHandler;
import com.oracle.bmc.util.internal.TransformingFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockstorageAsyncClient
implements BlockstorageAsync {
    private static final Logger LOG = LoggerFactory.getLogger(BlockstorageAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("BLOCKSTORAGE").serviceEndpointPrefix("iaas").serviceEndpointTemplate("https://iaas.{region}.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public BlockstorageAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public BlockstorageAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public BlockstorageAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public BlockstorageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public BlockstorageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public BlockstorageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public BlockstorageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)((Object)this.authenticationDetailsProvider)).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional<String> endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(SERVICE, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ChangeBootVolumeBackupCompartmentResponse> changeBootVolumeBackupCompartment(ChangeBootVolumeBackupCompartmentRequest request, AsyncHandler<ChangeBootVolumeBackupCompartmentRequest, ChangeBootVolumeBackupCompartmentResponse> handler) {
        LOG.trace("Called async changeBootVolumeBackupCompartment");
        final ChangeBootVolumeBackupCompartmentRequest interceptedRequest = ChangeBootVolumeBackupCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeBootVolumeBackupCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeBootVolumeBackupCompartmentResponse> transformer = ChangeBootVolumeBackupCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeBootVolumeBackupCompartmentRequest, ChangeBootVolumeBackupCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeBootVolumeBackupCompartmentRequest, ChangeBootVolumeBackupCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeBootVolumeBackupCompartmentRequest, ChangeBootVolumeBackupCompartmentResponse> onSuccess = new SuccessConsumer<ChangeBootVolumeBackupCompartmentRequest, ChangeBootVolumeBackupCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeBootVolumeBackupCompartmentRequest> onError = new ErrorConsumer<ChangeBootVolumeBackupCompartmentRequest>(this, interceptedRequest);
                    BlockstorageAsyncClient.this.client.post(ib, interceptedRequest.getChangeBootVolumeBackupCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeBootVolumeBackupCompartmentRequest, ChangeBootVolumeBackupCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeBootVolumeBackupCompartmentRequest, ChangeBootVolumeBackupCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeBootVolumeBackupCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeBootVolumeBackupCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeBootVolumeBackupCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeBootVolumeBackupCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BlockstorageAsyncClient.this.client.post(ib, interceptedRequest.getChangeBootVolumeBackupCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeBootVolumeBackupCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ChangeBootVolumeCompartmentResponse> changeBootVolumeCompartment(ChangeBootVolumeCompartmentRequest request, AsyncHandler<ChangeBootVolumeCompartmentRequest, ChangeBootVolumeCompartmentResponse> handler) {
        LOG.trace("Called async changeBootVolumeCompartment");
        final ChangeBootVolumeCompartmentRequest interceptedRequest = ChangeBootVolumeCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeBootVolumeCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeBootVolumeCompartmentResponse> transformer = ChangeBootVolumeCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeBootVolumeCompartmentRequest, ChangeBootVolumeCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeBootVolumeCompartmentRequest, ChangeBootVolumeCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeBootVolumeCompartmentRequest, ChangeBootVolumeCompartmentResponse> onSuccess = new SuccessConsumer<ChangeBootVolumeCompartmentRequest, ChangeBootVolumeCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeBootVolumeCompartmentRequest> onError = new ErrorConsumer<ChangeBootVolumeCompartmentRequest>(this, interceptedRequest);
                    BlockstorageAsyncClient.this.client.post(ib, interceptedRequest.getChangeBootVolumeCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeBootVolumeCompartmentRequest, ChangeBootVolumeCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeBootVolumeCompartmentRequest, ChangeBootVolumeCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeBootVolumeCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeBootVolumeCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeBootVolumeCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeBootVolumeCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BlockstorageAsyncClient.this.client.post(ib, interceptedRequest.getChangeBootVolumeCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeBootVolumeCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ChangeVolumeBackupCompartmentResponse> changeVolumeBackupCompartment(ChangeVolumeBackupCompartmentRequest request, AsyncHandler<ChangeVolumeBackupCompartmentRequest, ChangeVolumeBackupCompartmentResponse> handler) {
        LOG.trace("Called async changeVolumeBackupCompartment");
        final ChangeVolumeBackupCompartmentRequest interceptedRequest = ChangeVolumeBackupCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeVolumeBackupCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeVolumeBackupCompartmentResponse> transformer = ChangeVolumeBackupCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeVolumeBackupCompartmentRequest, ChangeVolumeBackupCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeVolumeBackupCompartmentRequest, ChangeVolumeBackupCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeVolumeBackupCompartmentRequest, ChangeVolumeBackupCompartmentResponse> onSuccess = new SuccessConsumer<ChangeVolumeBackupCompartmentRequest, ChangeVolumeBackupCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeVolumeBackupCompartmentRequest> onError = new ErrorConsumer<ChangeVolumeBackupCompartmentRequest>(this, interceptedRequest);
                    BlockstorageAsyncClient.this.client.post(ib, interceptedRequest.getChangeVolumeBackupCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeVolumeBackupCompartmentRequest, ChangeVolumeBackupCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeVolumeBackupCompartmentRequest, ChangeVolumeBackupCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeVolumeBackupCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeVolumeBackupCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeVolumeBackupCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeVolumeBackupCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BlockstorageAsyncClient.this.client.post(ib, interceptedRequest.getChangeVolumeBackupCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeVolumeBackupCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ChangeVolumeCompartmentResponse> changeVolumeCompartment(ChangeVolumeCompartmentRequest request, AsyncHandler<ChangeVolumeCompartmentRequest, ChangeVolumeCompartmentResponse> handler) {
        LOG.trace("Called async changeVolumeCompartment");
        final ChangeVolumeCompartmentRequest interceptedRequest = ChangeVolumeCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeVolumeCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeVolumeCompartmentResponse> transformer = ChangeVolumeCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeVolumeCompartmentRequest, ChangeVolumeCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeVolumeCompartmentRequest, ChangeVolumeCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeVolumeCompartmentRequest, ChangeVolumeCompartmentResponse> onSuccess = new SuccessConsumer<ChangeVolumeCompartmentRequest, ChangeVolumeCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeVolumeCompartmentRequest> onError = new ErrorConsumer<ChangeVolumeCompartmentRequest>(this, interceptedRequest);
                    BlockstorageAsyncClient.this.client.post(ib, interceptedRequest.getChangeVolumeCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeVolumeCompartmentRequest, ChangeVolumeCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeVolumeCompartmentRequest, ChangeVolumeCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeVolumeCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeVolumeCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeVolumeCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeVolumeCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BlockstorageAsyncClient.this.client.post(ib, interceptedRequest.getChangeVolumeCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeVolumeCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ChangeVolumeGroupBackupCompartmentResponse> changeVolumeGroupBackupCompartment(ChangeVolumeGroupBackupCompartmentRequest request, AsyncHandler<ChangeVolumeGroupBackupCompartmentRequest, ChangeVolumeGroupBackupCompartmentResponse> handler) {
        LOG.trace("Called async changeVolumeGroupBackupCompartment");
        final ChangeVolumeGroupBackupCompartmentRequest interceptedRequest = ChangeVolumeGroupBackupCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeVolumeGroupBackupCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeVolumeGroupBackupCompartmentResponse> transformer = ChangeVolumeGroupBackupCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeVolumeGroupBackupCompartmentRequest, ChangeVolumeGroupBackupCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeVolumeGroupBackupCompartmentRequest, ChangeVolumeGroupBackupCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeVolumeGroupBackupCompartmentRequest, ChangeVolumeGroupBackupCompartmentResponse> onSuccess = new SuccessConsumer<ChangeVolumeGroupBackupCompartmentRequest, ChangeVolumeGroupBackupCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeVolumeGroupBackupCompartmentRequest> onError = new ErrorConsumer<ChangeVolumeGroupBackupCompartmentRequest>(this, interceptedRequest);
                    BlockstorageAsyncClient.this.client.post(ib, interceptedRequest.getChangeVolumeGroupBackupCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeVolumeGroupBackupCompartmentRequest, ChangeVolumeGroupBackupCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeVolumeGroupBackupCompartmentRequest, ChangeVolumeGroupBackupCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeVolumeGroupBackupCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeVolumeGroupBackupCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeVolumeGroupBackupCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeVolumeGroupBackupCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BlockstorageAsyncClient.this.client.post(ib, interceptedRequest.getChangeVolumeGroupBackupCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeVolumeGroupBackupCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ChangeVolumeGroupCompartmentResponse> changeVolumeGroupCompartment(ChangeVolumeGroupCompartmentRequest request, AsyncHandler<ChangeVolumeGroupCompartmentRequest, ChangeVolumeGroupCompartmentResponse> handler) {
        LOG.trace("Called async changeVolumeGroupCompartment");
        final ChangeVolumeGroupCompartmentRequest interceptedRequest = ChangeVolumeGroupCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeVolumeGroupCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeVolumeGroupCompartmentResponse> transformer = ChangeVolumeGroupCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeVolumeGroupCompartmentRequest, ChangeVolumeGroupCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeVolumeGroupCompartmentRequest, ChangeVolumeGroupCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeVolumeGroupCompartmentRequest, ChangeVolumeGroupCompartmentResponse> onSuccess = new SuccessConsumer<ChangeVolumeGroupCompartmentRequest, ChangeVolumeGroupCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeVolumeGroupCompartmentRequest> onError = new ErrorConsumer<ChangeVolumeGroupCompartmentRequest>(this, interceptedRequest);
                    BlockstorageAsyncClient.this.client.post(ib, interceptedRequest.getChangeVolumeGroupCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeVolumeGroupCompartmentRequest, ChangeVolumeGroupCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeVolumeGroupCompartmentRequest, ChangeVolumeGroupCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeVolumeGroupCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeVolumeGroupCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeVolumeGroupCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeVolumeGroupCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BlockstorageAsyncClient.this.client.post(ib, interceptedRequest.getChangeVolumeGroupCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeVolumeGroupCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CopyVolumeBackupResponse> copyVolumeBackup(CopyVolumeBackupRequest request, AsyncHandler<CopyVolumeBackupRequest, CopyVolumeBackupResponse> handler) {
        LOG.trace("Called async copyVolumeBackup");
        final CopyVolumeBackupRequest interceptedRequest = CopyVolumeBackupConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CopyVolumeBackupConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CopyVolumeBackupResponse> transformer = CopyVolumeBackupConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CopyVolumeBackupRequest, CopyVolumeBackupResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CopyVolumeBackupRequest, CopyVolumeBackupResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CopyVolumeBackupRequest, CopyVolumeBackupResponse> onSuccess = new SuccessConsumer<CopyVolumeBackupRequest, CopyVolumeBackupResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CopyVolumeBackupRequest> onError = new ErrorConsumer<CopyVolumeBackupRequest>(this, interceptedRequest);
                    BlockstorageAsyncClient.this.client.post(ib, interceptedRequest.getCopyVolumeBackupDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CopyVolumeBackupRequest, CopyVolumeBackupResponse> onSuccess = handler == null ? null : new SuccessConsumer<CopyVolumeBackupRequest, CopyVolumeBackupResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CopyVolumeBackupRequest> onError = handler == null ? null : new ErrorConsumer<CopyVolumeBackupRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCopyVolumeBackupDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CopyVolumeBackupResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BlockstorageAsyncClient.this.client.post(ib, interceptedRequest.getCopyVolumeBackupDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CopyVolumeBackupResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateBootVolumeResponse> createBootVolume(CreateBootVolumeRequest request, AsyncHandler<CreateBootVolumeRequest, CreateBootVolumeResponse> handler) {
        LOG.trace("Called async createBootVolume");
        final CreateBootVolumeRequest interceptedRequest = CreateBootVolumeConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateBootVolumeConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateBootVolumeResponse> transformer = CreateBootVolumeConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateBootVolumeRequest, CreateBootVolumeResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateBootVolumeRequest, CreateBootVolumeResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateBootVolumeRequest, CreateBootVolumeResponse> onSuccess = new SuccessConsumer<CreateBootVolumeRequest, CreateBootVolumeResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateBootVolumeRequest> onError = new ErrorConsumer<CreateBootVolumeRequest>(this, interceptedRequest);
                    BlockstorageAsyncClient.this.client.post(ib, interceptedRequest.getCreateBootVolumeDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateBootVolumeRequest, CreateBootVolumeResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateBootVolumeRequest, CreateBootVolumeResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateBootVolumeRequest> onError = handler == null ? null : new ErrorConsumer<CreateBootVolumeRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateBootVolumeDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateBootVolumeResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BlockstorageAsyncClient.this.client.post(ib, interceptedRequest.getCreateBootVolumeDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateBootVolumeResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateBootVolumeBackupResponse> createBootVolumeBackup(CreateBootVolumeBackupRequest request, AsyncHandler<CreateBootVolumeBackupRequest, CreateBootVolumeBackupResponse> handler) {
        LOG.trace("Called async createBootVolumeBackup");
        final CreateBootVolumeBackupRequest interceptedRequest = CreateBootVolumeBackupConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateBootVolumeBackupConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateBootVolumeBackupResponse> transformer = CreateBootVolumeBackupConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateBootVolumeBackupRequest, CreateBootVolumeBackupResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateBootVolumeBackupRequest, CreateBootVolumeBackupResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateBootVolumeBackupRequest, CreateBootVolumeBackupResponse> onSuccess = new SuccessConsumer<CreateBootVolumeBackupRequest, CreateBootVolumeBackupResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateBootVolumeBackupRequest> onError = new ErrorConsumer<CreateBootVolumeBackupRequest>(this, interceptedRequest);
                    BlockstorageAsyncClient.this.client.post(ib, interceptedRequest.getCreateBootVolumeBackupDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateBootVolumeBackupRequest, CreateBootVolumeBackupResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateBootVolumeBackupRequest, CreateBootVolumeBackupResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateBootVolumeBackupRequest> onError = handler == null ? null : new ErrorConsumer<CreateBootVolumeBackupRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateBootVolumeBackupDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateBootVolumeBackupResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BlockstorageAsyncClient.this.client.post(ib, interceptedRequest.getCreateBootVolumeBackupDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateBootVolumeBackupResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateVolumeResponse> createVolume(CreateVolumeRequest request, AsyncHandler<CreateVolumeRequest, CreateVolumeResponse> handler) {
        LOG.trace("Called async createVolume");
        final CreateVolumeRequest interceptedRequest = CreateVolumeConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateVolumeConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateVolumeResponse> transformer = CreateVolumeConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateVolumeRequest, CreateVolumeResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateVolumeRequest, CreateVolumeResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateVolumeRequest, CreateVolumeResponse> onSuccess = new SuccessConsumer<CreateVolumeRequest, CreateVolumeResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateVolumeRequest> onError = new ErrorConsumer<CreateVolumeRequest>(this, interceptedRequest);
                    BlockstorageAsyncClient.this.client.post(ib, interceptedRequest.getCreateVolumeDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateVolumeRequest, CreateVolumeResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateVolumeRequest, CreateVolumeResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateVolumeRequest> onError = handler == null ? null : new ErrorConsumer<CreateVolumeRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateVolumeDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateVolumeResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BlockstorageAsyncClient.this.client.post(ib, interceptedRequest.getCreateVolumeDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateVolumeResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateVolumeBackupResponse> createVolumeBackup(CreateVolumeBackupRequest request, AsyncHandler<CreateVolumeBackupRequest, CreateVolumeBackupResponse> handler) {
        LOG.trace("Called async createVolumeBackup");
        final CreateVolumeBackupRequest interceptedRequest = CreateVolumeBackupConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateVolumeBackupConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateVolumeBackupResponse> transformer = CreateVolumeBackupConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateVolumeBackupRequest, CreateVolumeBackupResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateVolumeBackupRequest, CreateVolumeBackupResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateVolumeBackupRequest, CreateVolumeBackupResponse> onSuccess = new SuccessConsumer<CreateVolumeBackupRequest, CreateVolumeBackupResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateVolumeBackupRequest> onError = new ErrorConsumer<CreateVolumeBackupRequest>(this, interceptedRequest);
                    BlockstorageAsyncClient.this.client.post(ib, interceptedRequest.getCreateVolumeBackupDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateVolumeBackupRequest, CreateVolumeBackupResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateVolumeBackupRequest, CreateVolumeBackupResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateVolumeBackupRequest> onError = handler == null ? null : new ErrorConsumer<CreateVolumeBackupRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateVolumeBackupDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateVolumeBackupResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BlockstorageAsyncClient.this.client.post(ib, interceptedRequest.getCreateVolumeBackupDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateVolumeBackupResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateVolumeBackupPolicyResponse> createVolumeBackupPolicy(CreateVolumeBackupPolicyRequest request, AsyncHandler<CreateVolumeBackupPolicyRequest, CreateVolumeBackupPolicyResponse> handler) {
        LOG.trace("Called async createVolumeBackupPolicy");
        final CreateVolumeBackupPolicyRequest interceptedRequest = CreateVolumeBackupPolicyConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateVolumeBackupPolicyConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateVolumeBackupPolicyResponse> transformer = CreateVolumeBackupPolicyConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateVolumeBackupPolicyRequest, CreateVolumeBackupPolicyResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateVolumeBackupPolicyRequest, CreateVolumeBackupPolicyResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateVolumeBackupPolicyRequest, CreateVolumeBackupPolicyResponse> onSuccess = new SuccessConsumer<CreateVolumeBackupPolicyRequest, CreateVolumeBackupPolicyResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateVolumeBackupPolicyRequest> onError = new ErrorConsumer<CreateVolumeBackupPolicyRequest>(this, interceptedRequest);
                    BlockstorageAsyncClient.this.client.post(ib, interceptedRequest.getCreateVolumeBackupPolicyDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateVolumeBackupPolicyRequest, CreateVolumeBackupPolicyResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateVolumeBackupPolicyRequest, CreateVolumeBackupPolicyResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateVolumeBackupPolicyRequest> onError = handler == null ? null : new ErrorConsumer<CreateVolumeBackupPolicyRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateVolumeBackupPolicyDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateVolumeBackupPolicyResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BlockstorageAsyncClient.this.client.post(ib, interceptedRequest.getCreateVolumeBackupPolicyDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateVolumeBackupPolicyResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateVolumeBackupPolicyAssignmentResponse> createVolumeBackupPolicyAssignment(CreateVolumeBackupPolicyAssignmentRequest request, AsyncHandler<CreateVolumeBackupPolicyAssignmentRequest, CreateVolumeBackupPolicyAssignmentResponse> handler) {
        LOG.trace("Called async createVolumeBackupPolicyAssignment");
        final CreateVolumeBackupPolicyAssignmentRequest interceptedRequest = CreateVolumeBackupPolicyAssignmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateVolumeBackupPolicyAssignmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateVolumeBackupPolicyAssignmentResponse> transformer = CreateVolumeBackupPolicyAssignmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateVolumeBackupPolicyAssignmentRequest, CreateVolumeBackupPolicyAssignmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateVolumeBackupPolicyAssignmentRequest, CreateVolumeBackupPolicyAssignmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateVolumeBackupPolicyAssignmentRequest, CreateVolumeBackupPolicyAssignmentResponse> onSuccess = new SuccessConsumer<CreateVolumeBackupPolicyAssignmentRequest, CreateVolumeBackupPolicyAssignmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateVolumeBackupPolicyAssignmentRequest> onError = new ErrorConsumer<CreateVolumeBackupPolicyAssignmentRequest>(this, interceptedRequest);
                    BlockstorageAsyncClient.this.client.post(ib, interceptedRequest.getCreateVolumeBackupPolicyAssignmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateVolumeBackupPolicyAssignmentRequest, CreateVolumeBackupPolicyAssignmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateVolumeBackupPolicyAssignmentRequest, CreateVolumeBackupPolicyAssignmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateVolumeBackupPolicyAssignmentRequest> onError = handler == null ? null : new ErrorConsumer<CreateVolumeBackupPolicyAssignmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateVolumeBackupPolicyAssignmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateVolumeBackupPolicyAssignmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BlockstorageAsyncClient.this.client.post(ib, interceptedRequest.getCreateVolumeBackupPolicyAssignmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateVolumeBackupPolicyAssignmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateVolumeGroupResponse> createVolumeGroup(CreateVolumeGroupRequest request, AsyncHandler<CreateVolumeGroupRequest, CreateVolumeGroupResponse> handler) {
        LOG.trace("Called async createVolumeGroup");
        final CreateVolumeGroupRequest interceptedRequest = CreateVolumeGroupConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateVolumeGroupConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateVolumeGroupResponse> transformer = CreateVolumeGroupConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateVolumeGroupRequest, CreateVolumeGroupResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateVolumeGroupRequest, CreateVolumeGroupResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateVolumeGroupRequest, CreateVolumeGroupResponse> onSuccess = new SuccessConsumer<CreateVolumeGroupRequest, CreateVolumeGroupResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateVolumeGroupRequest> onError = new ErrorConsumer<CreateVolumeGroupRequest>(this, interceptedRequest);
                    BlockstorageAsyncClient.this.client.post(ib, interceptedRequest.getCreateVolumeGroupDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateVolumeGroupRequest, CreateVolumeGroupResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateVolumeGroupRequest, CreateVolumeGroupResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateVolumeGroupRequest> onError = handler == null ? null : new ErrorConsumer<CreateVolumeGroupRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateVolumeGroupDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateVolumeGroupResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BlockstorageAsyncClient.this.client.post(ib, interceptedRequest.getCreateVolumeGroupDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateVolumeGroupResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateVolumeGroupBackupResponse> createVolumeGroupBackup(CreateVolumeGroupBackupRequest request, AsyncHandler<CreateVolumeGroupBackupRequest, CreateVolumeGroupBackupResponse> handler) {
        LOG.trace("Called async createVolumeGroupBackup");
        final CreateVolumeGroupBackupRequest interceptedRequest = CreateVolumeGroupBackupConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateVolumeGroupBackupConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateVolumeGroupBackupResponse> transformer = CreateVolumeGroupBackupConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateVolumeGroupBackupRequest, CreateVolumeGroupBackupResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateVolumeGroupBackupRequest, CreateVolumeGroupBackupResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateVolumeGroupBackupRequest, CreateVolumeGroupBackupResponse> onSuccess = new SuccessConsumer<CreateVolumeGroupBackupRequest, CreateVolumeGroupBackupResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateVolumeGroupBackupRequest> onError = new ErrorConsumer<CreateVolumeGroupBackupRequest>(this, interceptedRequest);
                    BlockstorageAsyncClient.this.client.post(ib, interceptedRequest.getCreateVolumeGroupBackupDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateVolumeGroupBackupRequest, CreateVolumeGroupBackupResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateVolumeGroupBackupRequest, CreateVolumeGroupBackupResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateVolumeGroupBackupRequest> onError = handler == null ? null : new ErrorConsumer<CreateVolumeGroupBackupRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateVolumeGroupBackupDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateVolumeGroupBackupResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BlockstorageAsyncClient.this.client.post(ib, interceptedRequest.getCreateVolumeGroupBackupDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateVolumeGroupBackupResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteBootVolumeResponse> deleteBootVolume(DeleteBootVolumeRequest request, AsyncHandler<DeleteBootVolumeRequest, DeleteBootVolumeResponse> handler) {
        LOG.trace("Called async deleteBootVolume");
        final DeleteBootVolumeRequest interceptedRequest = DeleteBootVolumeConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteBootVolumeConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteBootVolumeResponse> transformer = DeleteBootVolumeConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteBootVolumeRequest, DeleteBootVolumeResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteBootVolumeRequest, DeleteBootVolumeResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteBootVolumeRequest, DeleteBootVolumeResponse> onSuccess = new SuccessConsumer<DeleteBootVolumeRequest, DeleteBootVolumeResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteBootVolumeRequest> onError = new ErrorConsumer<DeleteBootVolumeRequest>(this, interceptedRequest);
                    BlockstorageAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteBootVolumeRequest, DeleteBootVolumeResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteBootVolumeRequest, DeleteBootVolumeResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteBootVolumeRequest> onError = handler == null ? null : new ErrorConsumer<DeleteBootVolumeRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteBootVolumeResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BlockstorageAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteBootVolumeResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteBootVolumeBackupResponse> deleteBootVolumeBackup(DeleteBootVolumeBackupRequest request, AsyncHandler<DeleteBootVolumeBackupRequest, DeleteBootVolumeBackupResponse> handler) {
        LOG.trace("Called async deleteBootVolumeBackup");
        final DeleteBootVolumeBackupRequest interceptedRequest = DeleteBootVolumeBackupConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteBootVolumeBackupConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteBootVolumeBackupResponse> transformer = DeleteBootVolumeBackupConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteBootVolumeBackupRequest, DeleteBootVolumeBackupResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteBootVolumeBackupRequest, DeleteBootVolumeBackupResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteBootVolumeBackupRequest, DeleteBootVolumeBackupResponse> onSuccess = new SuccessConsumer<DeleteBootVolumeBackupRequest, DeleteBootVolumeBackupResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteBootVolumeBackupRequest> onError = new ErrorConsumer<DeleteBootVolumeBackupRequest>(this, interceptedRequest);
                    BlockstorageAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteBootVolumeBackupRequest, DeleteBootVolumeBackupResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteBootVolumeBackupRequest, DeleteBootVolumeBackupResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteBootVolumeBackupRequest> onError = handler == null ? null : new ErrorConsumer<DeleteBootVolumeBackupRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteBootVolumeBackupResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BlockstorageAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteBootVolumeBackupResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteBootVolumeKmsKeyResponse> deleteBootVolumeKmsKey(DeleteBootVolumeKmsKeyRequest request, AsyncHandler<DeleteBootVolumeKmsKeyRequest, DeleteBootVolumeKmsKeyResponse> handler) {
        LOG.trace("Called async deleteBootVolumeKmsKey");
        final DeleteBootVolumeKmsKeyRequest interceptedRequest = DeleteBootVolumeKmsKeyConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteBootVolumeKmsKeyConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteBootVolumeKmsKeyResponse> transformer = DeleteBootVolumeKmsKeyConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteBootVolumeKmsKeyRequest, DeleteBootVolumeKmsKeyResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteBootVolumeKmsKeyRequest, DeleteBootVolumeKmsKeyResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteBootVolumeKmsKeyRequest, DeleteBootVolumeKmsKeyResponse> onSuccess = new SuccessConsumer<DeleteBootVolumeKmsKeyRequest, DeleteBootVolumeKmsKeyResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteBootVolumeKmsKeyRequest> onError = new ErrorConsumer<DeleteBootVolumeKmsKeyRequest>(this, interceptedRequest);
                    BlockstorageAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteBootVolumeKmsKeyRequest, DeleteBootVolumeKmsKeyResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteBootVolumeKmsKeyRequest, DeleteBootVolumeKmsKeyResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteBootVolumeKmsKeyRequest> onError = handler == null ? null : new ErrorConsumer<DeleteBootVolumeKmsKeyRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteBootVolumeKmsKeyResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BlockstorageAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteBootVolumeKmsKeyResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteVolumeResponse> deleteVolume(DeleteVolumeRequest request, AsyncHandler<DeleteVolumeRequest, DeleteVolumeResponse> handler) {
        LOG.trace("Called async deleteVolume");
        final DeleteVolumeRequest interceptedRequest = DeleteVolumeConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteVolumeConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteVolumeResponse> transformer = DeleteVolumeConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteVolumeRequest, DeleteVolumeResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteVolumeRequest, DeleteVolumeResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteVolumeRequest, DeleteVolumeResponse> onSuccess = new SuccessConsumer<DeleteVolumeRequest, DeleteVolumeResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteVolumeRequest> onError = new ErrorConsumer<DeleteVolumeRequest>(this, interceptedRequest);
                    BlockstorageAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteVolumeRequest, DeleteVolumeResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteVolumeRequest, DeleteVolumeResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteVolumeRequest> onError = handler == null ? null : new ErrorConsumer<DeleteVolumeRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteVolumeResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BlockstorageAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteVolumeResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteVolumeBackupResponse> deleteVolumeBackup(DeleteVolumeBackupRequest request, AsyncHandler<DeleteVolumeBackupRequest, DeleteVolumeBackupResponse> handler) {
        LOG.trace("Called async deleteVolumeBackup");
        final DeleteVolumeBackupRequest interceptedRequest = DeleteVolumeBackupConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteVolumeBackupConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteVolumeBackupResponse> transformer = DeleteVolumeBackupConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteVolumeBackupRequest, DeleteVolumeBackupResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteVolumeBackupRequest, DeleteVolumeBackupResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteVolumeBackupRequest, DeleteVolumeBackupResponse> onSuccess = new SuccessConsumer<DeleteVolumeBackupRequest, DeleteVolumeBackupResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteVolumeBackupRequest> onError = new ErrorConsumer<DeleteVolumeBackupRequest>(this, interceptedRequest);
                    BlockstorageAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteVolumeBackupRequest, DeleteVolumeBackupResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteVolumeBackupRequest, DeleteVolumeBackupResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteVolumeBackupRequest> onError = handler == null ? null : new ErrorConsumer<DeleteVolumeBackupRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteVolumeBackupResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BlockstorageAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteVolumeBackupResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteVolumeBackupPolicyResponse> deleteVolumeBackupPolicy(DeleteVolumeBackupPolicyRequest request, AsyncHandler<DeleteVolumeBackupPolicyRequest, DeleteVolumeBackupPolicyResponse> handler) {
        LOG.trace("Called async deleteVolumeBackupPolicy");
        final DeleteVolumeBackupPolicyRequest interceptedRequest = DeleteVolumeBackupPolicyConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteVolumeBackupPolicyConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteVolumeBackupPolicyResponse> transformer = DeleteVolumeBackupPolicyConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteVolumeBackupPolicyRequest, DeleteVolumeBackupPolicyResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteVolumeBackupPolicyRequest, DeleteVolumeBackupPolicyResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteVolumeBackupPolicyRequest, DeleteVolumeBackupPolicyResponse> onSuccess = new SuccessConsumer<DeleteVolumeBackupPolicyRequest, DeleteVolumeBackupPolicyResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteVolumeBackupPolicyRequest> onError = new ErrorConsumer<DeleteVolumeBackupPolicyRequest>(this, interceptedRequest);
                    BlockstorageAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteVolumeBackupPolicyRequest, DeleteVolumeBackupPolicyResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteVolumeBackupPolicyRequest, DeleteVolumeBackupPolicyResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteVolumeBackupPolicyRequest> onError = handler == null ? null : new ErrorConsumer<DeleteVolumeBackupPolicyRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteVolumeBackupPolicyResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BlockstorageAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteVolumeBackupPolicyResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteVolumeBackupPolicyAssignmentResponse> deleteVolumeBackupPolicyAssignment(DeleteVolumeBackupPolicyAssignmentRequest request, AsyncHandler<DeleteVolumeBackupPolicyAssignmentRequest, DeleteVolumeBackupPolicyAssignmentResponse> handler) {
        LOG.trace("Called async deleteVolumeBackupPolicyAssignment");
        final DeleteVolumeBackupPolicyAssignmentRequest interceptedRequest = DeleteVolumeBackupPolicyAssignmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteVolumeBackupPolicyAssignmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteVolumeBackupPolicyAssignmentResponse> transformer = DeleteVolumeBackupPolicyAssignmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteVolumeBackupPolicyAssignmentRequest, DeleteVolumeBackupPolicyAssignmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteVolumeBackupPolicyAssignmentRequest, DeleteVolumeBackupPolicyAssignmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteVolumeBackupPolicyAssignmentRequest, DeleteVolumeBackupPolicyAssignmentResponse> onSuccess = new SuccessConsumer<DeleteVolumeBackupPolicyAssignmentRequest, DeleteVolumeBackupPolicyAssignmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteVolumeBackupPolicyAssignmentRequest> onError = new ErrorConsumer<DeleteVolumeBackupPolicyAssignmentRequest>(this, interceptedRequest);
                    BlockstorageAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteVolumeBackupPolicyAssignmentRequest, DeleteVolumeBackupPolicyAssignmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteVolumeBackupPolicyAssignmentRequest, DeleteVolumeBackupPolicyAssignmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteVolumeBackupPolicyAssignmentRequest> onError = handler == null ? null : new ErrorConsumer<DeleteVolumeBackupPolicyAssignmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteVolumeBackupPolicyAssignmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BlockstorageAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteVolumeBackupPolicyAssignmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteVolumeGroupResponse> deleteVolumeGroup(DeleteVolumeGroupRequest request, AsyncHandler<DeleteVolumeGroupRequest, DeleteVolumeGroupResponse> handler) {
        LOG.trace("Called async deleteVolumeGroup");
        final DeleteVolumeGroupRequest interceptedRequest = DeleteVolumeGroupConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteVolumeGroupConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteVolumeGroupResponse> transformer = DeleteVolumeGroupConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteVolumeGroupRequest, DeleteVolumeGroupResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteVolumeGroupRequest, DeleteVolumeGroupResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteVolumeGroupRequest, DeleteVolumeGroupResponse> onSuccess = new SuccessConsumer<DeleteVolumeGroupRequest, DeleteVolumeGroupResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteVolumeGroupRequest> onError = new ErrorConsumer<DeleteVolumeGroupRequest>(this, interceptedRequest);
                    BlockstorageAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteVolumeGroupRequest, DeleteVolumeGroupResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteVolumeGroupRequest, DeleteVolumeGroupResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteVolumeGroupRequest> onError = handler == null ? null : new ErrorConsumer<DeleteVolumeGroupRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteVolumeGroupResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BlockstorageAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteVolumeGroupResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteVolumeGroupBackupResponse> deleteVolumeGroupBackup(DeleteVolumeGroupBackupRequest request, AsyncHandler<DeleteVolumeGroupBackupRequest, DeleteVolumeGroupBackupResponse> handler) {
        LOG.trace("Called async deleteVolumeGroupBackup");
        final DeleteVolumeGroupBackupRequest interceptedRequest = DeleteVolumeGroupBackupConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteVolumeGroupBackupConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteVolumeGroupBackupResponse> transformer = DeleteVolumeGroupBackupConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteVolumeGroupBackupRequest, DeleteVolumeGroupBackupResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteVolumeGroupBackupRequest, DeleteVolumeGroupBackupResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteVolumeGroupBackupRequest, DeleteVolumeGroupBackupResponse> onSuccess = new SuccessConsumer<DeleteVolumeGroupBackupRequest, DeleteVolumeGroupBackupResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteVolumeGroupBackupRequest> onError = new ErrorConsumer<DeleteVolumeGroupBackupRequest>(this, interceptedRequest);
                    BlockstorageAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteVolumeGroupBackupRequest, DeleteVolumeGroupBackupResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteVolumeGroupBackupRequest, DeleteVolumeGroupBackupResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteVolumeGroupBackupRequest> onError = handler == null ? null : new ErrorConsumer<DeleteVolumeGroupBackupRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteVolumeGroupBackupResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BlockstorageAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteVolumeGroupBackupResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteVolumeKmsKeyResponse> deleteVolumeKmsKey(DeleteVolumeKmsKeyRequest request, AsyncHandler<DeleteVolumeKmsKeyRequest, DeleteVolumeKmsKeyResponse> handler) {
        LOG.trace("Called async deleteVolumeKmsKey");
        final DeleteVolumeKmsKeyRequest interceptedRequest = DeleteVolumeKmsKeyConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteVolumeKmsKeyConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteVolumeKmsKeyResponse> transformer = DeleteVolumeKmsKeyConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteVolumeKmsKeyRequest, DeleteVolumeKmsKeyResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteVolumeKmsKeyRequest, DeleteVolumeKmsKeyResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteVolumeKmsKeyRequest, DeleteVolumeKmsKeyResponse> onSuccess = new SuccessConsumer<DeleteVolumeKmsKeyRequest, DeleteVolumeKmsKeyResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteVolumeKmsKeyRequest> onError = new ErrorConsumer<DeleteVolumeKmsKeyRequest>(this, interceptedRequest);
                    BlockstorageAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteVolumeKmsKeyRequest, DeleteVolumeKmsKeyResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteVolumeKmsKeyRequest, DeleteVolumeKmsKeyResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteVolumeKmsKeyRequest> onError = handler == null ? null : new ErrorConsumer<DeleteVolumeKmsKeyRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteVolumeKmsKeyResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BlockstorageAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteVolumeKmsKeyResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetBootVolumeResponse> getBootVolume(GetBootVolumeRequest request, AsyncHandler<GetBootVolumeRequest, GetBootVolumeResponse> handler) {
        LOG.trace("Called async getBootVolume");
        final GetBootVolumeRequest interceptedRequest = GetBootVolumeConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetBootVolumeConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetBootVolumeResponse> transformer = GetBootVolumeConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetBootVolumeRequest, GetBootVolumeResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetBootVolumeRequest, GetBootVolumeResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetBootVolumeRequest, GetBootVolumeResponse> onSuccess = new SuccessConsumer<GetBootVolumeRequest, GetBootVolumeResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetBootVolumeRequest> onError = new ErrorConsumer<GetBootVolumeRequest>(this, interceptedRequest);
                    BlockstorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetBootVolumeRequest, GetBootVolumeResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetBootVolumeRequest, GetBootVolumeResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetBootVolumeRequest> onError = handler == null ? null : new ErrorConsumer<GetBootVolumeRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetBootVolumeResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BlockstorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetBootVolumeResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetBootVolumeBackupResponse> getBootVolumeBackup(GetBootVolumeBackupRequest request, AsyncHandler<GetBootVolumeBackupRequest, GetBootVolumeBackupResponse> handler) {
        LOG.trace("Called async getBootVolumeBackup");
        final GetBootVolumeBackupRequest interceptedRequest = GetBootVolumeBackupConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetBootVolumeBackupConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetBootVolumeBackupResponse> transformer = GetBootVolumeBackupConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetBootVolumeBackupRequest, GetBootVolumeBackupResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetBootVolumeBackupRequest, GetBootVolumeBackupResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetBootVolumeBackupRequest, GetBootVolumeBackupResponse> onSuccess = new SuccessConsumer<GetBootVolumeBackupRequest, GetBootVolumeBackupResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetBootVolumeBackupRequest> onError = new ErrorConsumer<GetBootVolumeBackupRequest>(this, interceptedRequest);
                    BlockstorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetBootVolumeBackupRequest, GetBootVolumeBackupResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetBootVolumeBackupRequest, GetBootVolumeBackupResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetBootVolumeBackupRequest> onError = handler == null ? null : new ErrorConsumer<GetBootVolumeBackupRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetBootVolumeBackupResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BlockstorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetBootVolumeBackupResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetBootVolumeKmsKeyResponse> getBootVolumeKmsKey(GetBootVolumeKmsKeyRequest request, AsyncHandler<GetBootVolumeKmsKeyRequest, GetBootVolumeKmsKeyResponse> handler) {
        LOG.trace("Called async getBootVolumeKmsKey");
        final GetBootVolumeKmsKeyRequest interceptedRequest = GetBootVolumeKmsKeyConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetBootVolumeKmsKeyConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetBootVolumeKmsKeyResponse> transformer = GetBootVolumeKmsKeyConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetBootVolumeKmsKeyRequest, GetBootVolumeKmsKeyResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetBootVolumeKmsKeyRequest, GetBootVolumeKmsKeyResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetBootVolumeKmsKeyRequest, GetBootVolumeKmsKeyResponse> onSuccess = new SuccessConsumer<GetBootVolumeKmsKeyRequest, GetBootVolumeKmsKeyResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetBootVolumeKmsKeyRequest> onError = new ErrorConsumer<GetBootVolumeKmsKeyRequest>(this, interceptedRequest);
                    BlockstorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetBootVolumeKmsKeyRequest, GetBootVolumeKmsKeyResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetBootVolumeKmsKeyRequest, GetBootVolumeKmsKeyResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetBootVolumeKmsKeyRequest> onError = handler == null ? null : new ErrorConsumer<GetBootVolumeKmsKeyRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetBootVolumeKmsKeyResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BlockstorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetBootVolumeKmsKeyResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetVolumeResponse> getVolume(GetVolumeRequest request, AsyncHandler<GetVolumeRequest, GetVolumeResponse> handler) {
        LOG.trace("Called async getVolume");
        final GetVolumeRequest interceptedRequest = GetVolumeConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetVolumeConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetVolumeResponse> transformer = GetVolumeConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetVolumeRequest, GetVolumeResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetVolumeRequest, GetVolumeResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetVolumeRequest, GetVolumeResponse> onSuccess = new SuccessConsumer<GetVolumeRequest, GetVolumeResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetVolumeRequest> onError = new ErrorConsumer<GetVolumeRequest>(this, interceptedRequest);
                    BlockstorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetVolumeRequest, GetVolumeResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetVolumeRequest, GetVolumeResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetVolumeRequest> onError = handler == null ? null : new ErrorConsumer<GetVolumeRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetVolumeResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BlockstorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetVolumeResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetVolumeBackupResponse> getVolumeBackup(GetVolumeBackupRequest request, AsyncHandler<GetVolumeBackupRequest, GetVolumeBackupResponse> handler) {
        LOG.trace("Called async getVolumeBackup");
        final GetVolumeBackupRequest interceptedRequest = GetVolumeBackupConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetVolumeBackupConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetVolumeBackupResponse> transformer = GetVolumeBackupConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetVolumeBackupRequest, GetVolumeBackupResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetVolumeBackupRequest, GetVolumeBackupResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetVolumeBackupRequest, GetVolumeBackupResponse> onSuccess = new SuccessConsumer<GetVolumeBackupRequest, GetVolumeBackupResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetVolumeBackupRequest> onError = new ErrorConsumer<GetVolumeBackupRequest>(this, interceptedRequest);
                    BlockstorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetVolumeBackupRequest, GetVolumeBackupResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetVolumeBackupRequest, GetVolumeBackupResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetVolumeBackupRequest> onError = handler == null ? null : new ErrorConsumer<GetVolumeBackupRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetVolumeBackupResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BlockstorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetVolumeBackupResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetVolumeBackupPolicyResponse> getVolumeBackupPolicy(GetVolumeBackupPolicyRequest request, AsyncHandler<GetVolumeBackupPolicyRequest, GetVolumeBackupPolicyResponse> handler) {
        LOG.trace("Called async getVolumeBackupPolicy");
        final GetVolumeBackupPolicyRequest interceptedRequest = GetVolumeBackupPolicyConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetVolumeBackupPolicyConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetVolumeBackupPolicyResponse> transformer = GetVolumeBackupPolicyConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetVolumeBackupPolicyRequest, GetVolumeBackupPolicyResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetVolumeBackupPolicyRequest, GetVolumeBackupPolicyResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetVolumeBackupPolicyRequest, GetVolumeBackupPolicyResponse> onSuccess = new SuccessConsumer<GetVolumeBackupPolicyRequest, GetVolumeBackupPolicyResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetVolumeBackupPolicyRequest> onError = new ErrorConsumer<GetVolumeBackupPolicyRequest>(this, interceptedRequest);
                    BlockstorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetVolumeBackupPolicyRequest, GetVolumeBackupPolicyResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetVolumeBackupPolicyRequest, GetVolumeBackupPolicyResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetVolumeBackupPolicyRequest> onError = handler == null ? null : new ErrorConsumer<GetVolumeBackupPolicyRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetVolumeBackupPolicyResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BlockstorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetVolumeBackupPolicyResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetVolumeBackupPolicyAssetAssignmentResponse> getVolumeBackupPolicyAssetAssignment(GetVolumeBackupPolicyAssetAssignmentRequest request, AsyncHandler<GetVolumeBackupPolicyAssetAssignmentRequest, GetVolumeBackupPolicyAssetAssignmentResponse> handler) {
        LOG.trace("Called async getVolumeBackupPolicyAssetAssignment");
        final GetVolumeBackupPolicyAssetAssignmentRequest interceptedRequest = GetVolumeBackupPolicyAssetAssignmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetVolumeBackupPolicyAssetAssignmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetVolumeBackupPolicyAssetAssignmentResponse> transformer = GetVolumeBackupPolicyAssetAssignmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetVolumeBackupPolicyAssetAssignmentRequest, GetVolumeBackupPolicyAssetAssignmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetVolumeBackupPolicyAssetAssignmentRequest, GetVolumeBackupPolicyAssetAssignmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetVolumeBackupPolicyAssetAssignmentRequest, GetVolumeBackupPolicyAssetAssignmentResponse> onSuccess = new SuccessConsumer<GetVolumeBackupPolicyAssetAssignmentRequest, GetVolumeBackupPolicyAssetAssignmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetVolumeBackupPolicyAssetAssignmentRequest> onError = new ErrorConsumer<GetVolumeBackupPolicyAssetAssignmentRequest>(this, interceptedRequest);
                    BlockstorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetVolumeBackupPolicyAssetAssignmentRequest, GetVolumeBackupPolicyAssetAssignmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetVolumeBackupPolicyAssetAssignmentRequest, GetVolumeBackupPolicyAssetAssignmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetVolumeBackupPolicyAssetAssignmentRequest> onError = handler == null ? null : new ErrorConsumer<GetVolumeBackupPolicyAssetAssignmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetVolumeBackupPolicyAssetAssignmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BlockstorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetVolumeBackupPolicyAssetAssignmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetVolumeBackupPolicyAssignmentResponse> getVolumeBackupPolicyAssignment(GetVolumeBackupPolicyAssignmentRequest request, AsyncHandler<GetVolumeBackupPolicyAssignmentRequest, GetVolumeBackupPolicyAssignmentResponse> handler) {
        LOG.trace("Called async getVolumeBackupPolicyAssignment");
        final GetVolumeBackupPolicyAssignmentRequest interceptedRequest = GetVolumeBackupPolicyAssignmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetVolumeBackupPolicyAssignmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetVolumeBackupPolicyAssignmentResponse> transformer = GetVolumeBackupPolicyAssignmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetVolumeBackupPolicyAssignmentRequest, GetVolumeBackupPolicyAssignmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetVolumeBackupPolicyAssignmentRequest, GetVolumeBackupPolicyAssignmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetVolumeBackupPolicyAssignmentRequest, GetVolumeBackupPolicyAssignmentResponse> onSuccess = new SuccessConsumer<GetVolumeBackupPolicyAssignmentRequest, GetVolumeBackupPolicyAssignmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetVolumeBackupPolicyAssignmentRequest> onError = new ErrorConsumer<GetVolumeBackupPolicyAssignmentRequest>(this, interceptedRequest);
                    BlockstorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetVolumeBackupPolicyAssignmentRequest, GetVolumeBackupPolicyAssignmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetVolumeBackupPolicyAssignmentRequest, GetVolumeBackupPolicyAssignmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetVolumeBackupPolicyAssignmentRequest> onError = handler == null ? null : new ErrorConsumer<GetVolumeBackupPolicyAssignmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetVolumeBackupPolicyAssignmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BlockstorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetVolumeBackupPolicyAssignmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetVolumeGroupResponse> getVolumeGroup(GetVolumeGroupRequest request, AsyncHandler<GetVolumeGroupRequest, GetVolumeGroupResponse> handler) {
        LOG.trace("Called async getVolumeGroup");
        final GetVolumeGroupRequest interceptedRequest = GetVolumeGroupConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetVolumeGroupConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetVolumeGroupResponse> transformer = GetVolumeGroupConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetVolumeGroupRequest, GetVolumeGroupResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetVolumeGroupRequest, GetVolumeGroupResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetVolumeGroupRequest, GetVolumeGroupResponse> onSuccess = new SuccessConsumer<GetVolumeGroupRequest, GetVolumeGroupResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetVolumeGroupRequest> onError = new ErrorConsumer<GetVolumeGroupRequest>(this, interceptedRequest);
                    BlockstorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetVolumeGroupRequest, GetVolumeGroupResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetVolumeGroupRequest, GetVolumeGroupResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetVolumeGroupRequest> onError = handler == null ? null : new ErrorConsumer<GetVolumeGroupRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetVolumeGroupResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BlockstorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetVolumeGroupResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetVolumeGroupBackupResponse> getVolumeGroupBackup(GetVolumeGroupBackupRequest request, AsyncHandler<GetVolumeGroupBackupRequest, GetVolumeGroupBackupResponse> handler) {
        LOG.trace("Called async getVolumeGroupBackup");
        final GetVolumeGroupBackupRequest interceptedRequest = GetVolumeGroupBackupConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetVolumeGroupBackupConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetVolumeGroupBackupResponse> transformer = GetVolumeGroupBackupConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetVolumeGroupBackupRequest, GetVolumeGroupBackupResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetVolumeGroupBackupRequest, GetVolumeGroupBackupResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetVolumeGroupBackupRequest, GetVolumeGroupBackupResponse> onSuccess = new SuccessConsumer<GetVolumeGroupBackupRequest, GetVolumeGroupBackupResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetVolumeGroupBackupRequest> onError = new ErrorConsumer<GetVolumeGroupBackupRequest>(this, interceptedRequest);
                    BlockstorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetVolumeGroupBackupRequest, GetVolumeGroupBackupResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetVolumeGroupBackupRequest, GetVolumeGroupBackupResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetVolumeGroupBackupRequest> onError = handler == null ? null : new ErrorConsumer<GetVolumeGroupBackupRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetVolumeGroupBackupResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BlockstorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetVolumeGroupBackupResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetVolumeKmsKeyResponse> getVolumeKmsKey(GetVolumeKmsKeyRequest request, AsyncHandler<GetVolumeKmsKeyRequest, GetVolumeKmsKeyResponse> handler) {
        LOG.trace("Called async getVolumeKmsKey");
        final GetVolumeKmsKeyRequest interceptedRequest = GetVolumeKmsKeyConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetVolumeKmsKeyConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetVolumeKmsKeyResponse> transformer = GetVolumeKmsKeyConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetVolumeKmsKeyRequest, GetVolumeKmsKeyResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetVolumeKmsKeyRequest, GetVolumeKmsKeyResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetVolumeKmsKeyRequest, GetVolumeKmsKeyResponse> onSuccess = new SuccessConsumer<GetVolumeKmsKeyRequest, GetVolumeKmsKeyResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetVolumeKmsKeyRequest> onError = new ErrorConsumer<GetVolumeKmsKeyRequest>(this, interceptedRequest);
                    BlockstorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetVolumeKmsKeyRequest, GetVolumeKmsKeyResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetVolumeKmsKeyRequest, GetVolumeKmsKeyResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetVolumeKmsKeyRequest> onError = handler == null ? null : new ErrorConsumer<GetVolumeKmsKeyRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetVolumeKmsKeyResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BlockstorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetVolumeKmsKeyResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListBootVolumeBackupsResponse> listBootVolumeBackups(ListBootVolumeBackupsRequest request, AsyncHandler<ListBootVolumeBackupsRequest, ListBootVolumeBackupsResponse> handler) {
        LOG.trace("Called async listBootVolumeBackups");
        final ListBootVolumeBackupsRequest interceptedRequest = ListBootVolumeBackupsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListBootVolumeBackupsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListBootVolumeBackupsResponse> transformer = ListBootVolumeBackupsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListBootVolumeBackupsRequest, ListBootVolumeBackupsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListBootVolumeBackupsRequest, ListBootVolumeBackupsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListBootVolumeBackupsRequest, ListBootVolumeBackupsResponse> onSuccess = new SuccessConsumer<ListBootVolumeBackupsRequest, ListBootVolumeBackupsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListBootVolumeBackupsRequest> onError = new ErrorConsumer<ListBootVolumeBackupsRequest>(this, interceptedRequest);
                    BlockstorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListBootVolumeBackupsRequest, ListBootVolumeBackupsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListBootVolumeBackupsRequest, ListBootVolumeBackupsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListBootVolumeBackupsRequest> onError = handler == null ? null : new ErrorConsumer<ListBootVolumeBackupsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListBootVolumeBackupsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BlockstorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListBootVolumeBackupsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListBootVolumesResponse> listBootVolumes(ListBootVolumesRequest request, AsyncHandler<ListBootVolumesRequest, ListBootVolumesResponse> handler) {
        LOG.trace("Called async listBootVolumes");
        final ListBootVolumesRequest interceptedRequest = ListBootVolumesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListBootVolumesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListBootVolumesResponse> transformer = ListBootVolumesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListBootVolumesRequest, ListBootVolumesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListBootVolumesRequest, ListBootVolumesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListBootVolumesRequest, ListBootVolumesResponse> onSuccess = new SuccessConsumer<ListBootVolumesRequest, ListBootVolumesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListBootVolumesRequest> onError = new ErrorConsumer<ListBootVolumesRequest>(this, interceptedRequest);
                    BlockstorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListBootVolumesRequest, ListBootVolumesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListBootVolumesRequest, ListBootVolumesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListBootVolumesRequest> onError = handler == null ? null : new ErrorConsumer<ListBootVolumesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListBootVolumesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BlockstorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListBootVolumesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListVolumeBackupPoliciesResponse> listVolumeBackupPolicies(ListVolumeBackupPoliciesRequest request, AsyncHandler<ListVolumeBackupPoliciesRequest, ListVolumeBackupPoliciesResponse> handler) {
        LOG.trace("Called async listVolumeBackupPolicies");
        final ListVolumeBackupPoliciesRequest interceptedRequest = ListVolumeBackupPoliciesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListVolumeBackupPoliciesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListVolumeBackupPoliciesResponse> transformer = ListVolumeBackupPoliciesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListVolumeBackupPoliciesRequest, ListVolumeBackupPoliciesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListVolumeBackupPoliciesRequest, ListVolumeBackupPoliciesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListVolumeBackupPoliciesRequest, ListVolumeBackupPoliciesResponse> onSuccess = new SuccessConsumer<ListVolumeBackupPoliciesRequest, ListVolumeBackupPoliciesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListVolumeBackupPoliciesRequest> onError = new ErrorConsumer<ListVolumeBackupPoliciesRequest>(this, interceptedRequest);
                    BlockstorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListVolumeBackupPoliciesRequest, ListVolumeBackupPoliciesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListVolumeBackupPoliciesRequest, ListVolumeBackupPoliciesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListVolumeBackupPoliciesRequest> onError = handler == null ? null : new ErrorConsumer<ListVolumeBackupPoliciesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListVolumeBackupPoliciesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BlockstorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListVolumeBackupPoliciesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListVolumeBackupsResponse> listVolumeBackups(ListVolumeBackupsRequest request, AsyncHandler<ListVolumeBackupsRequest, ListVolumeBackupsResponse> handler) {
        LOG.trace("Called async listVolumeBackups");
        final ListVolumeBackupsRequest interceptedRequest = ListVolumeBackupsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListVolumeBackupsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListVolumeBackupsResponse> transformer = ListVolumeBackupsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListVolumeBackupsRequest, ListVolumeBackupsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListVolumeBackupsRequest, ListVolumeBackupsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListVolumeBackupsRequest, ListVolumeBackupsResponse> onSuccess = new SuccessConsumer<ListVolumeBackupsRequest, ListVolumeBackupsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListVolumeBackupsRequest> onError = new ErrorConsumer<ListVolumeBackupsRequest>(this, interceptedRequest);
                    BlockstorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListVolumeBackupsRequest, ListVolumeBackupsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListVolumeBackupsRequest, ListVolumeBackupsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListVolumeBackupsRequest> onError = handler == null ? null : new ErrorConsumer<ListVolumeBackupsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListVolumeBackupsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BlockstorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListVolumeBackupsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListVolumeGroupBackupsResponse> listVolumeGroupBackups(ListVolumeGroupBackupsRequest request, AsyncHandler<ListVolumeGroupBackupsRequest, ListVolumeGroupBackupsResponse> handler) {
        LOG.trace("Called async listVolumeGroupBackups");
        final ListVolumeGroupBackupsRequest interceptedRequest = ListVolumeGroupBackupsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListVolumeGroupBackupsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListVolumeGroupBackupsResponse> transformer = ListVolumeGroupBackupsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListVolumeGroupBackupsRequest, ListVolumeGroupBackupsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListVolumeGroupBackupsRequest, ListVolumeGroupBackupsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListVolumeGroupBackupsRequest, ListVolumeGroupBackupsResponse> onSuccess = new SuccessConsumer<ListVolumeGroupBackupsRequest, ListVolumeGroupBackupsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListVolumeGroupBackupsRequest> onError = new ErrorConsumer<ListVolumeGroupBackupsRequest>(this, interceptedRequest);
                    BlockstorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListVolumeGroupBackupsRequest, ListVolumeGroupBackupsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListVolumeGroupBackupsRequest, ListVolumeGroupBackupsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListVolumeGroupBackupsRequest> onError = handler == null ? null : new ErrorConsumer<ListVolumeGroupBackupsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListVolumeGroupBackupsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BlockstorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListVolumeGroupBackupsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListVolumeGroupsResponse> listVolumeGroups(ListVolumeGroupsRequest request, AsyncHandler<ListVolumeGroupsRequest, ListVolumeGroupsResponse> handler) {
        LOG.trace("Called async listVolumeGroups");
        final ListVolumeGroupsRequest interceptedRequest = ListVolumeGroupsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListVolumeGroupsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListVolumeGroupsResponse> transformer = ListVolumeGroupsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListVolumeGroupsRequest, ListVolumeGroupsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListVolumeGroupsRequest, ListVolumeGroupsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListVolumeGroupsRequest, ListVolumeGroupsResponse> onSuccess = new SuccessConsumer<ListVolumeGroupsRequest, ListVolumeGroupsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListVolumeGroupsRequest> onError = new ErrorConsumer<ListVolumeGroupsRequest>(this, interceptedRequest);
                    BlockstorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListVolumeGroupsRequest, ListVolumeGroupsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListVolumeGroupsRequest, ListVolumeGroupsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListVolumeGroupsRequest> onError = handler == null ? null : new ErrorConsumer<ListVolumeGroupsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListVolumeGroupsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BlockstorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListVolumeGroupsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListVolumesResponse> listVolumes(ListVolumesRequest request, AsyncHandler<ListVolumesRequest, ListVolumesResponse> handler) {
        LOG.trace("Called async listVolumes");
        final ListVolumesRequest interceptedRequest = ListVolumesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListVolumesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListVolumesResponse> transformer = ListVolumesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListVolumesRequest, ListVolumesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListVolumesRequest, ListVolumesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListVolumesRequest, ListVolumesResponse> onSuccess = new SuccessConsumer<ListVolumesRequest, ListVolumesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListVolumesRequest> onError = new ErrorConsumer<ListVolumesRequest>(this, interceptedRequest);
                    BlockstorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListVolumesRequest, ListVolumesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListVolumesRequest, ListVolumesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListVolumesRequest> onError = handler == null ? null : new ErrorConsumer<ListVolumesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListVolumesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BlockstorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListVolumesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateBootVolumeResponse> updateBootVolume(UpdateBootVolumeRequest request, AsyncHandler<UpdateBootVolumeRequest, UpdateBootVolumeResponse> handler) {
        LOG.trace("Called async updateBootVolume");
        final UpdateBootVolumeRequest interceptedRequest = UpdateBootVolumeConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateBootVolumeConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateBootVolumeResponse> transformer = UpdateBootVolumeConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateBootVolumeRequest, UpdateBootVolumeResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateBootVolumeRequest, UpdateBootVolumeResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateBootVolumeRequest, UpdateBootVolumeResponse> onSuccess = new SuccessConsumer<UpdateBootVolumeRequest, UpdateBootVolumeResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateBootVolumeRequest> onError = new ErrorConsumer<UpdateBootVolumeRequest>(this, interceptedRequest);
                    BlockstorageAsyncClient.this.client.put(ib, interceptedRequest.getUpdateBootVolumeDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateBootVolumeRequest, UpdateBootVolumeResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateBootVolumeRequest, UpdateBootVolumeResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateBootVolumeRequest> onError = handler == null ? null : new ErrorConsumer<UpdateBootVolumeRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateBootVolumeDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateBootVolumeResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BlockstorageAsyncClient.this.client.put(ib, interceptedRequest.getUpdateBootVolumeDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateBootVolumeResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateBootVolumeBackupResponse> updateBootVolumeBackup(UpdateBootVolumeBackupRequest request, AsyncHandler<UpdateBootVolumeBackupRequest, UpdateBootVolumeBackupResponse> handler) {
        LOG.trace("Called async updateBootVolumeBackup");
        final UpdateBootVolumeBackupRequest interceptedRequest = UpdateBootVolumeBackupConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateBootVolumeBackupConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateBootVolumeBackupResponse> transformer = UpdateBootVolumeBackupConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateBootVolumeBackupRequest, UpdateBootVolumeBackupResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateBootVolumeBackupRequest, UpdateBootVolumeBackupResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateBootVolumeBackupRequest, UpdateBootVolumeBackupResponse> onSuccess = new SuccessConsumer<UpdateBootVolumeBackupRequest, UpdateBootVolumeBackupResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateBootVolumeBackupRequest> onError = new ErrorConsumer<UpdateBootVolumeBackupRequest>(this, interceptedRequest);
                    BlockstorageAsyncClient.this.client.put(ib, interceptedRequest.getUpdateBootVolumeBackupDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateBootVolumeBackupRequest, UpdateBootVolumeBackupResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateBootVolumeBackupRequest, UpdateBootVolumeBackupResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateBootVolumeBackupRequest> onError = handler == null ? null : new ErrorConsumer<UpdateBootVolumeBackupRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateBootVolumeBackupDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateBootVolumeBackupResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BlockstorageAsyncClient.this.client.put(ib, interceptedRequest.getUpdateBootVolumeBackupDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateBootVolumeBackupResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateBootVolumeKmsKeyResponse> updateBootVolumeKmsKey(UpdateBootVolumeKmsKeyRequest request, AsyncHandler<UpdateBootVolumeKmsKeyRequest, UpdateBootVolumeKmsKeyResponse> handler) {
        LOG.trace("Called async updateBootVolumeKmsKey");
        final UpdateBootVolumeKmsKeyRequest interceptedRequest = UpdateBootVolumeKmsKeyConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateBootVolumeKmsKeyConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateBootVolumeKmsKeyResponse> transformer = UpdateBootVolumeKmsKeyConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateBootVolumeKmsKeyRequest, UpdateBootVolumeKmsKeyResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateBootVolumeKmsKeyRequest, UpdateBootVolumeKmsKeyResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateBootVolumeKmsKeyRequest, UpdateBootVolumeKmsKeyResponse> onSuccess = new SuccessConsumer<UpdateBootVolumeKmsKeyRequest, UpdateBootVolumeKmsKeyResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateBootVolumeKmsKeyRequest> onError = new ErrorConsumer<UpdateBootVolumeKmsKeyRequest>(this, interceptedRequest);
                    BlockstorageAsyncClient.this.client.put(ib, interceptedRequest.getUpdateBootVolumeKmsKeyDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateBootVolumeKmsKeyRequest, UpdateBootVolumeKmsKeyResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateBootVolumeKmsKeyRequest, UpdateBootVolumeKmsKeyResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateBootVolumeKmsKeyRequest> onError = handler == null ? null : new ErrorConsumer<UpdateBootVolumeKmsKeyRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateBootVolumeKmsKeyDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateBootVolumeKmsKeyResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BlockstorageAsyncClient.this.client.put(ib, interceptedRequest.getUpdateBootVolumeKmsKeyDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateBootVolumeKmsKeyResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateVolumeResponse> updateVolume(UpdateVolumeRequest request, AsyncHandler<UpdateVolumeRequest, UpdateVolumeResponse> handler) {
        LOG.trace("Called async updateVolume");
        final UpdateVolumeRequest interceptedRequest = UpdateVolumeConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateVolumeConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateVolumeResponse> transformer = UpdateVolumeConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateVolumeRequest, UpdateVolumeResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateVolumeRequest, UpdateVolumeResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateVolumeRequest, UpdateVolumeResponse> onSuccess = new SuccessConsumer<UpdateVolumeRequest, UpdateVolumeResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateVolumeRequest> onError = new ErrorConsumer<UpdateVolumeRequest>(this, interceptedRequest);
                    BlockstorageAsyncClient.this.client.put(ib, interceptedRequest.getUpdateVolumeDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateVolumeRequest, UpdateVolumeResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateVolumeRequest, UpdateVolumeResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateVolumeRequest> onError = handler == null ? null : new ErrorConsumer<UpdateVolumeRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateVolumeDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateVolumeResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BlockstorageAsyncClient.this.client.put(ib, interceptedRequest.getUpdateVolumeDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateVolumeResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateVolumeBackupResponse> updateVolumeBackup(UpdateVolumeBackupRequest request, AsyncHandler<UpdateVolumeBackupRequest, UpdateVolumeBackupResponse> handler) {
        LOG.trace("Called async updateVolumeBackup");
        final UpdateVolumeBackupRequest interceptedRequest = UpdateVolumeBackupConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateVolumeBackupConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateVolumeBackupResponse> transformer = UpdateVolumeBackupConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateVolumeBackupRequest, UpdateVolumeBackupResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateVolumeBackupRequest, UpdateVolumeBackupResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateVolumeBackupRequest, UpdateVolumeBackupResponse> onSuccess = new SuccessConsumer<UpdateVolumeBackupRequest, UpdateVolumeBackupResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateVolumeBackupRequest> onError = new ErrorConsumer<UpdateVolumeBackupRequest>(this, interceptedRequest);
                    BlockstorageAsyncClient.this.client.put(ib, interceptedRequest.getUpdateVolumeBackupDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateVolumeBackupRequest, UpdateVolumeBackupResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateVolumeBackupRequest, UpdateVolumeBackupResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateVolumeBackupRequest> onError = handler == null ? null : new ErrorConsumer<UpdateVolumeBackupRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateVolumeBackupDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateVolumeBackupResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BlockstorageAsyncClient.this.client.put(ib, interceptedRequest.getUpdateVolumeBackupDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateVolumeBackupResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateVolumeBackupPolicyResponse> updateVolumeBackupPolicy(UpdateVolumeBackupPolicyRequest request, AsyncHandler<UpdateVolumeBackupPolicyRequest, UpdateVolumeBackupPolicyResponse> handler) {
        LOG.trace("Called async updateVolumeBackupPolicy");
        final UpdateVolumeBackupPolicyRequest interceptedRequest = UpdateVolumeBackupPolicyConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateVolumeBackupPolicyConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateVolumeBackupPolicyResponse> transformer = UpdateVolumeBackupPolicyConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateVolumeBackupPolicyRequest, UpdateVolumeBackupPolicyResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateVolumeBackupPolicyRequest, UpdateVolumeBackupPolicyResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateVolumeBackupPolicyRequest, UpdateVolumeBackupPolicyResponse> onSuccess = new SuccessConsumer<UpdateVolumeBackupPolicyRequest, UpdateVolumeBackupPolicyResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateVolumeBackupPolicyRequest> onError = new ErrorConsumer<UpdateVolumeBackupPolicyRequest>(this, interceptedRequest);
                    BlockstorageAsyncClient.this.client.put(ib, interceptedRequest.getUpdateVolumeBackupPolicyDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateVolumeBackupPolicyRequest, UpdateVolumeBackupPolicyResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateVolumeBackupPolicyRequest, UpdateVolumeBackupPolicyResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateVolumeBackupPolicyRequest> onError = handler == null ? null : new ErrorConsumer<UpdateVolumeBackupPolicyRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateVolumeBackupPolicyDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateVolumeBackupPolicyResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BlockstorageAsyncClient.this.client.put(ib, interceptedRequest.getUpdateVolumeBackupPolicyDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateVolumeBackupPolicyResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateVolumeGroupResponse> updateVolumeGroup(UpdateVolumeGroupRequest request, AsyncHandler<UpdateVolumeGroupRequest, UpdateVolumeGroupResponse> handler) {
        LOG.trace("Called async updateVolumeGroup");
        final UpdateVolumeGroupRequest interceptedRequest = UpdateVolumeGroupConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateVolumeGroupConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateVolumeGroupResponse> transformer = UpdateVolumeGroupConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateVolumeGroupRequest, UpdateVolumeGroupResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateVolumeGroupRequest, UpdateVolumeGroupResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateVolumeGroupRequest, UpdateVolumeGroupResponse> onSuccess = new SuccessConsumer<UpdateVolumeGroupRequest, UpdateVolumeGroupResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateVolumeGroupRequest> onError = new ErrorConsumer<UpdateVolumeGroupRequest>(this, interceptedRequest);
                    BlockstorageAsyncClient.this.client.put(ib, interceptedRequest.getUpdateVolumeGroupDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateVolumeGroupRequest, UpdateVolumeGroupResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateVolumeGroupRequest, UpdateVolumeGroupResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateVolumeGroupRequest> onError = handler == null ? null : new ErrorConsumer<UpdateVolumeGroupRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateVolumeGroupDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateVolumeGroupResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BlockstorageAsyncClient.this.client.put(ib, interceptedRequest.getUpdateVolumeGroupDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateVolumeGroupResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateVolumeGroupBackupResponse> updateVolumeGroupBackup(UpdateVolumeGroupBackupRequest request, AsyncHandler<UpdateVolumeGroupBackupRequest, UpdateVolumeGroupBackupResponse> handler) {
        LOG.trace("Called async updateVolumeGroupBackup");
        final UpdateVolumeGroupBackupRequest interceptedRequest = UpdateVolumeGroupBackupConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateVolumeGroupBackupConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateVolumeGroupBackupResponse> transformer = UpdateVolumeGroupBackupConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateVolumeGroupBackupRequest, UpdateVolumeGroupBackupResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateVolumeGroupBackupRequest, UpdateVolumeGroupBackupResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateVolumeGroupBackupRequest, UpdateVolumeGroupBackupResponse> onSuccess = new SuccessConsumer<UpdateVolumeGroupBackupRequest, UpdateVolumeGroupBackupResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateVolumeGroupBackupRequest> onError = new ErrorConsumer<UpdateVolumeGroupBackupRequest>(this, interceptedRequest);
                    BlockstorageAsyncClient.this.client.put(ib, interceptedRequest.getUpdateVolumeGroupBackupDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateVolumeGroupBackupRequest, UpdateVolumeGroupBackupResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateVolumeGroupBackupRequest, UpdateVolumeGroupBackupResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateVolumeGroupBackupRequest> onError = handler == null ? null : new ErrorConsumer<UpdateVolumeGroupBackupRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateVolumeGroupBackupDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateVolumeGroupBackupResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BlockstorageAsyncClient.this.client.put(ib, interceptedRequest.getUpdateVolumeGroupBackupDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateVolumeGroupBackupResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateVolumeKmsKeyResponse> updateVolumeKmsKey(UpdateVolumeKmsKeyRequest request, AsyncHandler<UpdateVolumeKmsKeyRequest, UpdateVolumeKmsKeyResponse> handler) {
        LOG.trace("Called async updateVolumeKmsKey");
        final UpdateVolumeKmsKeyRequest interceptedRequest = UpdateVolumeKmsKeyConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateVolumeKmsKeyConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateVolumeKmsKeyResponse> transformer = UpdateVolumeKmsKeyConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateVolumeKmsKeyRequest, UpdateVolumeKmsKeyResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateVolumeKmsKeyRequest, UpdateVolumeKmsKeyResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateVolumeKmsKeyRequest, UpdateVolumeKmsKeyResponse> onSuccess = new SuccessConsumer<UpdateVolumeKmsKeyRequest, UpdateVolumeKmsKeyResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateVolumeKmsKeyRequest> onError = new ErrorConsumer<UpdateVolumeKmsKeyRequest>(this, interceptedRequest);
                    BlockstorageAsyncClient.this.client.put(ib, interceptedRequest.getUpdateVolumeKmsKeyDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateVolumeKmsKeyRequest, UpdateVolumeKmsKeyResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateVolumeKmsKeyRequest, UpdateVolumeKmsKeyResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateVolumeKmsKeyRequest> onError = handler == null ? null : new ErrorConsumer<UpdateVolumeKmsKeyRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateVolumeKmsKeyDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateVolumeKmsKeyResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return BlockstorageAsyncClient.this.client.put(ib, interceptedRequest.getUpdateVolumeKmsKeyDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateVolumeKmsKeyResponse>(responseFuture, transformer);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, BlockstorageAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        @Override
        public BlockstorageAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new BlockstorageAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

