/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.core.Blockstorage;
import com.oracle.bmc.core.BlockstoragePaginators;
import com.oracle.bmc.core.BlockstorageWaiters;
import com.oracle.bmc.core.internal.http.ChangeBootVolumeBackupCompartmentConverter;
import com.oracle.bmc.core.internal.http.ChangeBootVolumeCompartmentConverter;
import com.oracle.bmc.core.internal.http.ChangeVolumeBackupCompartmentConverter;
import com.oracle.bmc.core.internal.http.ChangeVolumeCompartmentConverter;
import com.oracle.bmc.core.internal.http.ChangeVolumeGroupBackupCompartmentConverter;
import com.oracle.bmc.core.internal.http.ChangeVolumeGroupCompartmentConverter;
import com.oracle.bmc.core.internal.http.CopyVolumeBackupConverter;
import com.oracle.bmc.core.internal.http.CreateBootVolumeBackupConverter;
import com.oracle.bmc.core.internal.http.CreateBootVolumeConverter;
import com.oracle.bmc.core.internal.http.CreateVolumeBackupConverter;
import com.oracle.bmc.core.internal.http.CreateVolumeBackupPolicyAssignmentConverter;
import com.oracle.bmc.core.internal.http.CreateVolumeBackupPolicyConverter;
import com.oracle.bmc.core.internal.http.CreateVolumeConverter;
import com.oracle.bmc.core.internal.http.CreateVolumeGroupBackupConverter;
import com.oracle.bmc.core.internal.http.CreateVolumeGroupConverter;
import com.oracle.bmc.core.internal.http.DeleteBootVolumeBackupConverter;
import com.oracle.bmc.core.internal.http.DeleteBootVolumeConverter;
import com.oracle.bmc.core.internal.http.DeleteBootVolumeKmsKeyConverter;
import com.oracle.bmc.core.internal.http.DeleteVolumeBackupConverter;
import com.oracle.bmc.core.internal.http.DeleteVolumeBackupPolicyAssignmentConverter;
import com.oracle.bmc.core.internal.http.DeleteVolumeBackupPolicyConverter;
import com.oracle.bmc.core.internal.http.DeleteVolumeConverter;
import com.oracle.bmc.core.internal.http.DeleteVolumeGroupBackupConverter;
import com.oracle.bmc.core.internal.http.DeleteVolumeGroupConverter;
import com.oracle.bmc.core.internal.http.DeleteVolumeKmsKeyConverter;
import com.oracle.bmc.core.internal.http.GetBootVolumeBackupConverter;
import com.oracle.bmc.core.internal.http.GetBootVolumeConverter;
import com.oracle.bmc.core.internal.http.GetBootVolumeKmsKeyConverter;
import com.oracle.bmc.core.internal.http.GetVolumeBackupConverter;
import com.oracle.bmc.core.internal.http.GetVolumeBackupPolicyAssetAssignmentConverter;
import com.oracle.bmc.core.internal.http.GetVolumeBackupPolicyAssignmentConverter;
import com.oracle.bmc.core.internal.http.GetVolumeBackupPolicyConverter;
import com.oracle.bmc.core.internal.http.GetVolumeConverter;
import com.oracle.bmc.core.internal.http.GetVolumeGroupBackupConverter;
import com.oracle.bmc.core.internal.http.GetVolumeGroupConverter;
import com.oracle.bmc.core.internal.http.GetVolumeKmsKeyConverter;
import com.oracle.bmc.core.internal.http.ListBootVolumeBackupsConverter;
import com.oracle.bmc.core.internal.http.ListBootVolumesConverter;
import com.oracle.bmc.core.internal.http.ListVolumeBackupPoliciesConverter;
import com.oracle.bmc.core.internal.http.ListVolumeBackupsConverter;
import com.oracle.bmc.core.internal.http.ListVolumeGroupBackupsConverter;
import com.oracle.bmc.core.internal.http.ListVolumeGroupsConverter;
import com.oracle.bmc.core.internal.http.ListVolumesConverter;
import com.oracle.bmc.core.internal.http.UpdateBootVolumeBackupConverter;
import com.oracle.bmc.core.internal.http.UpdateBootVolumeConverter;
import com.oracle.bmc.core.internal.http.UpdateBootVolumeKmsKeyConverter;
import com.oracle.bmc.core.internal.http.UpdateVolumeBackupConverter;
import com.oracle.bmc.core.internal.http.UpdateVolumeBackupPolicyConverter;
import com.oracle.bmc.core.internal.http.UpdateVolumeConverter;
import com.oracle.bmc.core.internal.http.UpdateVolumeGroupBackupConverter;
import com.oracle.bmc.core.internal.http.UpdateVolumeGroupConverter;
import com.oracle.bmc.core.internal.http.UpdateVolumeKmsKeyConverter;
import com.oracle.bmc.core.requests.ChangeBootVolumeBackupCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeBootVolumeCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeVolumeBackupCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeVolumeCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeVolumeGroupBackupCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeVolumeGroupCompartmentRequest;
import com.oracle.bmc.core.requests.CopyVolumeBackupRequest;
import com.oracle.bmc.core.requests.CreateBootVolumeBackupRequest;
import com.oracle.bmc.core.requests.CreateBootVolumeRequest;
import com.oracle.bmc.core.requests.CreateVolumeBackupPolicyAssignmentRequest;
import com.oracle.bmc.core.requests.CreateVolumeBackupPolicyRequest;
import com.oracle.bmc.core.requests.CreateVolumeBackupRequest;
import com.oracle.bmc.core.requests.CreateVolumeGroupBackupRequest;
import com.oracle.bmc.core.requests.CreateVolumeGroupRequest;
import com.oracle.bmc.core.requests.CreateVolumeRequest;
import com.oracle.bmc.core.requests.DeleteBootVolumeBackupRequest;
import com.oracle.bmc.core.requests.DeleteBootVolumeKmsKeyRequest;
import com.oracle.bmc.core.requests.DeleteBootVolumeRequest;
import com.oracle.bmc.core.requests.DeleteVolumeBackupPolicyAssignmentRequest;
import com.oracle.bmc.core.requests.DeleteVolumeBackupPolicyRequest;
import com.oracle.bmc.core.requests.DeleteVolumeBackupRequest;
import com.oracle.bmc.core.requests.DeleteVolumeGroupBackupRequest;
import com.oracle.bmc.core.requests.DeleteVolumeGroupRequest;
import com.oracle.bmc.core.requests.DeleteVolumeKmsKeyRequest;
import com.oracle.bmc.core.requests.DeleteVolumeRequest;
import com.oracle.bmc.core.requests.GetBootVolumeBackupRequest;
import com.oracle.bmc.core.requests.GetBootVolumeKmsKeyRequest;
import com.oracle.bmc.core.requests.GetBootVolumeRequest;
import com.oracle.bmc.core.requests.GetVolumeBackupPolicyAssetAssignmentRequest;
import com.oracle.bmc.core.requests.GetVolumeBackupPolicyAssignmentRequest;
import com.oracle.bmc.core.requests.GetVolumeBackupPolicyRequest;
import com.oracle.bmc.core.requests.GetVolumeBackupRequest;
import com.oracle.bmc.core.requests.GetVolumeGroupBackupRequest;
import com.oracle.bmc.core.requests.GetVolumeGroupRequest;
import com.oracle.bmc.core.requests.GetVolumeKmsKeyRequest;
import com.oracle.bmc.core.requests.GetVolumeRequest;
import com.oracle.bmc.core.requests.ListBootVolumeBackupsRequest;
import com.oracle.bmc.core.requests.ListBootVolumesRequest;
import com.oracle.bmc.core.requests.ListVolumeBackupPoliciesRequest;
import com.oracle.bmc.core.requests.ListVolumeBackupsRequest;
import com.oracle.bmc.core.requests.ListVolumeGroupBackupsRequest;
import com.oracle.bmc.core.requests.ListVolumeGroupsRequest;
import com.oracle.bmc.core.requests.ListVolumesRequest;
import com.oracle.bmc.core.requests.UpdateBootVolumeBackupRequest;
import com.oracle.bmc.core.requests.UpdateBootVolumeKmsKeyRequest;
import com.oracle.bmc.core.requests.UpdateBootVolumeRequest;
import com.oracle.bmc.core.requests.UpdateVolumeBackupPolicyRequest;
import com.oracle.bmc.core.requests.UpdateVolumeBackupRequest;
import com.oracle.bmc.core.requests.UpdateVolumeGroupBackupRequest;
import com.oracle.bmc.core.requests.UpdateVolumeGroupRequest;
import com.oracle.bmc.core.requests.UpdateVolumeKmsKeyRequest;
import com.oracle.bmc.core.requests.UpdateVolumeRequest;
import com.oracle.bmc.core.responses.ChangeBootVolumeBackupCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeBootVolumeCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeVolumeBackupCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeVolumeCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeVolumeGroupBackupCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeVolumeGroupCompartmentResponse;
import com.oracle.bmc.core.responses.CopyVolumeBackupResponse;
import com.oracle.bmc.core.responses.CreateBootVolumeBackupResponse;
import com.oracle.bmc.core.responses.CreateBootVolumeResponse;
import com.oracle.bmc.core.responses.CreateVolumeBackupPolicyAssignmentResponse;
import com.oracle.bmc.core.responses.CreateVolumeBackupPolicyResponse;
import com.oracle.bmc.core.responses.CreateVolumeBackupResponse;
import com.oracle.bmc.core.responses.CreateVolumeGroupBackupResponse;
import com.oracle.bmc.core.responses.CreateVolumeGroupResponse;
import com.oracle.bmc.core.responses.CreateVolumeResponse;
import com.oracle.bmc.core.responses.DeleteBootVolumeBackupResponse;
import com.oracle.bmc.core.responses.DeleteBootVolumeKmsKeyResponse;
import com.oracle.bmc.core.responses.DeleteBootVolumeResponse;
import com.oracle.bmc.core.responses.DeleteVolumeBackupPolicyAssignmentResponse;
import com.oracle.bmc.core.responses.DeleteVolumeBackupPolicyResponse;
import com.oracle.bmc.core.responses.DeleteVolumeBackupResponse;
import com.oracle.bmc.core.responses.DeleteVolumeGroupBackupResponse;
import com.oracle.bmc.core.responses.DeleteVolumeGroupResponse;
import com.oracle.bmc.core.responses.DeleteVolumeKmsKeyResponse;
import com.oracle.bmc.core.responses.DeleteVolumeResponse;
import com.oracle.bmc.core.responses.GetBootVolumeBackupResponse;
import com.oracle.bmc.core.responses.GetBootVolumeKmsKeyResponse;
import com.oracle.bmc.core.responses.GetBootVolumeResponse;
import com.oracle.bmc.core.responses.GetVolumeBackupPolicyAssetAssignmentResponse;
import com.oracle.bmc.core.responses.GetVolumeBackupPolicyAssignmentResponse;
import com.oracle.bmc.core.responses.GetVolumeBackupPolicyResponse;
import com.oracle.bmc.core.responses.GetVolumeBackupResponse;
import com.oracle.bmc.core.responses.GetVolumeGroupBackupResponse;
import com.oracle.bmc.core.responses.GetVolumeGroupResponse;
import com.oracle.bmc.core.responses.GetVolumeKmsKeyResponse;
import com.oracle.bmc.core.responses.GetVolumeResponse;
import com.oracle.bmc.core.responses.ListBootVolumeBackupsResponse;
import com.oracle.bmc.core.responses.ListBootVolumesResponse;
import com.oracle.bmc.core.responses.ListVolumeBackupPoliciesResponse;
import com.oracle.bmc.core.responses.ListVolumeBackupsResponse;
import com.oracle.bmc.core.responses.ListVolumeGroupBackupsResponse;
import com.oracle.bmc.core.responses.ListVolumeGroupsResponse;
import com.oracle.bmc.core.responses.ListVolumesResponse;
import com.oracle.bmc.core.responses.UpdateBootVolumeBackupResponse;
import com.oracle.bmc.core.responses.UpdateBootVolumeKmsKeyResponse;
import com.oracle.bmc.core.responses.UpdateBootVolumeResponse;
import com.oracle.bmc.core.responses.UpdateVolumeBackupPolicyResponse;
import com.oracle.bmc.core.responses.UpdateVolumeBackupResponse;
import com.oracle.bmc.core.responses.UpdateVolumeGroupBackupResponse;
import com.oracle.bmc.core.responses.UpdateVolumeGroupResponse;
import com.oracle.bmc.core.responses.UpdateVolumeKmsKeyResponse;
import com.oracle.bmc.core.responses.UpdateVolumeResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import com.oracle.bmc.workrequests.WorkRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockstorageClient
implements Blockstorage {
    private static final Logger LOG = LoggerFactory.getLogger(BlockstorageClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("BLOCKSTORAGE").serviceEndpointPrefix("iaas").serviceEndpointTemplate("https://iaas.{region}.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final BlockstorageWaiters waiters;
    private final BlockstoragePaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final ExecutorService executorService;
    private final RetryConfiguration retryConfiguration;

    public BlockstorageClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public BlockstorageClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public BlockstorageClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public BlockstorageClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public BlockstorageClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public BlockstorageClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public BlockstorageClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public BlockstorageClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Blockstorage-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.executorService = executorService;
        this.waiters = new BlockstorageWaiters(executorService, this);
        this.paginators = new BlockstoragePaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)((Object)this.authenticationDetailsProvider)).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional<String> endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(SERVICE, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public ChangeBootVolumeBackupCompartmentResponse changeBootVolumeBackupCompartment(ChangeBootVolumeBackupCompartmentRequest request) {
        LOG.trace("Called changeBootVolumeBackupCompartment");
        ChangeBootVolumeBackupCompartmentRequest interceptedRequest = ChangeBootVolumeBackupCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeBootVolumeBackupCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeBootVolumeBackupCompartmentResponse> transformer = ChangeBootVolumeBackupCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getChangeBootVolumeBackupCompartmentDetails(), retriedRequest);
                return (ChangeBootVolumeBackupCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeBootVolumeCompartmentResponse changeBootVolumeCompartment(ChangeBootVolumeCompartmentRequest request) {
        LOG.trace("Called changeBootVolumeCompartment");
        ChangeBootVolumeCompartmentRequest interceptedRequest = ChangeBootVolumeCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeBootVolumeCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeBootVolumeCompartmentResponse> transformer = ChangeBootVolumeCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getChangeBootVolumeCompartmentDetails(), retriedRequest);
                return (ChangeBootVolumeCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeVolumeBackupCompartmentResponse changeVolumeBackupCompartment(ChangeVolumeBackupCompartmentRequest request) {
        LOG.trace("Called changeVolumeBackupCompartment");
        ChangeVolumeBackupCompartmentRequest interceptedRequest = ChangeVolumeBackupCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeVolumeBackupCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeVolumeBackupCompartmentResponse> transformer = ChangeVolumeBackupCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getChangeVolumeBackupCompartmentDetails(), retriedRequest);
                return (ChangeVolumeBackupCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeVolumeCompartmentResponse changeVolumeCompartment(ChangeVolumeCompartmentRequest request) {
        LOG.trace("Called changeVolumeCompartment");
        ChangeVolumeCompartmentRequest interceptedRequest = ChangeVolumeCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeVolumeCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeVolumeCompartmentResponse> transformer = ChangeVolumeCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getChangeVolumeCompartmentDetails(), retriedRequest);
                return (ChangeVolumeCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeVolumeGroupBackupCompartmentResponse changeVolumeGroupBackupCompartment(ChangeVolumeGroupBackupCompartmentRequest request) {
        LOG.trace("Called changeVolumeGroupBackupCompartment");
        ChangeVolumeGroupBackupCompartmentRequest interceptedRequest = ChangeVolumeGroupBackupCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeVolumeGroupBackupCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeVolumeGroupBackupCompartmentResponse> transformer = ChangeVolumeGroupBackupCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getChangeVolumeGroupBackupCompartmentDetails(), retriedRequest);
                return (ChangeVolumeGroupBackupCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeVolumeGroupCompartmentResponse changeVolumeGroupCompartment(ChangeVolumeGroupCompartmentRequest request) {
        LOG.trace("Called changeVolumeGroupCompartment");
        ChangeVolumeGroupCompartmentRequest interceptedRequest = ChangeVolumeGroupCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeVolumeGroupCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeVolumeGroupCompartmentResponse> transformer = ChangeVolumeGroupCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getChangeVolumeGroupCompartmentDetails(), retriedRequest);
                return (ChangeVolumeGroupCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CopyVolumeBackupResponse copyVolumeBackup(CopyVolumeBackupRequest request) {
        LOG.trace("Called copyVolumeBackup");
        CopyVolumeBackupRequest interceptedRequest = CopyVolumeBackupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CopyVolumeBackupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CopyVolumeBackupResponse> transformer = CopyVolumeBackupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCopyVolumeBackupDetails(), retriedRequest);
                return (CopyVolumeBackupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateBootVolumeResponse createBootVolume(CreateBootVolumeRequest request) {
        LOG.trace("Called createBootVolume");
        CreateBootVolumeRequest interceptedRequest = CreateBootVolumeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateBootVolumeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateBootVolumeResponse> transformer = CreateBootVolumeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateBootVolumeDetails(), retriedRequest);
                return (CreateBootVolumeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateBootVolumeBackupResponse createBootVolumeBackup(CreateBootVolumeBackupRequest request) {
        LOG.trace("Called createBootVolumeBackup");
        CreateBootVolumeBackupRequest interceptedRequest = CreateBootVolumeBackupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateBootVolumeBackupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateBootVolumeBackupResponse> transformer = CreateBootVolumeBackupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateBootVolumeBackupDetails(), retriedRequest);
                return (CreateBootVolumeBackupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateVolumeResponse createVolume(CreateVolumeRequest request) {
        LOG.trace("Called createVolume");
        CreateVolumeRequest interceptedRequest = CreateVolumeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateVolumeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateVolumeResponse> transformer = CreateVolumeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateVolumeDetails(), retriedRequest);
                return (CreateVolumeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateVolumeBackupResponse createVolumeBackup(CreateVolumeBackupRequest request) {
        LOG.trace("Called createVolumeBackup");
        CreateVolumeBackupRequest interceptedRequest = CreateVolumeBackupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateVolumeBackupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateVolumeBackupResponse> transformer = CreateVolumeBackupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateVolumeBackupDetails(), retriedRequest);
                return (CreateVolumeBackupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateVolumeBackupPolicyResponse createVolumeBackupPolicy(CreateVolumeBackupPolicyRequest request) {
        LOG.trace("Called createVolumeBackupPolicy");
        CreateVolumeBackupPolicyRequest interceptedRequest = CreateVolumeBackupPolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateVolumeBackupPolicyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateVolumeBackupPolicyResponse> transformer = CreateVolumeBackupPolicyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateVolumeBackupPolicyDetails(), retriedRequest);
                return (CreateVolumeBackupPolicyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateVolumeBackupPolicyAssignmentResponse createVolumeBackupPolicyAssignment(CreateVolumeBackupPolicyAssignmentRequest request) {
        LOG.trace("Called createVolumeBackupPolicyAssignment");
        CreateVolumeBackupPolicyAssignmentRequest interceptedRequest = CreateVolumeBackupPolicyAssignmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateVolumeBackupPolicyAssignmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateVolumeBackupPolicyAssignmentResponse> transformer = CreateVolumeBackupPolicyAssignmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateVolumeBackupPolicyAssignmentDetails(), retriedRequest);
                return (CreateVolumeBackupPolicyAssignmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateVolumeGroupResponse createVolumeGroup(CreateVolumeGroupRequest request) {
        LOG.trace("Called createVolumeGroup");
        CreateVolumeGroupRequest interceptedRequest = CreateVolumeGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateVolumeGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateVolumeGroupResponse> transformer = CreateVolumeGroupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateVolumeGroupDetails(), retriedRequest);
                return (CreateVolumeGroupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateVolumeGroupBackupResponse createVolumeGroupBackup(CreateVolumeGroupBackupRequest request) {
        LOG.trace("Called createVolumeGroupBackup");
        CreateVolumeGroupBackupRequest interceptedRequest = CreateVolumeGroupBackupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateVolumeGroupBackupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateVolumeGroupBackupResponse> transformer = CreateVolumeGroupBackupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateVolumeGroupBackupDetails(), retriedRequest);
                return (CreateVolumeGroupBackupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteBootVolumeResponse deleteBootVolume(DeleteBootVolumeRequest request) {
        LOG.trace("Called deleteBootVolume");
        DeleteBootVolumeRequest interceptedRequest = DeleteBootVolumeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteBootVolumeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteBootVolumeResponse> transformer = DeleteBootVolumeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteBootVolumeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteBootVolumeBackupResponse deleteBootVolumeBackup(DeleteBootVolumeBackupRequest request) {
        LOG.trace("Called deleteBootVolumeBackup");
        DeleteBootVolumeBackupRequest interceptedRequest = DeleteBootVolumeBackupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteBootVolumeBackupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteBootVolumeBackupResponse> transformer = DeleteBootVolumeBackupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteBootVolumeBackupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteBootVolumeKmsKeyResponse deleteBootVolumeKmsKey(DeleteBootVolumeKmsKeyRequest request) {
        LOG.trace("Called deleteBootVolumeKmsKey");
        DeleteBootVolumeKmsKeyRequest interceptedRequest = DeleteBootVolumeKmsKeyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteBootVolumeKmsKeyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteBootVolumeKmsKeyResponse> transformer = DeleteBootVolumeKmsKeyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteBootVolumeKmsKeyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteVolumeResponse deleteVolume(DeleteVolumeRequest request) {
        LOG.trace("Called deleteVolume");
        DeleteVolumeRequest interceptedRequest = DeleteVolumeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteVolumeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteVolumeResponse> transformer = DeleteVolumeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteVolumeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteVolumeBackupResponse deleteVolumeBackup(DeleteVolumeBackupRequest request) {
        LOG.trace("Called deleteVolumeBackup");
        DeleteVolumeBackupRequest interceptedRequest = DeleteVolumeBackupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteVolumeBackupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteVolumeBackupResponse> transformer = DeleteVolumeBackupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteVolumeBackupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteVolumeBackupPolicyResponse deleteVolumeBackupPolicy(DeleteVolumeBackupPolicyRequest request) {
        LOG.trace("Called deleteVolumeBackupPolicy");
        DeleteVolumeBackupPolicyRequest interceptedRequest = DeleteVolumeBackupPolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteVolumeBackupPolicyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteVolumeBackupPolicyResponse> transformer = DeleteVolumeBackupPolicyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteVolumeBackupPolicyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteVolumeBackupPolicyAssignmentResponse deleteVolumeBackupPolicyAssignment(DeleteVolumeBackupPolicyAssignmentRequest request) {
        LOG.trace("Called deleteVolumeBackupPolicyAssignment");
        DeleteVolumeBackupPolicyAssignmentRequest interceptedRequest = DeleteVolumeBackupPolicyAssignmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteVolumeBackupPolicyAssignmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteVolumeBackupPolicyAssignmentResponse> transformer = DeleteVolumeBackupPolicyAssignmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteVolumeBackupPolicyAssignmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteVolumeGroupResponse deleteVolumeGroup(DeleteVolumeGroupRequest request) {
        LOG.trace("Called deleteVolumeGroup");
        DeleteVolumeGroupRequest interceptedRequest = DeleteVolumeGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteVolumeGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteVolumeGroupResponse> transformer = DeleteVolumeGroupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteVolumeGroupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteVolumeGroupBackupResponse deleteVolumeGroupBackup(DeleteVolumeGroupBackupRequest request) {
        LOG.trace("Called deleteVolumeGroupBackup");
        DeleteVolumeGroupBackupRequest interceptedRequest = DeleteVolumeGroupBackupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteVolumeGroupBackupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteVolumeGroupBackupResponse> transformer = DeleteVolumeGroupBackupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteVolumeGroupBackupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteVolumeKmsKeyResponse deleteVolumeKmsKey(DeleteVolumeKmsKeyRequest request) {
        LOG.trace("Called deleteVolumeKmsKey");
        DeleteVolumeKmsKeyRequest interceptedRequest = DeleteVolumeKmsKeyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteVolumeKmsKeyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteVolumeKmsKeyResponse> transformer = DeleteVolumeKmsKeyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteVolumeKmsKeyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetBootVolumeResponse getBootVolume(GetBootVolumeRequest request) {
        LOG.trace("Called getBootVolume");
        GetBootVolumeRequest interceptedRequest = GetBootVolumeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetBootVolumeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetBootVolumeResponse> transformer = GetBootVolumeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetBootVolumeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetBootVolumeBackupResponse getBootVolumeBackup(GetBootVolumeBackupRequest request) {
        LOG.trace("Called getBootVolumeBackup");
        GetBootVolumeBackupRequest interceptedRequest = GetBootVolumeBackupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetBootVolumeBackupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetBootVolumeBackupResponse> transformer = GetBootVolumeBackupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetBootVolumeBackupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetBootVolumeKmsKeyResponse getBootVolumeKmsKey(GetBootVolumeKmsKeyRequest request) {
        LOG.trace("Called getBootVolumeKmsKey");
        GetBootVolumeKmsKeyRequest interceptedRequest = GetBootVolumeKmsKeyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetBootVolumeKmsKeyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetBootVolumeKmsKeyResponse> transformer = GetBootVolumeKmsKeyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetBootVolumeKmsKeyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetVolumeResponse getVolume(GetVolumeRequest request) {
        LOG.trace("Called getVolume");
        GetVolumeRequest interceptedRequest = GetVolumeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetVolumeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetVolumeResponse> transformer = GetVolumeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetVolumeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetVolumeBackupResponse getVolumeBackup(GetVolumeBackupRequest request) {
        LOG.trace("Called getVolumeBackup");
        GetVolumeBackupRequest interceptedRequest = GetVolumeBackupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetVolumeBackupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetVolumeBackupResponse> transformer = GetVolumeBackupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetVolumeBackupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetVolumeBackupPolicyResponse getVolumeBackupPolicy(GetVolumeBackupPolicyRequest request) {
        LOG.trace("Called getVolumeBackupPolicy");
        GetVolumeBackupPolicyRequest interceptedRequest = GetVolumeBackupPolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetVolumeBackupPolicyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetVolumeBackupPolicyResponse> transformer = GetVolumeBackupPolicyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetVolumeBackupPolicyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetVolumeBackupPolicyAssetAssignmentResponse getVolumeBackupPolicyAssetAssignment(GetVolumeBackupPolicyAssetAssignmentRequest request) {
        LOG.trace("Called getVolumeBackupPolicyAssetAssignment");
        GetVolumeBackupPolicyAssetAssignmentRequest interceptedRequest = GetVolumeBackupPolicyAssetAssignmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetVolumeBackupPolicyAssetAssignmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetVolumeBackupPolicyAssetAssignmentResponse> transformer = GetVolumeBackupPolicyAssetAssignmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetVolumeBackupPolicyAssetAssignmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetVolumeBackupPolicyAssignmentResponse getVolumeBackupPolicyAssignment(GetVolumeBackupPolicyAssignmentRequest request) {
        LOG.trace("Called getVolumeBackupPolicyAssignment");
        GetVolumeBackupPolicyAssignmentRequest interceptedRequest = GetVolumeBackupPolicyAssignmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetVolumeBackupPolicyAssignmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetVolumeBackupPolicyAssignmentResponse> transformer = GetVolumeBackupPolicyAssignmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetVolumeBackupPolicyAssignmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetVolumeGroupResponse getVolumeGroup(GetVolumeGroupRequest request) {
        LOG.trace("Called getVolumeGroup");
        GetVolumeGroupRequest interceptedRequest = GetVolumeGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetVolumeGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetVolumeGroupResponse> transformer = GetVolumeGroupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetVolumeGroupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetVolumeGroupBackupResponse getVolumeGroupBackup(GetVolumeGroupBackupRequest request) {
        LOG.trace("Called getVolumeGroupBackup");
        GetVolumeGroupBackupRequest interceptedRequest = GetVolumeGroupBackupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetVolumeGroupBackupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetVolumeGroupBackupResponse> transformer = GetVolumeGroupBackupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetVolumeGroupBackupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetVolumeKmsKeyResponse getVolumeKmsKey(GetVolumeKmsKeyRequest request) {
        LOG.trace("Called getVolumeKmsKey");
        GetVolumeKmsKeyRequest interceptedRequest = GetVolumeKmsKeyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetVolumeKmsKeyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetVolumeKmsKeyResponse> transformer = GetVolumeKmsKeyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetVolumeKmsKeyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListBootVolumeBackupsResponse listBootVolumeBackups(ListBootVolumeBackupsRequest request) {
        LOG.trace("Called listBootVolumeBackups");
        ListBootVolumeBackupsRequest interceptedRequest = ListBootVolumeBackupsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListBootVolumeBackupsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListBootVolumeBackupsResponse> transformer = ListBootVolumeBackupsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListBootVolumeBackupsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListBootVolumesResponse listBootVolumes(ListBootVolumesRequest request) {
        LOG.trace("Called listBootVolumes");
        ListBootVolumesRequest interceptedRequest = ListBootVolumesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListBootVolumesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListBootVolumesResponse> transformer = ListBootVolumesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListBootVolumesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListVolumeBackupPoliciesResponse listVolumeBackupPolicies(ListVolumeBackupPoliciesRequest request) {
        LOG.trace("Called listVolumeBackupPolicies");
        ListVolumeBackupPoliciesRequest interceptedRequest = ListVolumeBackupPoliciesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListVolumeBackupPoliciesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListVolumeBackupPoliciesResponse> transformer = ListVolumeBackupPoliciesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListVolumeBackupPoliciesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListVolumeBackupsResponse listVolumeBackups(ListVolumeBackupsRequest request) {
        LOG.trace("Called listVolumeBackups");
        ListVolumeBackupsRequest interceptedRequest = ListVolumeBackupsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListVolumeBackupsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListVolumeBackupsResponse> transformer = ListVolumeBackupsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListVolumeBackupsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListVolumeGroupBackupsResponse listVolumeGroupBackups(ListVolumeGroupBackupsRequest request) {
        LOG.trace("Called listVolumeGroupBackups");
        ListVolumeGroupBackupsRequest interceptedRequest = ListVolumeGroupBackupsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListVolumeGroupBackupsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListVolumeGroupBackupsResponse> transformer = ListVolumeGroupBackupsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListVolumeGroupBackupsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListVolumeGroupsResponse listVolumeGroups(ListVolumeGroupsRequest request) {
        LOG.trace("Called listVolumeGroups");
        ListVolumeGroupsRequest interceptedRequest = ListVolumeGroupsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListVolumeGroupsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListVolumeGroupsResponse> transformer = ListVolumeGroupsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListVolumeGroupsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListVolumesResponse listVolumes(ListVolumesRequest request) {
        LOG.trace("Called listVolumes");
        ListVolumesRequest interceptedRequest = ListVolumesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListVolumesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListVolumesResponse> transformer = ListVolumesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListVolumesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateBootVolumeResponse updateBootVolume(UpdateBootVolumeRequest request) {
        LOG.trace("Called updateBootVolume");
        UpdateBootVolumeRequest interceptedRequest = UpdateBootVolumeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateBootVolumeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateBootVolumeResponse> transformer = UpdateBootVolumeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateBootVolumeDetails(), retriedRequest);
                return (UpdateBootVolumeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateBootVolumeBackupResponse updateBootVolumeBackup(UpdateBootVolumeBackupRequest request) {
        LOG.trace("Called updateBootVolumeBackup");
        UpdateBootVolumeBackupRequest interceptedRequest = UpdateBootVolumeBackupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateBootVolumeBackupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateBootVolumeBackupResponse> transformer = UpdateBootVolumeBackupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateBootVolumeBackupDetails(), retriedRequest);
                return (UpdateBootVolumeBackupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateBootVolumeKmsKeyResponse updateBootVolumeKmsKey(UpdateBootVolumeKmsKeyRequest request) {
        LOG.trace("Called updateBootVolumeKmsKey");
        UpdateBootVolumeKmsKeyRequest interceptedRequest = UpdateBootVolumeKmsKeyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateBootVolumeKmsKeyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateBootVolumeKmsKeyResponse> transformer = UpdateBootVolumeKmsKeyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateBootVolumeKmsKeyDetails(), retriedRequest);
                return (UpdateBootVolumeKmsKeyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateVolumeResponse updateVolume(UpdateVolumeRequest request) {
        LOG.trace("Called updateVolume");
        UpdateVolumeRequest interceptedRequest = UpdateVolumeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateVolumeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateVolumeResponse> transformer = UpdateVolumeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateVolumeDetails(), retriedRequest);
                return (UpdateVolumeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateVolumeBackupResponse updateVolumeBackup(UpdateVolumeBackupRequest request) {
        LOG.trace("Called updateVolumeBackup");
        UpdateVolumeBackupRequest interceptedRequest = UpdateVolumeBackupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateVolumeBackupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateVolumeBackupResponse> transformer = UpdateVolumeBackupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateVolumeBackupDetails(), retriedRequest);
                return (UpdateVolumeBackupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateVolumeBackupPolicyResponse updateVolumeBackupPolicy(UpdateVolumeBackupPolicyRequest request) {
        LOG.trace("Called updateVolumeBackupPolicy");
        UpdateVolumeBackupPolicyRequest interceptedRequest = UpdateVolumeBackupPolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateVolumeBackupPolicyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateVolumeBackupPolicyResponse> transformer = UpdateVolumeBackupPolicyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateVolumeBackupPolicyDetails(), retriedRequest);
                return (UpdateVolumeBackupPolicyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateVolumeGroupResponse updateVolumeGroup(UpdateVolumeGroupRequest request) {
        LOG.trace("Called updateVolumeGroup");
        UpdateVolumeGroupRequest interceptedRequest = UpdateVolumeGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateVolumeGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateVolumeGroupResponse> transformer = UpdateVolumeGroupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateVolumeGroupDetails(), retriedRequest);
                return (UpdateVolumeGroupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateVolumeGroupBackupResponse updateVolumeGroupBackup(UpdateVolumeGroupBackupRequest request) {
        LOG.trace("Called updateVolumeGroupBackup");
        UpdateVolumeGroupBackupRequest interceptedRequest = UpdateVolumeGroupBackupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateVolumeGroupBackupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateVolumeGroupBackupResponse> transformer = UpdateVolumeGroupBackupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateVolumeGroupBackupDetails(), retriedRequest);
                return (UpdateVolumeGroupBackupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateVolumeKmsKeyResponse updateVolumeKmsKey(UpdateVolumeKmsKeyRequest request) {
        LOG.trace("Called updateVolumeKmsKey");
        UpdateVolumeKmsKeyRequest interceptedRequest = UpdateVolumeKmsKeyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateVolumeKmsKeyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateVolumeKmsKeyResponse> transformer = UpdateVolumeKmsKeyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateVolumeKmsKeyDetails(), retriedRequest);
                return (UpdateVolumeKmsKeyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public BlockstorageWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public BlockstorageWaiters newWaiters(WorkRequest workRequestClient) {
        return new BlockstorageWaiters(this.executorService, this, workRequestClient);
    }

    @Override
    public BlockstoragePaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, BlockstorageClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public BlockstorageClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new BlockstorageClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

