/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.oracle.bmc.core.Blockstorage;
import com.oracle.bmc.core.model.BootVolume;
import com.oracle.bmc.core.model.BootVolumeBackup;
import com.oracle.bmc.core.model.Volume;
import com.oracle.bmc.core.model.VolumeBackup;
import com.oracle.bmc.core.model.VolumeGroup;
import com.oracle.bmc.core.model.VolumeGroupBackup;
import com.oracle.bmc.core.requests.GetBootVolumeBackupRequest;
import com.oracle.bmc.core.requests.GetBootVolumeRequest;
import com.oracle.bmc.core.requests.GetVolumeBackupRequest;
import com.oracle.bmc.core.requests.GetVolumeGroupBackupRequest;
import com.oracle.bmc.core.requests.GetVolumeGroupRequest;
import com.oracle.bmc.core.requests.GetVolumeRequest;
import com.oracle.bmc.core.responses.GetBootVolumeBackupResponse;
import com.oracle.bmc.core.responses.GetBootVolumeResponse;
import com.oracle.bmc.core.responses.GetVolumeBackupResponse;
import com.oracle.bmc.core.responses.GetVolumeGroupBackupResponse;
import com.oracle.bmc.core.responses.GetVolumeGroupResponse;
import com.oracle.bmc.core.responses.GetVolumeResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import com.oracle.bmc.workrequests.WorkRequest;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import lombok.NonNull;
import org.apache.commons.lang3.Validate;

public class BlockstorageWaiters {
    @NonNull
    private final ExecutorService executorService;
    @NonNull
    private final Blockstorage client;
    private final WorkRequest workRequestClient;

    @Deprecated
    public BlockstorageWaiters(@NonNull ExecutorService executorService, @NonNull Blockstorage client) {
        this(executorService, client, null);
        if (executorService == null) {
            throw new NullPointerException("executorService is marked @NonNull but is null");
        }
        if (client == null) {
            throw new NullPointerException("client is marked @NonNull but is null");
        }
    }

    public BlockstorageWaiters(@NonNull ExecutorService executorService, @NonNull Blockstorage client, WorkRequest workRequestClient) {
        if (executorService == null) {
            throw new NullPointerException("executorService is marked @NonNull but is null");
        }
        if (client == null) {
            throw new NullPointerException("client is marked @NonNull but is null");
        }
        this.executorService = executorService;
        this.client = client;
        this.workRequestClient = workRequestClient;
    }

    public Waiter<GetBootVolumeRequest, GetBootVolumeResponse> forBootVolume(GetBootVolumeRequest request, BootVolume.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forBootVolume(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetBootVolumeRequest, GetBootVolumeResponse> forBootVolume(GetBootVolumeRequest request, BootVolume.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forBootVolume(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetBootVolumeRequest, GetBootVolumeResponse> forBootVolume(GetBootVolumeRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, BootVolume.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forBootVolume(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetBootVolumeRequest, GetBootVolumeResponse> forBootVolume(BmcGenericWaiter waiter, GetBootVolumeRequest request, BootVolume.LifecycleState ... targetStates) {
        final HashSet<BootVolume.LifecycleState> targetStatesSet = new HashSet<BootVolume.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetBootVolumeRequest, GetBootVolumeResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetBootVolumeRequest, GetBootVolumeResponse>(){

            public GetBootVolumeResponse apply(GetBootVolumeRequest request) {
                return BlockstorageWaiters.this.client.getBootVolume(request);
            }
        }, new Predicate<GetBootVolumeResponse>(){

            public boolean apply(GetBootVolumeResponse response) {
                return targetStatesSet.contains((Object)response.getBootVolume().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)BootVolume.LifecycleState.Terminated)), request);
    }

    public Waiter<GetBootVolumeBackupRequest, GetBootVolumeBackupResponse> forBootVolumeBackup(GetBootVolumeBackupRequest request, BootVolumeBackup.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forBootVolumeBackup(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetBootVolumeBackupRequest, GetBootVolumeBackupResponse> forBootVolumeBackup(GetBootVolumeBackupRequest request, BootVolumeBackup.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forBootVolumeBackup(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetBootVolumeBackupRequest, GetBootVolumeBackupResponse> forBootVolumeBackup(GetBootVolumeBackupRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, BootVolumeBackup.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forBootVolumeBackup(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetBootVolumeBackupRequest, GetBootVolumeBackupResponse> forBootVolumeBackup(BmcGenericWaiter waiter, GetBootVolumeBackupRequest request, BootVolumeBackup.LifecycleState ... targetStates) {
        final HashSet<BootVolumeBackup.LifecycleState> targetStatesSet = new HashSet<BootVolumeBackup.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetBootVolumeBackupRequest, GetBootVolumeBackupResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetBootVolumeBackupRequest, GetBootVolumeBackupResponse>(){

            public GetBootVolumeBackupResponse apply(GetBootVolumeBackupRequest request) {
                return BlockstorageWaiters.this.client.getBootVolumeBackup(request);
            }
        }, new Predicate<GetBootVolumeBackupResponse>(){

            public boolean apply(GetBootVolumeBackupResponse response) {
                return targetStatesSet.contains((Object)response.getBootVolumeBackup().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)BootVolumeBackup.LifecycleState.Terminated)), request);
    }

    public Waiter<GetVolumeRequest, GetVolumeResponse> forVolume(GetVolumeRequest request, Volume.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forVolume(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetVolumeRequest, GetVolumeResponse> forVolume(GetVolumeRequest request, Volume.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forVolume(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetVolumeRequest, GetVolumeResponse> forVolume(GetVolumeRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Volume.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forVolume(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetVolumeRequest, GetVolumeResponse> forVolume(BmcGenericWaiter waiter, GetVolumeRequest request, Volume.LifecycleState ... targetStates) {
        final HashSet<Volume.LifecycleState> targetStatesSet = new HashSet<Volume.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetVolumeRequest, GetVolumeResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetVolumeRequest, GetVolumeResponse>(){

            public GetVolumeResponse apply(GetVolumeRequest request) {
                return BlockstorageWaiters.this.client.getVolume(request);
            }
        }, new Predicate<GetVolumeResponse>(){

            public boolean apply(GetVolumeResponse response) {
                return targetStatesSet.contains((Object)response.getVolume().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Volume.LifecycleState.Terminated)), request);
    }

    public Waiter<GetVolumeBackupRequest, GetVolumeBackupResponse> forVolumeBackup(GetVolumeBackupRequest request, VolumeBackup.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forVolumeBackup(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetVolumeBackupRequest, GetVolumeBackupResponse> forVolumeBackup(GetVolumeBackupRequest request, VolumeBackup.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forVolumeBackup(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetVolumeBackupRequest, GetVolumeBackupResponse> forVolumeBackup(GetVolumeBackupRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, VolumeBackup.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forVolumeBackup(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetVolumeBackupRequest, GetVolumeBackupResponse> forVolumeBackup(BmcGenericWaiter waiter, GetVolumeBackupRequest request, VolumeBackup.LifecycleState ... targetStates) {
        final HashSet<VolumeBackup.LifecycleState> targetStatesSet = new HashSet<VolumeBackup.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetVolumeBackupRequest, GetVolumeBackupResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetVolumeBackupRequest, GetVolumeBackupResponse>(){

            public GetVolumeBackupResponse apply(GetVolumeBackupRequest request) {
                return BlockstorageWaiters.this.client.getVolumeBackup(request);
            }
        }, new Predicate<GetVolumeBackupResponse>(){

            public boolean apply(GetVolumeBackupResponse response) {
                return targetStatesSet.contains((Object)response.getVolumeBackup().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)VolumeBackup.LifecycleState.Terminated)), request);
    }

    public Waiter<GetVolumeGroupRequest, GetVolumeGroupResponse> forVolumeGroup(GetVolumeGroupRequest request, VolumeGroup.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forVolumeGroup(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetVolumeGroupRequest, GetVolumeGroupResponse> forVolumeGroup(GetVolumeGroupRequest request, VolumeGroup.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forVolumeGroup(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetVolumeGroupRequest, GetVolumeGroupResponse> forVolumeGroup(GetVolumeGroupRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, VolumeGroup.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forVolumeGroup(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetVolumeGroupRequest, GetVolumeGroupResponse> forVolumeGroup(BmcGenericWaiter waiter, GetVolumeGroupRequest request, VolumeGroup.LifecycleState ... targetStates) {
        final HashSet<VolumeGroup.LifecycleState> targetStatesSet = new HashSet<VolumeGroup.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetVolumeGroupRequest, GetVolumeGroupResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetVolumeGroupRequest, GetVolumeGroupResponse>(){

            public GetVolumeGroupResponse apply(GetVolumeGroupRequest request) {
                return BlockstorageWaiters.this.client.getVolumeGroup(request);
            }
        }, new Predicate<GetVolumeGroupResponse>(){

            public boolean apply(GetVolumeGroupResponse response) {
                return targetStatesSet.contains((Object)response.getVolumeGroup().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)VolumeGroup.LifecycleState.Terminated)), request);
    }

    public Waiter<GetVolumeGroupBackupRequest, GetVolumeGroupBackupResponse> forVolumeGroupBackup(GetVolumeGroupBackupRequest request, VolumeGroupBackup.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forVolumeGroupBackup(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetVolumeGroupBackupRequest, GetVolumeGroupBackupResponse> forVolumeGroupBackup(GetVolumeGroupBackupRequest request, VolumeGroupBackup.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forVolumeGroupBackup(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetVolumeGroupBackupRequest, GetVolumeGroupBackupResponse> forVolumeGroupBackup(GetVolumeGroupBackupRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, VolumeGroupBackup.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forVolumeGroupBackup(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetVolumeGroupBackupRequest, GetVolumeGroupBackupResponse> forVolumeGroupBackup(BmcGenericWaiter waiter, GetVolumeGroupBackupRequest request, VolumeGroupBackup.LifecycleState ... targetStates) {
        final HashSet<VolumeGroupBackup.LifecycleState> targetStatesSet = new HashSet<VolumeGroupBackup.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetVolumeGroupBackupRequest, GetVolumeGroupBackupResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetVolumeGroupBackupRequest, GetVolumeGroupBackupResponse>(){

            public GetVolumeGroupBackupResponse apply(GetVolumeGroupBackupRequest request) {
                return BlockstorageWaiters.this.client.getVolumeGroupBackup(request);
            }
        }, new Predicate<GetVolumeGroupBackupResponse>(){

            public boolean apply(GetVolumeGroupBackupResponse response) {
                return targetStatesSet.contains((Object)response.getVolumeGroupBackup().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)VolumeGroupBackup.LifecycleState.Terminated)), request);
    }
}

