/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.core.ComputeAsync;
import com.oracle.bmc.core.internal.http.AttachBootVolumeConverter;
import com.oracle.bmc.core.internal.http.AttachVnicConverter;
import com.oracle.bmc.core.internal.http.AttachVolumeConverter;
import com.oracle.bmc.core.internal.http.CaptureConsoleHistoryConverter;
import com.oracle.bmc.core.internal.http.ChangeDedicatedVmHostCompartmentConverter;
import com.oracle.bmc.core.internal.http.ChangeImageCompartmentConverter;
import com.oracle.bmc.core.internal.http.ChangeInstanceCompartmentConverter;
import com.oracle.bmc.core.internal.http.CreateAppCatalogSubscriptionConverter;
import com.oracle.bmc.core.internal.http.CreateDedicatedVmHostConverter;
import com.oracle.bmc.core.internal.http.CreateImageConverter;
import com.oracle.bmc.core.internal.http.CreateInstanceConsoleConnectionConverter;
import com.oracle.bmc.core.internal.http.DeleteAppCatalogSubscriptionConverter;
import com.oracle.bmc.core.internal.http.DeleteConsoleHistoryConverter;
import com.oracle.bmc.core.internal.http.DeleteDedicatedVmHostConverter;
import com.oracle.bmc.core.internal.http.DeleteImageConverter;
import com.oracle.bmc.core.internal.http.DeleteInstanceConsoleConnectionConverter;
import com.oracle.bmc.core.internal.http.DetachBootVolumeConverter;
import com.oracle.bmc.core.internal.http.DetachVnicConverter;
import com.oracle.bmc.core.internal.http.DetachVolumeConverter;
import com.oracle.bmc.core.internal.http.ExportImageConverter;
import com.oracle.bmc.core.internal.http.GetAppCatalogListingAgreementsConverter;
import com.oracle.bmc.core.internal.http.GetAppCatalogListingConverter;
import com.oracle.bmc.core.internal.http.GetAppCatalogListingResourceVersionConverter;
import com.oracle.bmc.core.internal.http.GetBootVolumeAttachmentConverter;
import com.oracle.bmc.core.internal.http.GetConsoleHistoryContentConverter;
import com.oracle.bmc.core.internal.http.GetConsoleHistoryConverter;
import com.oracle.bmc.core.internal.http.GetDedicatedVmHostConverter;
import com.oracle.bmc.core.internal.http.GetImageConverter;
import com.oracle.bmc.core.internal.http.GetInstanceConsoleConnectionConverter;
import com.oracle.bmc.core.internal.http.GetInstanceConverter;
import com.oracle.bmc.core.internal.http.GetVnicAttachmentConverter;
import com.oracle.bmc.core.internal.http.GetVolumeAttachmentConverter;
import com.oracle.bmc.core.internal.http.GetWindowsInstanceInitialCredentialsConverter;
import com.oracle.bmc.core.internal.http.InstanceActionConverter;
import com.oracle.bmc.core.internal.http.LaunchInstanceConverter;
import com.oracle.bmc.core.internal.http.ListAppCatalogListingResourceVersionsConverter;
import com.oracle.bmc.core.internal.http.ListAppCatalogListingsConverter;
import com.oracle.bmc.core.internal.http.ListAppCatalogSubscriptionsConverter;
import com.oracle.bmc.core.internal.http.ListBootVolumeAttachmentsConverter;
import com.oracle.bmc.core.internal.http.ListConsoleHistoriesConverter;
import com.oracle.bmc.core.internal.http.ListDedicatedVmHostInstanceShapesConverter;
import com.oracle.bmc.core.internal.http.ListDedicatedVmHostInstancesConverter;
import com.oracle.bmc.core.internal.http.ListDedicatedVmHostShapesConverter;
import com.oracle.bmc.core.internal.http.ListDedicatedVmHostsConverter;
import com.oracle.bmc.core.internal.http.ListImagesConverter;
import com.oracle.bmc.core.internal.http.ListInstanceConsoleConnectionsConverter;
import com.oracle.bmc.core.internal.http.ListInstanceDevicesConverter;
import com.oracle.bmc.core.internal.http.ListInstancesConverter;
import com.oracle.bmc.core.internal.http.ListShapesConverter;
import com.oracle.bmc.core.internal.http.ListVnicAttachmentsConverter;
import com.oracle.bmc.core.internal.http.ListVolumeAttachmentsConverter;
import com.oracle.bmc.core.internal.http.TerminateInstanceConverter;
import com.oracle.bmc.core.internal.http.UpdateConsoleHistoryConverter;
import com.oracle.bmc.core.internal.http.UpdateDedicatedVmHostConverter;
import com.oracle.bmc.core.internal.http.UpdateImageConverter;
import com.oracle.bmc.core.internal.http.UpdateInstanceConverter;
import com.oracle.bmc.core.requests.AttachBootVolumeRequest;
import com.oracle.bmc.core.requests.AttachVnicRequest;
import com.oracle.bmc.core.requests.AttachVolumeRequest;
import com.oracle.bmc.core.requests.CaptureConsoleHistoryRequest;
import com.oracle.bmc.core.requests.ChangeDedicatedVmHostCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeImageCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeInstanceCompartmentRequest;
import com.oracle.bmc.core.requests.CreateAppCatalogSubscriptionRequest;
import com.oracle.bmc.core.requests.CreateDedicatedVmHostRequest;
import com.oracle.bmc.core.requests.CreateImageRequest;
import com.oracle.bmc.core.requests.CreateInstanceConsoleConnectionRequest;
import com.oracle.bmc.core.requests.DeleteAppCatalogSubscriptionRequest;
import com.oracle.bmc.core.requests.DeleteConsoleHistoryRequest;
import com.oracle.bmc.core.requests.DeleteDedicatedVmHostRequest;
import com.oracle.bmc.core.requests.DeleteImageRequest;
import com.oracle.bmc.core.requests.DeleteInstanceConsoleConnectionRequest;
import com.oracle.bmc.core.requests.DetachBootVolumeRequest;
import com.oracle.bmc.core.requests.DetachVnicRequest;
import com.oracle.bmc.core.requests.DetachVolumeRequest;
import com.oracle.bmc.core.requests.ExportImageRequest;
import com.oracle.bmc.core.requests.GetAppCatalogListingAgreementsRequest;
import com.oracle.bmc.core.requests.GetAppCatalogListingRequest;
import com.oracle.bmc.core.requests.GetAppCatalogListingResourceVersionRequest;
import com.oracle.bmc.core.requests.GetBootVolumeAttachmentRequest;
import com.oracle.bmc.core.requests.GetConsoleHistoryContentRequest;
import com.oracle.bmc.core.requests.GetConsoleHistoryRequest;
import com.oracle.bmc.core.requests.GetDedicatedVmHostRequest;
import com.oracle.bmc.core.requests.GetImageRequest;
import com.oracle.bmc.core.requests.GetInstanceConsoleConnectionRequest;
import com.oracle.bmc.core.requests.GetInstanceRequest;
import com.oracle.bmc.core.requests.GetVnicAttachmentRequest;
import com.oracle.bmc.core.requests.GetVolumeAttachmentRequest;
import com.oracle.bmc.core.requests.GetWindowsInstanceInitialCredentialsRequest;
import com.oracle.bmc.core.requests.InstanceActionRequest;
import com.oracle.bmc.core.requests.LaunchInstanceRequest;
import com.oracle.bmc.core.requests.ListAppCatalogListingResourceVersionsRequest;
import com.oracle.bmc.core.requests.ListAppCatalogListingsRequest;
import com.oracle.bmc.core.requests.ListAppCatalogSubscriptionsRequest;
import com.oracle.bmc.core.requests.ListBootVolumeAttachmentsRequest;
import com.oracle.bmc.core.requests.ListConsoleHistoriesRequest;
import com.oracle.bmc.core.requests.ListDedicatedVmHostInstanceShapesRequest;
import com.oracle.bmc.core.requests.ListDedicatedVmHostInstancesRequest;
import com.oracle.bmc.core.requests.ListDedicatedVmHostShapesRequest;
import com.oracle.bmc.core.requests.ListDedicatedVmHostsRequest;
import com.oracle.bmc.core.requests.ListImagesRequest;
import com.oracle.bmc.core.requests.ListInstanceConsoleConnectionsRequest;
import com.oracle.bmc.core.requests.ListInstanceDevicesRequest;
import com.oracle.bmc.core.requests.ListInstancesRequest;
import com.oracle.bmc.core.requests.ListShapesRequest;
import com.oracle.bmc.core.requests.ListVnicAttachmentsRequest;
import com.oracle.bmc.core.requests.ListVolumeAttachmentsRequest;
import com.oracle.bmc.core.requests.TerminateInstanceRequest;
import com.oracle.bmc.core.requests.UpdateConsoleHistoryRequest;
import com.oracle.bmc.core.requests.UpdateDedicatedVmHostRequest;
import com.oracle.bmc.core.requests.UpdateImageRequest;
import com.oracle.bmc.core.requests.UpdateInstanceRequest;
import com.oracle.bmc.core.responses.AttachBootVolumeResponse;
import com.oracle.bmc.core.responses.AttachVnicResponse;
import com.oracle.bmc.core.responses.AttachVolumeResponse;
import com.oracle.bmc.core.responses.CaptureConsoleHistoryResponse;
import com.oracle.bmc.core.responses.ChangeDedicatedVmHostCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeImageCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeInstanceCompartmentResponse;
import com.oracle.bmc.core.responses.CreateAppCatalogSubscriptionResponse;
import com.oracle.bmc.core.responses.CreateDedicatedVmHostResponse;
import com.oracle.bmc.core.responses.CreateImageResponse;
import com.oracle.bmc.core.responses.CreateInstanceConsoleConnectionResponse;
import com.oracle.bmc.core.responses.DeleteAppCatalogSubscriptionResponse;
import com.oracle.bmc.core.responses.DeleteConsoleHistoryResponse;
import com.oracle.bmc.core.responses.DeleteDedicatedVmHostResponse;
import com.oracle.bmc.core.responses.DeleteImageResponse;
import com.oracle.bmc.core.responses.DeleteInstanceConsoleConnectionResponse;
import com.oracle.bmc.core.responses.DetachBootVolumeResponse;
import com.oracle.bmc.core.responses.DetachVnicResponse;
import com.oracle.bmc.core.responses.DetachVolumeResponse;
import com.oracle.bmc.core.responses.ExportImageResponse;
import com.oracle.bmc.core.responses.GetAppCatalogListingAgreementsResponse;
import com.oracle.bmc.core.responses.GetAppCatalogListingResourceVersionResponse;
import com.oracle.bmc.core.responses.GetAppCatalogListingResponse;
import com.oracle.bmc.core.responses.GetBootVolumeAttachmentResponse;
import com.oracle.bmc.core.responses.GetConsoleHistoryContentResponse;
import com.oracle.bmc.core.responses.GetConsoleHistoryResponse;
import com.oracle.bmc.core.responses.GetDedicatedVmHostResponse;
import com.oracle.bmc.core.responses.GetImageResponse;
import com.oracle.bmc.core.responses.GetInstanceConsoleConnectionResponse;
import com.oracle.bmc.core.responses.GetInstanceResponse;
import com.oracle.bmc.core.responses.GetVnicAttachmentResponse;
import com.oracle.bmc.core.responses.GetVolumeAttachmentResponse;
import com.oracle.bmc.core.responses.GetWindowsInstanceInitialCredentialsResponse;
import com.oracle.bmc.core.responses.InstanceActionResponse;
import com.oracle.bmc.core.responses.LaunchInstanceResponse;
import com.oracle.bmc.core.responses.ListAppCatalogListingResourceVersionsResponse;
import com.oracle.bmc.core.responses.ListAppCatalogListingsResponse;
import com.oracle.bmc.core.responses.ListAppCatalogSubscriptionsResponse;
import com.oracle.bmc.core.responses.ListBootVolumeAttachmentsResponse;
import com.oracle.bmc.core.responses.ListConsoleHistoriesResponse;
import com.oracle.bmc.core.responses.ListDedicatedVmHostInstanceShapesResponse;
import com.oracle.bmc.core.responses.ListDedicatedVmHostInstancesResponse;
import com.oracle.bmc.core.responses.ListDedicatedVmHostShapesResponse;
import com.oracle.bmc.core.responses.ListDedicatedVmHostsResponse;
import com.oracle.bmc.core.responses.ListImagesResponse;
import com.oracle.bmc.core.responses.ListInstanceConsoleConnectionsResponse;
import com.oracle.bmc.core.responses.ListInstanceDevicesResponse;
import com.oracle.bmc.core.responses.ListInstancesResponse;
import com.oracle.bmc.core.responses.ListShapesResponse;
import com.oracle.bmc.core.responses.ListVnicAttachmentsResponse;
import com.oracle.bmc.core.responses.ListVolumeAttachmentsResponse;
import com.oracle.bmc.core.responses.TerminateInstanceResponse;
import com.oracle.bmc.core.responses.UpdateConsoleHistoryResponse;
import com.oracle.bmc.core.responses.UpdateDedicatedVmHostResponse;
import com.oracle.bmc.core.responses.UpdateImageResponse;
import com.oracle.bmc.core.responses.UpdateInstanceResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.ErrorConsumer;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.SuccessConsumer;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenTransformingFuture;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrappingAsyncHandler;
import com.oracle.bmc.util.internal.TransformingFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputeAsyncClient
implements ComputeAsync {
    private static final Logger LOG = LoggerFactory.getLogger(ComputeAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("COMPUTE").serviceEndpointPrefix("iaas").serviceEndpointTemplate("https://iaas.{region}.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public ComputeAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public ComputeAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public ComputeAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public ComputeAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public ComputeAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public ComputeAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public ComputeAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)((Object)this.authenticationDetailsProvider)).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional<String> endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(SERVICE, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<AttachBootVolumeResponse> attachBootVolume(AttachBootVolumeRequest request, AsyncHandler<AttachBootVolumeRequest, AttachBootVolumeResponse> handler) {
        LOG.trace("Called async attachBootVolume");
        final AttachBootVolumeRequest interceptedRequest = AttachBootVolumeConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = AttachBootVolumeConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, AttachBootVolumeResponse> transformer = AttachBootVolumeConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<AttachBootVolumeRequest, AttachBootVolumeResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<AttachBootVolumeRequest, AttachBootVolumeResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<AttachBootVolumeRequest, AttachBootVolumeResponse> onSuccess = new SuccessConsumer<AttachBootVolumeRequest, AttachBootVolumeResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<AttachBootVolumeRequest> onError = new ErrorConsumer<AttachBootVolumeRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.post(ib, interceptedRequest.getAttachBootVolumeDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<AttachBootVolumeRequest, AttachBootVolumeResponse> onSuccess = handler == null ? null : new SuccessConsumer<AttachBootVolumeRequest, AttachBootVolumeResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<AttachBootVolumeRequest> onError = handler == null ? null : new ErrorConsumer<AttachBootVolumeRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getAttachBootVolumeDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, AttachBootVolumeResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.post(ib, interceptedRequest.getAttachBootVolumeDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, AttachBootVolumeResponse>(responseFuture, transformer);
    }

    @Override
    public Future<AttachVnicResponse> attachVnic(AttachVnicRequest request, AsyncHandler<AttachVnicRequest, AttachVnicResponse> handler) {
        LOG.trace("Called async attachVnic");
        final AttachVnicRequest interceptedRequest = AttachVnicConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = AttachVnicConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, AttachVnicResponse> transformer = AttachVnicConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<AttachVnicRequest, AttachVnicResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<AttachVnicRequest, AttachVnicResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<AttachVnicRequest, AttachVnicResponse> onSuccess = new SuccessConsumer<AttachVnicRequest, AttachVnicResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<AttachVnicRequest> onError = new ErrorConsumer<AttachVnicRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.post(ib, interceptedRequest.getAttachVnicDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<AttachVnicRequest, AttachVnicResponse> onSuccess = handler == null ? null : new SuccessConsumer<AttachVnicRequest, AttachVnicResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<AttachVnicRequest> onError = handler == null ? null : new ErrorConsumer<AttachVnicRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getAttachVnicDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, AttachVnicResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.post(ib, interceptedRequest.getAttachVnicDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, AttachVnicResponse>(responseFuture, transformer);
    }

    @Override
    public Future<AttachVolumeResponse> attachVolume(AttachVolumeRequest request, AsyncHandler<AttachVolumeRequest, AttachVolumeResponse> handler) {
        LOG.trace("Called async attachVolume");
        final AttachVolumeRequest interceptedRequest = AttachVolumeConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = AttachVolumeConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, AttachVolumeResponse> transformer = AttachVolumeConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<AttachVolumeRequest, AttachVolumeResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<AttachVolumeRequest, AttachVolumeResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<AttachVolumeRequest, AttachVolumeResponse> onSuccess = new SuccessConsumer<AttachVolumeRequest, AttachVolumeResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<AttachVolumeRequest> onError = new ErrorConsumer<AttachVolumeRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.post(ib, interceptedRequest.getAttachVolumeDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<AttachVolumeRequest, AttachVolumeResponse> onSuccess = handler == null ? null : new SuccessConsumer<AttachVolumeRequest, AttachVolumeResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<AttachVolumeRequest> onError = handler == null ? null : new ErrorConsumer<AttachVolumeRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getAttachVolumeDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, AttachVolumeResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.post(ib, interceptedRequest.getAttachVolumeDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, AttachVolumeResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CaptureConsoleHistoryResponse> captureConsoleHistory(CaptureConsoleHistoryRequest request, AsyncHandler<CaptureConsoleHistoryRequest, CaptureConsoleHistoryResponse> handler) {
        LOG.trace("Called async captureConsoleHistory");
        final CaptureConsoleHistoryRequest interceptedRequest = CaptureConsoleHistoryConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CaptureConsoleHistoryConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CaptureConsoleHistoryResponse> transformer = CaptureConsoleHistoryConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CaptureConsoleHistoryRequest, CaptureConsoleHistoryResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CaptureConsoleHistoryRequest, CaptureConsoleHistoryResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CaptureConsoleHistoryRequest, CaptureConsoleHistoryResponse> onSuccess = new SuccessConsumer<CaptureConsoleHistoryRequest, CaptureConsoleHistoryResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CaptureConsoleHistoryRequest> onError = new ErrorConsumer<CaptureConsoleHistoryRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.post(ib, interceptedRequest.getCaptureConsoleHistoryDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CaptureConsoleHistoryRequest, CaptureConsoleHistoryResponse> onSuccess = handler == null ? null : new SuccessConsumer<CaptureConsoleHistoryRequest, CaptureConsoleHistoryResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CaptureConsoleHistoryRequest> onError = handler == null ? null : new ErrorConsumer<CaptureConsoleHistoryRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCaptureConsoleHistoryDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CaptureConsoleHistoryResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.post(ib, interceptedRequest.getCaptureConsoleHistoryDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CaptureConsoleHistoryResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ChangeDedicatedVmHostCompartmentResponse> changeDedicatedVmHostCompartment(ChangeDedicatedVmHostCompartmentRequest request, AsyncHandler<ChangeDedicatedVmHostCompartmentRequest, ChangeDedicatedVmHostCompartmentResponse> handler) {
        LOG.trace("Called async changeDedicatedVmHostCompartment");
        final ChangeDedicatedVmHostCompartmentRequest interceptedRequest = ChangeDedicatedVmHostCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeDedicatedVmHostCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeDedicatedVmHostCompartmentResponse> transformer = ChangeDedicatedVmHostCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeDedicatedVmHostCompartmentRequest, ChangeDedicatedVmHostCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeDedicatedVmHostCompartmentRequest, ChangeDedicatedVmHostCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeDedicatedVmHostCompartmentRequest, ChangeDedicatedVmHostCompartmentResponse> onSuccess = new SuccessConsumer<ChangeDedicatedVmHostCompartmentRequest, ChangeDedicatedVmHostCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeDedicatedVmHostCompartmentRequest> onError = new ErrorConsumer<ChangeDedicatedVmHostCompartmentRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.post(ib, interceptedRequest.getChangeDedicatedVmHostCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeDedicatedVmHostCompartmentRequest, ChangeDedicatedVmHostCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeDedicatedVmHostCompartmentRequest, ChangeDedicatedVmHostCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeDedicatedVmHostCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeDedicatedVmHostCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeDedicatedVmHostCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeDedicatedVmHostCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.post(ib, interceptedRequest.getChangeDedicatedVmHostCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeDedicatedVmHostCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ChangeImageCompartmentResponse> changeImageCompartment(ChangeImageCompartmentRequest request, AsyncHandler<ChangeImageCompartmentRequest, ChangeImageCompartmentResponse> handler) {
        LOG.trace("Called async changeImageCompartment");
        final ChangeImageCompartmentRequest interceptedRequest = ChangeImageCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeImageCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeImageCompartmentResponse> transformer = ChangeImageCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeImageCompartmentRequest, ChangeImageCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeImageCompartmentRequest, ChangeImageCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeImageCompartmentRequest, ChangeImageCompartmentResponse> onSuccess = new SuccessConsumer<ChangeImageCompartmentRequest, ChangeImageCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeImageCompartmentRequest> onError = new ErrorConsumer<ChangeImageCompartmentRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.post(ib, interceptedRequest.getChangeImageCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeImageCompartmentRequest, ChangeImageCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeImageCompartmentRequest, ChangeImageCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeImageCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeImageCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeImageCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeImageCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.post(ib, interceptedRequest.getChangeImageCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeImageCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ChangeInstanceCompartmentResponse> changeInstanceCompartment(ChangeInstanceCompartmentRequest request, AsyncHandler<ChangeInstanceCompartmentRequest, ChangeInstanceCompartmentResponse> handler) {
        LOG.trace("Called async changeInstanceCompartment");
        final ChangeInstanceCompartmentRequest interceptedRequest = ChangeInstanceCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeInstanceCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeInstanceCompartmentResponse> transformer = ChangeInstanceCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeInstanceCompartmentRequest, ChangeInstanceCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeInstanceCompartmentRequest, ChangeInstanceCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeInstanceCompartmentRequest, ChangeInstanceCompartmentResponse> onSuccess = new SuccessConsumer<ChangeInstanceCompartmentRequest, ChangeInstanceCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeInstanceCompartmentRequest> onError = new ErrorConsumer<ChangeInstanceCompartmentRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.post(ib, interceptedRequest.getChangeInstanceCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeInstanceCompartmentRequest, ChangeInstanceCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeInstanceCompartmentRequest, ChangeInstanceCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeInstanceCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeInstanceCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeInstanceCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeInstanceCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.post(ib, interceptedRequest.getChangeInstanceCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeInstanceCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateAppCatalogSubscriptionResponse> createAppCatalogSubscription(CreateAppCatalogSubscriptionRequest request, AsyncHandler<CreateAppCatalogSubscriptionRequest, CreateAppCatalogSubscriptionResponse> handler) {
        LOG.trace("Called async createAppCatalogSubscription");
        final CreateAppCatalogSubscriptionRequest interceptedRequest = CreateAppCatalogSubscriptionConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateAppCatalogSubscriptionConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateAppCatalogSubscriptionResponse> transformer = CreateAppCatalogSubscriptionConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateAppCatalogSubscriptionRequest, CreateAppCatalogSubscriptionResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateAppCatalogSubscriptionRequest, CreateAppCatalogSubscriptionResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateAppCatalogSubscriptionRequest, CreateAppCatalogSubscriptionResponse> onSuccess = new SuccessConsumer<CreateAppCatalogSubscriptionRequest, CreateAppCatalogSubscriptionResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateAppCatalogSubscriptionRequest> onError = new ErrorConsumer<CreateAppCatalogSubscriptionRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.post(ib, interceptedRequest.getCreateAppCatalogSubscriptionDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateAppCatalogSubscriptionRequest, CreateAppCatalogSubscriptionResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateAppCatalogSubscriptionRequest, CreateAppCatalogSubscriptionResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateAppCatalogSubscriptionRequest> onError = handler == null ? null : new ErrorConsumer<CreateAppCatalogSubscriptionRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateAppCatalogSubscriptionDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateAppCatalogSubscriptionResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.post(ib, interceptedRequest.getCreateAppCatalogSubscriptionDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateAppCatalogSubscriptionResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateDedicatedVmHostResponse> createDedicatedVmHost(CreateDedicatedVmHostRequest request, AsyncHandler<CreateDedicatedVmHostRequest, CreateDedicatedVmHostResponse> handler) {
        LOG.trace("Called async createDedicatedVmHost");
        final CreateDedicatedVmHostRequest interceptedRequest = CreateDedicatedVmHostConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateDedicatedVmHostConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateDedicatedVmHostResponse> transformer = CreateDedicatedVmHostConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateDedicatedVmHostRequest, CreateDedicatedVmHostResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateDedicatedVmHostRequest, CreateDedicatedVmHostResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateDedicatedVmHostRequest, CreateDedicatedVmHostResponse> onSuccess = new SuccessConsumer<CreateDedicatedVmHostRequest, CreateDedicatedVmHostResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateDedicatedVmHostRequest> onError = new ErrorConsumer<CreateDedicatedVmHostRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.post(ib, interceptedRequest.getCreateDedicatedVmHostDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateDedicatedVmHostRequest, CreateDedicatedVmHostResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateDedicatedVmHostRequest, CreateDedicatedVmHostResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateDedicatedVmHostRequest> onError = handler == null ? null : new ErrorConsumer<CreateDedicatedVmHostRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateDedicatedVmHostDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateDedicatedVmHostResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.post(ib, interceptedRequest.getCreateDedicatedVmHostDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateDedicatedVmHostResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateImageResponse> createImage(CreateImageRequest request, AsyncHandler<CreateImageRequest, CreateImageResponse> handler) {
        LOG.trace("Called async createImage");
        final CreateImageRequest interceptedRequest = CreateImageConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateImageConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateImageResponse> transformer = CreateImageConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateImageRequest, CreateImageResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateImageRequest, CreateImageResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateImageRequest, CreateImageResponse> onSuccess = new SuccessConsumer<CreateImageRequest, CreateImageResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateImageRequest> onError = new ErrorConsumer<CreateImageRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.post(ib, interceptedRequest.getCreateImageDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateImageRequest, CreateImageResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateImageRequest, CreateImageResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateImageRequest> onError = handler == null ? null : new ErrorConsumer<CreateImageRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateImageDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateImageResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.post(ib, interceptedRequest.getCreateImageDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateImageResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateInstanceConsoleConnectionResponse> createInstanceConsoleConnection(CreateInstanceConsoleConnectionRequest request, AsyncHandler<CreateInstanceConsoleConnectionRequest, CreateInstanceConsoleConnectionResponse> handler) {
        LOG.trace("Called async createInstanceConsoleConnection");
        final CreateInstanceConsoleConnectionRequest interceptedRequest = CreateInstanceConsoleConnectionConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateInstanceConsoleConnectionConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateInstanceConsoleConnectionResponse> transformer = CreateInstanceConsoleConnectionConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateInstanceConsoleConnectionRequest, CreateInstanceConsoleConnectionResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateInstanceConsoleConnectionRequest, CreateInstanceConsoleConnectionResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateInstanceConsoleConnectionRequest, CreateInstanceConsoleConnectionResponse> onSuccess = new SuccessConsumer<CreateInstanceConsoleConnectionRequest, CreateInstanceConsoleConnectionResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateInstanceConsoleConnectionRequest> onError = new ErrorConsumer<CreateInstanceConsoleConnectionRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.post(ib, interceptedRequest.getCreateInstanceConsoleConnectionDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateInstanceConsoleConnectionRequest, CreateInstanceConsoleConnectionResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateInstanceConsoleConnectionRequest, CreateInstanceConsoleConnectionResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateInstanceConsoleConnectionRequest> onError = handler == null ? null : new ErrorConsumer<CreateInstanceConsoleConnectionRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateInstanceConsoleConnectionDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateInstanceConsoleConnectionResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.post(ib, interceptedRequest.getCreateInstanceConsoleConnectionDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateInstanceConsoleConnectionResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteAppCatalogSubscriptionResponse> deleteAppCatalogSubscription(DeleteAppCatalogSubscriptionRequest request, AsyncHandler<DeleteAppCatalogSubscriptionRequest, DeleteAppCatalogSubscriptionResponse> handler) {
        LOG.trace("Called async deleteAppCatalogSubscription");
        final DeleteAppCatalogSubscriptionRequest interceptedRequest = DeleteAppCatalogSubscriptionConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteAppCatalogSubscriptionConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteAppCatalogSubscriptionResponse> transformer = DeleteAppCatalogSubscriptionConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteAppCatalogSubscriptionRequest, DeleteAppCatalogSubscriptionResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteAppCatalogSubscriptionRequest, DeleteAppCatalogSubscriptionResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteAppCatalogSubscriptionRequest, DeleteAppCatalogSubscriptionResponse> onSuccess = new SuccessConsumer<DeleteAppCatalogSubscriptionRequest, DeleteAppCatalogSubscriptionResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteAppCatalogSubscriptionRequest> onError = new ErrorConsumer<DeleteAppCatalogSubscriptionRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteAppCatalogSubscriptionRequest, DeleteAppCatalogSubscriptionResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteAppCatalogSubscriptionRequest, DeleteAppCatalogSubscriptionResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteAppCatalogSubscriptionRequest> onError = handler == null ? null : new ErrorConsumer<DeleteAppCatalogSubscriptionRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteAppCatalogSubscriptionResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteAppCatalogSubscriptionResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteConsoleHistoryResponse> deleteConsoleHistory(DeleteConsoleHistoryRequest request, AsyncHandler<DeleteConsoleHistoryRequest, DeleteConsoleHistoryResponse> handler) {
        LOG.trace("Called async deleteConsoleHistory");
        final DeleteConsoleHistoryRequest interceptedRequest = DeleteConsoleHistoryConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteConsoleHistoryConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteConsoleHistoryResponse> transformer = DeleteConsoleHistoryConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteConsoleHistoryRequest, DeleteConsoleHistoryResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteConsoleHistoryRequest, DeleteConsoleHistoryResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteConsoleHistoryRequest, DeleteConsoleHistoryResponse> onSuccess = new SuccessConsumer<DeleteConsoleHistoryRequest, DeleteConsoleHistoryResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteConsoleHistoryRequest> onError = new ErrorConsumer<DeleteConsoleHistoryRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteConsoleHistoryRequest, DeleteConsoleHistoryResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteConsoleHistoryRequest, DeleteConsoleHistoryResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteConsoleHistoryRequest> onError = handler == null ? null : new ErrorConsumer<DeleteConsoleHistoryRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteConsoleHistoryResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteConsoleHistoryResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteDedicatedVmHostResponse> deleteDedicatedVmHost(DeleteDedicatedVmHostRequest request, AsyncHandler<DeleteDedicatedVmHostRequest, DeleteDedicatedVmHostResponse> handler) {
        LOG.trace("Called async deleteDedicatedVmHost");
        final DeleteDedicatedVmHostRequest interceptedRequest = DeleteDedicatedVmHostConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteDedicatedVmHostConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteDedicatedVmHostResponse> transformer = DeleteDedicatedVmHostConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteDedicatedVmHostRequest, DeleteDedicatedVmHostResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteDedicatedVmHostRequest, DeleteDedicatedVmHostResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteDedicatedVmHostRequest, DeleteDedicatedVmHostResponse> onSuccess = new SuccessConsumer<DeleteDedicatedVmHostRequest, DeleteDedicatedVmHostResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteDedicatedVmHostRequest> onError = new ErrorConsumer<DeleteDedicatedVmHostRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteDedicatedVmHostRequest, DeleteDedicatedVmHostResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteDedicatedVmHostRequest, DeleteDedicatedVmHostResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteDedicatedVmHostRequest> onError = handler == null ? null : new ErrorConsumer<DeleteDedicatedVmHostRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteDedicatedVmHostResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteDedicatedVmHostResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteImageResponse> deleteImage(DeleteImageRequest request, AsyncHandler<DeleteImageRequest, DeleteImageResponse> handler) {
        LOG.trace("Called async deleteImage");
        final DeleteImageRequest interceptedRequest = DeleteImageConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteImageConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteImageResponse> transformer = DeleteImageConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteImageRequest, DeleteImageResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteImageRequest, DeleteImageResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteImageRequest, DeleteImageResponse> onSuccess = new SuccessConsumer<DeleteImageRequest, DeleteImageResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteImageRequest> onError = new ErrorConsumer<DeleteImageRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteImageRequest, DeleteImageResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteImageRequest, DeleteImageResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteImageRequest> onError = handler == null ? null : new ErrorConsumer<DeleteImageRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteImageResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteImageResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteInstanceConsoleConnectionResponse> deleteInstanceConsoleConnection(DeleteInstanceConsoleConnectionRequest request, AsyncHandler<DeleteInstanceConsoleConnectionRequest, DeleteInstanceConsoleConnectionResponse> handler) {
        LOG.trace("Called async deleteInstanceConsoleConnection");
        final DeleteInstanceConsoleConnectionRequest interceptedRequest = DeleteInstanceConsoleConnectionConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteInstanceConsoleConnectionConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteInstanceConsoleConnectionResponse> transformer = DeleteInstanceConsoleConnectionConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteInstanceConsoleConnectionRequest, DeleteInstanceConsoleConnectionResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteInstanceConsoleConnectionRequest, DeleteInstanceConsoleConnectionResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteInstanceConsoleConnectionRequest, DeleteInstanceConsoleConnectionResponse> onSuccess = new SuccessConsumer<DeleteInstanceConsoleConnectionRequest, DeleteInstanceConsoleConnectionResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteInstanceConsoleConnectionRequest> onError = new ErrorConsumer<DeleteInstanceConsoleConnectionRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteInstanceConsoleConnectionRequest, DeleteInstanceConsoleConnectionResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteInstanceConsoleConnectionRequest, DeleteInstanceConsoleConnectionResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteInstanceConsoleConnectionRequest> onError = handler == null ? null : new ErrorConsumer<DeleteInstanceConsoleConnectionRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteInstanceConsoleConnectionResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteInstanceConsoleConnectionResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DetachBootVolumeResponse> detachBootVolume(DetachBootVolumeRequest request, AsyncHandler<DetachBootVolumeRequest, DetachBootVolumeResponse> handler) {
        LOG.trace("Called async detachBootVolume");
        final DetachBootVolumeRequest interceptedRequest = DetachBootVolumeConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DetachBootVolumeConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DetachBootVolumeResponse> transformer = DetachBootVolumeConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DetachBootVolumeRequest, DetachBootVolumeResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DetachBootVolumeRequest, DetachBootVolumeResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DetachBootVolumeRequest, DetachBootVolumeResponse> onSuccess = new SuccessConsumer<DetachBootVolumeRequest, DetachBootVolumeResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DetachBootVolumeRequest> onError = new ErrorConsumer<DetachBootVolumeRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DetachBootVolumeRequest, DetachBootVolumeResponse> onSuccess = handler == null ? null : new SuccessConsumer<DetachBootVolumeRequest, DetachBootVolumeResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DetachBootVolumeRequest> onError = handler == null ? null : new ErrorConsumer<DetachBootVolumeRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DetachBootVolumeResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DetachBootVolumeResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DetachVnicResponse> detachVnic(DetachVnicRequest request, AsyncHandler<DetachVnicRequest, DetachVnicResponse> handler) {
        LOG.trace("Called async detachVnic");
        final DetachVnicRequest interceptedRequest = DetachVnicConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DetachVnicConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DetachVnicResponse> transformer = DetachVnicConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DetachVnicRequest, DetachVnicResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DetachVnicRequest, DetachVnicResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DetachVnicRequest, DetachVnicResponse> onSuccess = new SuccessConsumer<DetachVnicRequest, DetachVnicResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DetachVnicRequest> onError = new ErrorConsumer<DetachVnicRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DetachVnicRequest, DetachVnicResponse> onSuccess = handler == null ? null : new SuccessConsumer<DetachVnicRequest, DetachVnicResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DetachVnicRequest> onError = handler == null ? null : new ErrorConsumer<DetachVnicRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DetachVnicResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DetachVnicResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DetachVolumeResponse> detachVolume(DetachVolumeRequest request, AsyncHandler<DetachVolumeRequest, DetachVolumeResponse> handler) {
        LOG.trace("Called async detachVolume");
        final DetachVolumeRequest interceptedRequest = DetachVolumeConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DetachVolumeConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DetachVolumeResponse> transformer = DetachVolumeConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DetachVolumeRequest, DetachVolumeResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DetachVolumeRequest, DetachVolumeResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DetachVolumeRequest, DetachVolumeResponse> onSuccess = new SuccessConsumer<DetachVolumeRequest, DetachVolumeResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DetachVolumeRequest> onError = new ErrorConsumer<DetachVolumeRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DetachVolumeRequest, DetachVolumeResponse> onSuccess = handler == null ? null : new SuccessConsumer<DetachVolumeRequest, DetachVolumeResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DetachVolumeRequest> onError = handler == null ? null : new ErrorConsumer<DetachVolumeRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DetachVolumeResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DetachVolumeResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ExportImageResponse> exportImage(ExportImageRequest request, AsyncHandler<ExportImageRequest, ExportImageResponse> handler) {
        LOG.trace("Called async exportImage");
        final ExportImageRequest interceptedRequest = ExportImageConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ExportImageConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ExportImageResponse> transformer = ExportImageConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ExportImageRequest, ExportImageResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ExportImageRequest, ExportImageResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ExportImageRequest, ExportImageResponse> onSuccess = new SuccessConsumer<ExportImageRequest, ExportImageResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ExportImageRequest> onError = new ErrorConsumer<ExportImageRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.post(ib, interceptedRequest.getExportImageDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ExportImageRequest, ExportImageResponse> onSuccess = handler == null ? null : new SuccessConsumer<ExportImageRequest, ExportImageResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ExportImageRequest> onError = handler == null ? null : new ErrorConsumer<ExportImageRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getExportImageDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ExportImageResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.post(ib, interceptedRequest.getExportImageDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ExportImageResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetAppCatalogListingResponse> getAppCatalogListing(GetAppCatalogListingRequest request, AsyncHandler<GetAppCatalogListingRequest, GetAppCatalogListingResponse> handler) {
        LOG.trace("Called async getAppCatalogListing");
        final GetAppCatalogListingRequest interceptedRequest = GetAppCatalogListingConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetAppCatalogListingConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetAppCatalogListingResponse> transformer = GetAppCatalogListingConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetAppCatalogListingRequest, GetAppCatalogListingResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetAppCatalogListingRequest, GetAppCatalogListingResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetAppCatalogListingRequest, GetAppCatalogListingResponse> onSuccess = new SuccessConsumer<GetAppCatalogListingRequest, GetAppCatalogListingResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetAppCatalogListingRequest> onError = new ErrorConsumer<GetAppCatalogListingRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetAppCatalogListingRequest, GetAppCatalogListingResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetAppCatalogListingRequest, GetAppCatalogListingResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetAppCatalogListingRequest> onError = handler == null ? null : new ErrorConsumer<GetAppCatalogListingRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetAppCatalogListingResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetAppCatalogListingResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetAppCatalogListingAgreementsResponse> getAppCatalogListingAgreements(GetAppCatalogListingAgreementsRequest request, AsyncHandler<GetAppCatalogListingAgreementsRequest, GetAppCatalogListingAgreementsResponse> handler) {
        LOG.trace("Called async getAppCatalogListingAgreements");
        final GetAppCatalogListingAgreementsRequest interceptedRequest = GetAppCatalogListingAgreementsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetAppCatalogListingAgreementsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetAppCatalogListingAgreementsResponse> transformer = GetAppCatalogListingAgreementsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetAppCatalogListingAgreementsRequest, GetAppCatalogListingAgreementsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetAppCatalogListingAgreementsRequest, GetAppCatalogListingAgreementsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetAppCatalogListingAgreementsRequest, GetAppCatalogListingAgreementsResponse> onSuccess = new SuccessConsumer<GetAppCatalogListingAgreementsRequest, GetAppCatalogListingAgreementsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetAppCatalogListingAgreementsRequest> onError = new ErrorConsumer<GetAppCatalogListingAgreementsRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetAppCatalogListingAgreementsRequest, GetAppCatalogListingAgreementsResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetAppCatalogListingAgreementsRequest, GetAppCatalogListingAgreementsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetAppCatalogListingAgreementsRequest> onError = handler == null ? null : new ErrorConsumer<GetAppCatalogListingAgreementsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetAppCatalogListingAgreementsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetAppCatalogListingAgreementsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetAppCatalogListingResourceVersionResponse> getAppCatalogListingResourceVersion(GetAppCatalogListingResourceVersionRequest request, AsyncHandler<GetAppCatalogListingResourceVersionRequest, GetAppCatalogListingResourceVersionResponse> handler) {
        LOG.trace("Called async getAppCatalogListingResourceVersion");
        final GetAppCatalogListingResourceVersionRequest interceptedRequest = GetAppCatalogListingResourceVersionConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetAppCatalogListingResourceVersionConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetAppCatalogListingResourceVersionResponse> transformer = GetAppCatalogListingResourceVersionConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetAppCatalogListingResourceVersionRequest, GetAppCatalogListingResourceVersionResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetAppCatalogListingResourceVersionRequest, GetAppCatalogListingResourceVersionResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetAppCatalogListingResourceVersionRequest, GetAppCatalogListingResourceVersionResponse> onSuccess = new SuccessConsumer<GetAppCatalogListingResourceVersionRequest, GetAppCatalogListingResourceVersionResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetAppCatalogListingResourceVersionRequest> onError = new ErrorConsumer<GetAppCatalogListingResourceVersionRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetAppCatalogListingResourceVersionRequest, GetAppCatalogListingResourceVersionResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetAppCatalogListingResourceVersionRequest, GetAppCatalogListingResourceVersionResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetAppCatalogListingResourceVersionRequest> onError = handler == null ? null : new ErrorConsumer<GetAppCatalogListingResourceVersionRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetAppCatalogListingResourceVersionResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetAppCatalogListingResourceVersionResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetBootVolumeAttachmentResponse> getBootVolumeAttachment(GetBootVolumeAttachmentRequest request, AsyncHandler<GetBootVolumeAttachmentRequest, GetBootVolumeAttachmentResponse> handler) {
        LOG.trace("Called async getBootVolumeAttachment");
        final GetBootVolumeAttachmentRequest interceptedRequest = GetBootVolumeAttachmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetBootVolumeAttachmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetBootVolumeAttachmentResponse> transformer = GetBootVolumeAttachmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetBootVolumeAttachmentRequest, GetBootVolumeAttachmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetBootVolumeAttachmentRequest, GetBootVolumeAttachmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetBootVolumeAttachmentRequest, GetBootVolumeAttachmentResponse> onSuccess = new SuccessConsumer<GetBootVolumeAttachmentRequest, GetBootVolumeAttachmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetBootVolumeAttachmentRequest> onError = new ErrorConsumer<GetBootVolumeAttachmentRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetBootVolumeAttachmentRequest, GetBootVolumeAttachmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetBootVolumeAttachmentRequest, GetBootVolumeAttachmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetBootVolumeAttachmentRequest> onError = handler == null ? null : new ErrorConsumer<GetBootVolumeAttachmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetBootVolumeAttachmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetBootVolumeAttachmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetConsoleHistoryResponse> getConsoleHistory(GetConsoleHistoryRequest request, AsyncHandler<GetConsoleHistoryRequest, GetConsoleHistoryResponse> handler) {
        LOG.trace("Called async getConsoleHistory");
        final GetConsoleHistoryRequest interceptedRequest = GetConsoleHistoryConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetConsoleHistoryConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetConsoleHistoryResponse> transformer = GetConsoleHistoryConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetConsoleHistoryRequest, GetConsoleHistoryResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetConsoleHistoryRequest, GetConsoleHistoryResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetConsoleHistoryRequest, GetConsoleHistoryResponse> onSuccess = new SuccessConsumer<GetConsoleHistoryRequest, GetConsoleHistoryResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetConsoleHistoryRequest> onError = new ErrorConsumer<GetConsoleHistoryRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetConsoleHistoryRequest, GetConsoleHistoryResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetConsoleHistoryRequest, GetConsoleHistoryResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetConsoleHistoryRequest> onError = handler == null ? null : new ErrorConsumer<GetConsoleHistoryRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetConsoleHistoryResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetConsoleHistoryResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetConsoleHistoryContentResponse> getConsoleHistoryContent(GetConsoleHistoryContentRequest request, AsyncHandler<GetConsoleHistoryContentRequest, GetConsoleHistoryContentResponse> handler) {
        LOG.trace("Called async getConsoleHistoryContent");
        final GetConsoleHistoryContentRequest interceptedRequest = GetConsoleHistoryContentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetConsoleHistoryContentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetConsoleHistoryContentResponse> transformer = GetConsoleHistoryContentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetConsoleHistoryContentRequest, GetConsoleHistoryContentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetConsoleHistoryContentRequest, GetConsoleHistoryContentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetConsoleHistoryContentRequest, GetConsoleHistoryContentResponse> onSuccess = new SuccessConsumer<GetConsoleHistoryContentRequest, GetConsoleHistoryContentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetConsoleHistoryContentRequest> onError = new ErrorConsumer<GetConsoleHistoryContentRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetConsoleHistoryContentRequest, GetConsoleHistoryContentResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetConsoleHistoryContentRequest, GetConsoleHistoryContentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetConsoleHistoryContentRequest> onError = handler == null ? null : new ErrorConsumer<GetConsoleHistoryContentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetConsoleHistoryContentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetConsoleHistoryContentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetDedicatedVmHostResponse> getDedicatedVmHost(GetDedicatedVmHostRequest request, AsyncHandler<GetDedicatedVmHostRequest, GetDedicatedVmHostResponse> handler) {
        LOG.trace("Called async getDedicatedVmHost");
        final GetDedicatedVmHostRequest interceptedRequest = GetDedicatedVmHostConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetDedicatedVmHostConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetDedicatedVmHostResponse> transformer = GetDedicatedVmHostConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetDedicatedVmHostRequest, GetDedicatedVmHostResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetDedicatedVmHostRequest, GetDedicatedVmHostResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetDedicatedVmHostRequest, GetDedicatedVmHostResponse> onSuccess = new SuccessConsumer<GetDedicatedVmHostRequest, GetDedicatedVmHostResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetDedicatedVmHostRequest> onError = new ErrorConsumer<GetDedicatedVmHostRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetDedicatedVmHostRequest, GetDedicatedVmHostResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetDedicatedVmHostRequest, GetDedicatedVmHostResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetDedicatedVmHostRequest> onError = handler == null ? null : new ErrorConsumer<GetDedicatedVmHostRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetDedicatedVmHostResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetDedicatedVmHostResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetImageResponse> getImage(GetImageRequest request, AsyncHandler<GetImageRequest, GetImageResponse> handler) {
        LOG.trace("Called async getImage");
        final GetImageRequest interceptedRequest = GetImageConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetImageConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetImageResponse> transformer = GetImageConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetImageRequest, GetImageResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetImageRequest, GetImageResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetImageRequest, GetImageResponse> onSuccess = new SuccessConsumer<GetImageRequest, GetImageResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetImageRequest> onError = new ErrorConsumer<GetImageRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetImageRequest, GetImageResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetImageRequest, GetImageResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetImageRequest> onError = handler == null ? null : new ErrorConsumer<GetImageRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetImageResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetImageResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetInstanceResponse> getInstance(GetInstanceRequest request, AsyncHandler<GetInstanceRequest, GetInstanceResponse> handler) {
        LOG.trace("Called async getInstance");
        final GetInstanceRequest interceptedRequest = GetInstanceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetInstanceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetInstanceResponse> transformer = GetInstanceConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetInstanceRequest, GetInstanceResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetInstanceRequest, GetInstanceResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetInstanceRequest, GetInstanceResponse> onSuccess = new SuccessConsumer<GetInstanceRequest, GetInstanceResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetInstanceRequest> onError = new ErrorConsumer<GetInstanceRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetInstanceRequest, GetInstanceResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetInstanceRequest, GetInstanceResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetInstanceRequest> onError = handler == null ? null : new ErrorConsumer<GetInstanceRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetInstanceResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetInstanceResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetInstanceConsoleConnectionResponse> getInstanceConsoleConnection(GetInstanceConsoleConnectionRequest request, AsyncHandler<GetInstanceConsoleConnectionRequest, GetInstanceConsoleConnectionResponse> handler) {
        LOG.trace("Called async getInstanceConsoleConnection");
        final GetInstanceConsoleConnectionRequest interceptedRequest = GetInstanceConsoleConnectionConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetInstanceConsoleConnectionConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetInstanceConsoleConnectionResponse> transformer = GetInstanceConsoleConnectionConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetInstanceConsoleConnectionRequest, GetInstanceConsoleConnectionResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetInstanceConsoleConnectionRequest, GetInstanceConsoleConnectionResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetInstanceConsoleConnectionRequest, GetInstanceConsoleConnectionResponse> onSuccess = new SuccessConsumer<GetInstanceConsoleConnectionRequest, GetInstanceConsoleConnectionResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetInstanceConsoleConnectionRequest> onError = new ErrorConsumer<GetInstanceConsoleConnectionRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetInstanceConsoleConnectionRequest, GetInstanceConsoleConnectionResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetInstanceConsoleConnectionRequest, GetInstanceConsoleConnectionResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetInstanceConsoleConnectionRequest> onError = handler == null ? null : new ErrorConsumer<GetInstanceConsoleConnectionRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetInstanceConsoleConnectionResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetInstanceConsoleConnectionResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetVnicAttachmentResponse> getVnicAttachment(GetVnicAttachmentRequest request, AsyncHandler<GetVnicAttachmentRequest, GetVnicAttachmentResponse> handler) {
        LOG.trace("Called async getVnicAttachment");
        final GetVnicAttachmentRequest interceptedRequest = GetVnicAttachmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetVnicAttachmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetVnicAttachmentResponse> transformer = GetVnicAttachmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetVnicAttachmentRequest, GetVnicAttachmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetVnicAttachmentRequest, GetVnicAttachmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetVnicAttachmentRequest, GetVnicAttachmentResponse> onSuccess = new SuccessConsumer<GetVnicAttachmentRequest, GetVnicAttachmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetVnicAttachmentRequest> onError = new ErrorConsumer<GetVnicAttachmentRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetVnicAttachmentRequest, GetVnicAttachmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetVnicAttachmentRequest, GetVnicAttachmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetVnicAttachmentRequest> onError = handler == null ? null : new ErrorConsumer<GetVnicAttachmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetVnicAttachmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetVnicAttachmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetVolumeAttachmentResponse> getVolumeAttachment(GetVolumeAttachmentRequest request, AsyncHandler<GetVolumeAttachmentRequest, GetVolumeAttachmentResponse> handler) {
        LOG.trace("Called async getVolumeAttachment");
        final GetVolumeAttachmentRequest interceptedRequest = GetVolumeAttachmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetVolumeAttachmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetVolumeAttachmentResponse> transformer = GetVolumeAttachmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetVolumeAttachmentRequest, GetVolumeAttachmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetVolumeAttachmentRequest, GetVolumeAttachmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetVolumeAttachmentRequest, GetVolumeAttachmentResponse> onSuccess = new SuccessConsumer<GetVolumeAttachmentRequest, GetVolumeAttachmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetVolumeAttachmentRequest> onError = new ErrorConsumer<GetVolumeAttachmentRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetVolumeAttachmentRequest, GetVolumeAttachmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetVolumeAttachmentRequest, GetVolumeAttachmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetVolumeAttachmentRequest> onError = handler == null ? null : new ErrorConsumer<GetVolumeAttachmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetVolumeAttachmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetVolumeAttachmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetWindowsInstanceInitialCredentialsResponse> getWindowsInstanceInitialCredentials(GetWindowsInstanceInitialCredentialsRequest request, AsyncHandler<GetWindowsInstanceInitialCredentialsRequest, GetWindowsInstanceInitialCredentialsResponse> handler) {
        LOG.trace("Called async getWindowsInstanceInitialCredentials");
        final GetWindowsInstanceInitialCredentialsRequest interceptedRequest = GetWindowsInstanceInitialCredentialsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetWindowsInstanceInitialCredentialsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetWindowsInstanceInitialCredentialsResponse> transformer = GetWindowsInstanceInitialCredentialsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetWindowsInstanceInitialCredentialsRequest, GetWindowsInstanceInitialCredentialsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetWindowsInstanceInitialCredentialsRequest, GetWindowsInstanceInitialCredentialsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetWindowsInstanceInitialCredentialsRequest, GetWindowsInstanceInitialCredentialsResponse> onSuccess = new SuccessConsumer<GetWindowsInstanceInitialCredentialsRequest, GetWindowsInstanceInitialCredentialsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetWindowsInstanceInitialCredentialsRequest> onError = new ErrorConsumer<GetWindowsInstanceInitialCredentialsRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetWindowsInstanceInitialCredentialsRequest, GetWindowsInstanceInitialCredentialsResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetWindowsInstanceInitialCredentialsRequest, GetWindowsInstanceInitialCredentialsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetWindowsInstanceInitialCredentialsRequest> onError = handler == null ? null : new ErrorConsumer<GetWindowsInstanceInitialCredentialsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetWindowsInstanceInitialCredentialsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetWindowsInstanceInitialCredentialsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<InstanceActionResponse> instanceAction(InstanceActionRequest request, AsyncHandler<InstanceActionRequest, InstanceActionResponse> handler) {
        LOG.trace("Called async instanceAction");
        final InstanceActionRequest interceptedRequest = InstanceActionConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = InstanceActionConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, InstanceActionResponse> transformer = InstanceActionConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<InstanceActionRequest, InstanceActionResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<InstanceActionRequest, InstanceActionResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<InstanceActionRequest, InstanceActionResponse> onSuccess = new SuccessConsumer<InstanceActionRequest, InstanceActionResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<InstanceActionRequest> onError = new ErrorConsumer<InstanceActionRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<InstanceActionRequest, InstanceActionResponse> onSuccess = handler == null ? null : new SuccessConsumer<InstanceActionRequest, InstanceActionResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<InstanceActionRequest> onError = handler == null ? null : new ErrorConsumer<InstanceActionRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, InstanceActionResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, InstanceActionResponse>(responseFuture, transformer);
    }

    @Override
    public Future<LaunchInstanceResponse> launchInstance(LaunchInstanceRequest request, AsyncHandler<LaunchInstanceRequest, LaunchInstanceResponse> handler) {
        LOG.trace("Called async launchInstance");
        final LaunchInstanceRequest interceptedRequest = LaunchInstanceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = LaunchInstanceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, LaunchInstanceResponse> transformer = LaunchInstanceConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<LaunchInstanceRequest, LaunchInstanceResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<LaunchInstanceRequest, LaunchInstanceResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<LaunchInstanceRequest, LaunchInstanceResponse> onSuccess = new SuccessConsumer<LaunchInstanceRequest, LaunchInstanceResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<LaunchInstanceRequest> onError = new ErrorConsumer<LaunchInstanceRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.post(ib, interceptedRequest.getLaunchInstanceDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<LaunchInstanceRequest, LaunchInstanceResponse> onSuccess = handler == null ? null : new SuccessConsumer<LaunchInstanceRequest, LaunchInstanceResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<LaunchInstanceRequest> onError = handler == null ? null : new ErrorConsumer<LaunchInstanceRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getLaunchInstanceDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, LaunchInstanceResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.post(ib, interceptedRequest.getLaunchInstanceDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, LaunchInstanceResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListAppCatalogListingResourceVersionsResponse> listAppCatalogListingResourceVersions(ListAppCatalogListingResourceVersionsRequest request, AsyncHandler<ListAppCatalogListingResourceVersionsRequest, ListAppCatalogListingResourceVersionsResponse> handler) {
        LOG.trace("Called async listAppCatalogListingResourceVersions");
        final ListAppCatalogListingResourceVersionsRequest interceptedRequest = ListAppCatalogListingResourceVersionsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListAppCatalogListingResourceVersionsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListAppCatalogListingResourceVersionsResponse> transformer = ListAppCatalogListingResourceVersionsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListAppCatalogListingResourceVersionsRequest, ListAppCatalogListingResourceVersionsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListAppCatalogListingResourceVersionsRequest, ListAppCatalogListingResourceVersionsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListAppCatalogListingResourceVersionsRequest, ListAppCatalogListingResourceVersionsResponse> onSuccess = new SuccessConsumer<ListAppCatalogListingResourceVersionsRequest, ListAppCatalogListingResourceVersionsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListAppCatalogListingResourceVersionsRequest> onError = new ErrorConsumer<ListAppCatalogListingResourceVersionsRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListAppCatalogListingResourceVersionsRequest, ListAppCatalogListingResourceVersionsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListAppCatalogListingResourceVersionsRequest, ListAppCatalogListingResourceVersionsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListAppCatalogListingResourceVersionsRequest> onError = handler == null ? null : new ErrorConsumer<ListAppCatalogListingResourceVersionsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListAppCatalogListingResourceVersionsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListAppCatalogListingResourceVersionsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListAppCatalogListingsResponse> listAppCatalogListings(ListAppCatalogListingsRequest request, AsyncHandler<ListAppCatalogListingsRequest, ListAppCatalogListingsResponse> handler) {
        LOG.trace("Called async listAppCatalogListings");
        final ListAppCatalogListingsRequest interceptedRequest = ListAppCatalogListingsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListAppCatalogListingsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListAppCatalogListingsResponse> transformer = ListAppCatalogListingsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListAppCatalogListingsRequest, ListAppCatalogListingsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListAppCatalogListingsRequest, ListAppCatalogListingsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListAppCatalogListingsRequest, ListAppCatalogListingsResponse> onSuccess = new SuccessConsumer<ListAppCatalogListingsRequest, ListAppCatalogListingsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListAppCatalogListingsRequest> onError = new ErrorConsumer<ListAppCatalogListingsRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListAppCatalogListingsRequest, ListAppCatalogListingsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListAppCatalogListingsRequest, ListAppCatalogListingsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListAppCatalogListingsRequest> onError = handler == null ? null : new ErrorConsumer<ListAppCatalogListingsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListAppCatalogListingsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListAppCatalogListingsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListAppCatalogSubscriptionsResponse> listAppCatalogSubscriptions(ListAppCatalogSubscriptionsRequest request, AsyncHandler<ListAppCatalogSubscriptionsRequest, ListAppCatalogSubscriptionsResponse> handler) {
        LOG.trace("Called async listAppCatalogSubscriptions");
        final ListAppCatalogSubscriptionsRequest interceptedRequest = ListAppCatalogSubscriptionsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListAppCatalogSubscriptionsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListAppCatalogSubscriptionsResponse> transformer = ListAppCatalogSubscriptionsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListAppCatalogSubscriptionsRequest, ListAppCatalogSubscriptionsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListAppCatalogSubscriptionsRequest, ListAppCatalogSubscriptionsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListAppCatalogSubscriptionsRequest, ListAppCatalogSubscriptionsResponse> onSuccess = new SuccessConsumer<ListAppCatalogSubscriptionsRequest, ListAppCatalogSubscriptionsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListAppCatalogSubscriptionsRequest> onError = new ErrorConsumer<ListAppCatalogSubscriptionsRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListAppCatalogSubscriptionsRequest, ListAppCatalogSubscriptionsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListAppCatalogSubscriptionsRequest, ListAppCatalogSubscriptionsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListAppCatalogSubscriptionsRequest> onError = handler == null ? null : new ErrorConsumer<ListAppCatalogSubscriptionsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListAppCatalogSubscriptionsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListAppCatalogSubscriptionsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListBootVolumeAttachmentsResponse> listBootVolumeAttachments(ListBootVolumeAttachmentsRequest request, AsyncHandler<ListBootVolumeAttachmentsRequest, ListBootVolumeAttachmentsResponse> handler) {
        LOG.trace("Called async listBootVolumeAttachments");
        final ListBootVolumeAttachmentsRequest interceptedRequest = ListBootVolumeAttachmentsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListBootVolumeAttachmentsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListBootVolumeAttachmentsResponse> transformer = ListBootVolumeAttachmentsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListBootVolumeAttachmentsRequest, ListBootVolumeAttachmentsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListBootVolumeAttachmentsRequest, ListBootVolumeAttachmentsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListBootVolumeAttachmentsRequest, ListBootVolumeAttachmentsResponse> onSuccess = new SuccessConsumer<ListBootVolumeAttachmentsRequest, ListBootVolumeAttachmentsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListBootVolumeAttachmentsRequest> onError = new ErrorConsumer<ListBootVolumeAttachmentsRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListBootVolumeAttachmentsRequest, ListBootVolumeAttachmentsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListBootVolumeAttachmentsRequest, ListBootVolumeAttachmentsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListBootVolumeAttachmentsRequest> onError = handler == null ? null : new ErrorConsumer<ListBootVolumeAttachmentsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListBootVolumeAttachmentsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListBootVolumeAttachmentsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListConsoleHistoriesResponse> listConsoleHistories(ListConsoleHistoriesRequest request, AsyncHandler<ListConsoleHistoriesRequest, ListConsoleHistoriesResponse> handler) {
        LOG.trace("Called async listConsoleHistories");
        final ListConsoleHistoriesRequest interceptedRequest = ListConsoleHistoriesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListConsoleHistoriesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListConsoleHistoriesResponse> transformer = ListConsoleHistoriesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListConsoleHistoriesRequest, ListConsoleHistoriesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListConsoleHistoriesRequest, ListConsoleHistoriesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListConsoleHistoriesRequest, ListConsoleHistoriesResponse> onSuccess = new SuccessConsumer<ListConsoleHistoriesRequest, ListConsoleHistoriesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListConsoleHistoriesRequest> onError = new ErrorConsumer<ListConsoleHistoriesRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListConsoleHistoriesRequest, ListConsoleHistoriesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListConsoleHistoriesRequest, ListConsoleHistoriesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListConsoleHistoriesRequest> onError = handler == null ? null : new ErrorConsumer<ListConsoleHistoriesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListConsoleHistoriesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListConsoleHistoriesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListDedicatedVmHostInstanceShapesResponse> listDedicatedVmHostInstanceShapes(ListDedicatedVmHostInstanceShapesRequest request, AsyncHandler<ListDedicatedVmHostInstanceShapesRequest, ListDedicatedVmHostInstanceShapesResponse> handler) {
        LOG.trace("Called async listDedicatedVmHostInstanceShapes");
        final ListDedicatedVmHostInstanceShapesRequest interceptedRequest = ListDedicatedVmHostInstanceShapesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListDedicatedVmHostInstanceShapesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListDedicatedVmHostInstanceShapesResponse> transformer = ListDedicatedVmHostInstanceShapesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListDedicatedVmHostInstanceShapesRequest, ListDedicatedVmHostInstanceShapesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListDedicatedVmHostInstanceShapesRequest, ListDedicatedVmHostInstanceShapesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListDedicatedVmHostInstanceShapesRequest, ListDedicatedVmHostInstanceShapesResponse> onSuccess = new SuccessConsumer<ListDedicatedVmHostInstanceShapesRequest, ListDedicatedVmHostInstanceShapesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListDedicatedVmHostInstanceShapesRequest> onError = new ErrorConsumer<ListDedicatedVmHostInstanceShapesRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListDedicatedVmHostInstanceShapesRequest, ListDedicatedVmHostInstanceShapesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListDedicatedVmHostInstanceShapesRequest, ListDedicatedVmHostInstanceShapesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListDedicatedVmHostInstanceShapesRequest> onError = handler == null ? null : new ErrorConsumer<ListDedicatedVmHostInstanceShapesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListDedicatedVmHostInstanceShapesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListDedicatedVmHostInstanceShapesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListDedicatedVmHostInstancesResponse> listDedicatedVmHostInstances(ListDedicatedVmHostInstancesRequest request, AsyncHandler<ListDedicatedVmHostInstancesRequest, ListDedicatedVmHostInstancesResponse> handler) {
        LOG.trace("Called async listDedicatedVmHostInstances");
        final ListDedicatedVmHostInstancesRequest interceptedRequest = ListDedicatedVmHostInstancesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListDedicatedVmHostInstancesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListDedicatedVmHostInstancesResponse> transformer = ListDedicatedVmHostInstancesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListDedicatedVmHostInstancesRequest, ListDedicatedVmHostInstancesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListDedicatedVmHostInstancesRequest, ListDedicatedVmHostInstancesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListDedicatedVmHostInstancesRequest, ListDedicatedVmHostInstancesResponse> onSuccess = new SuccessConsumer<ListDedicatedVmHostInstancesRequest, ListDedicatedVmHostInstancesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListDedicatedVmHostInstancesRequest> onError = new ErrorConsumer<ListDedicatedVmHostInstancesRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListDedicatedVmHostInstancesRequest, ListDedicatedVmHostInstancesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListDedicatedVmHostInstancesRequest, ListDedicatedVmHostInstancesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListDedicatedVmHostInstancesRequest> onError = handler == null ? null : new ErrorConsumer<ListDedicatedVmHostInstancesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListDedicatedVmHostInstancesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListDedicatedVmHostInstancesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListDedicatedVmHostShapesResponse> listDedicatedVmHostShapes(ListDedicatedVmHostShapesRequest request, AsyncHandler<ListDedicatedVmHostShapesRequest, ListDedicatedVmHostShapesResponse> handler) {
        LOG.trace("Called async listDedicatedVmHostShapes");
        final ListDedicatedVmHostShapesRequest interceptedRequest = ListDedicatedVmHostShapesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListDedicatedVmHostShapesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListDedicatedVmHostShapesResponse> transformer = ListDedicatedVmHostShapesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListDedicatedVmHostShapesRequest, ListDedicatedVmHostShapesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListDedicatedVmHostShapesRequest, ListDedicatedVmHostShapesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListDedicatedVmHostShapesRequest, ListDedicatedVmHostShapesResponse> onSuccess = new SuccessConsumer<ListDedicatedVmHostShapesRequest, ListDedicatedVmHostShapesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListDedicatedVmHostShapesRequest> onError = new ErrorConsumer<ListDedicatedVmHostShapesRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListDedicatedVmHostShapesRequest, ListDedicatedVmHostShapesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListDedicatedVmHostShapesRequest, ListDedicatedVmHostShapesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListDedicatedVmHostShapesRequest> onError = handler == null ? null : new ErrorConsumer<ListDedicatedVmHostShapesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListDedicatedVmHostShapesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListDedicatedVmHostShapesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListDedicatedVmHostsResponse> listDedicatedVmHosts(ListDedicatedVmHostsRequest request, AsyncHandler<ListDedicatedVmHostsRequest, ListDedicatedVmHostsResponse> handler) {
        LOG.trace("Called async listDedicatedVmHosts");
        final ListDedicatedVmHostsRequest interceptedRequest = ListDedicatedVmHostsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListDedicatedVmHostsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListDedicatedVmHostsResponse> transformer = ListDedicatedVmHostsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListDedicatedVmHostsRequest, ListDedicatedVmHostsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListDedicatedVmHostsRequest, ListDedicatedVmHostsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListDedicatedVmHostsRequest, ListDedicatedVmHostsResponse> onSuccess = new SuccessConsumer<ListDedicatedVmHostsRequest, ListDedicatedVmHostsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListDedicatedVmHostsRequest> onError = new ErrorConsumer<ListDedicatedVmHostsRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListDedicatedVmHostsRequest, ListDedicatedVmHostsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListDedicatedVmHostsRequest, ListDedicatedVmHostsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListDedicatedVmHostsRequest> onError = handler == null ? null : new ErrorConsumer<ListDedicatedVmHostsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListDedicatedVmHostsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListDedicatedVmHostsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListImagesResponse> listImages(ListImagesRequest request, AsyncHandler<ListImagesRequest, ListImagesResponse> handler) {
        LOG.trace("Called async listImages");
        final ListImagesRequest interceptedRequest = ListImagesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListImagesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListImagesResponse> transformer = ListImagesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListImagesRequest, ListImagesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListImagesRequest, ListImagesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListImagesRequest, ListImagesResponse> onSuccess = new SuccessConsumer<ListImagesRequest, ListImagesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListImagesRequest> onError = new ErrorConsumer<ListImagesRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListImagesRequest, ListImagesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListImagesRequest, ListImagesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListImagesRequest> onError = handler == null ? null : new ErrorConsumer<ListImagesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListImagesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListImagesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListInstanceConsoleConnectionsResponse> listInstanceConsoleConnections(ListInstanceConsoleConnectionsRequest request, AsyncHandler<ListInstanceConsoleConnectionsRequest, ListInstanceConsoleConnectionsResponse> handler) {
        LOG.trace("Called async listInstanceConsoleConnections");
        final ListInstanceConsoleConnectionsRequest interceptedRequest = ListInstanceConsoleConnectionsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListInstanceConsoleConnectionsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListInstanceConsoleConnectionsResponse> transformer = ListInstanceConsoleConnectionsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListInstanceConsoleConnectionsRequest, ListInstanceConsoleConnectionsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListInstanceConsoleConnectionsRequest, ListInstanceConsoleConnectionsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListInstanceConsoleConnectionsRequest, ListInstanceConsoleConnectionsResponse> onSuccess = new SuccessConsumer<ListInstanceConsoleConnectionsRequest, ListInstanceConsoleConnectionsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListInstanceConsoleConnectionsRequest> onError = new ErrorConsumer<ListInstanceConsoleConnectionsRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListInstanceConsoleConnectionsRequest, ListInstanceConsoleConnectionsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListInstanceConsoleConnectionsRequest, ListInstanceConsoleConnectionsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListInstanceConsoleConnectionsRequest> onError = handler == null ? null : new ErrorConsumer<ListInstanceConsoleConnectionsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListInstanceConsoleConnectionsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListInstanceConsoleConnectionsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListInstanceDevicesResponse> listInstanceDevices(ListInstanceDevicesRequest request, AsyncHandler<ListInstanceDevicesRequest, ListInstanceDevicesResponse> handler) {
        LOG.trace("Called async listInstanceDevices");
        final ListInstanceDevicesRequest interceptedRequest = ListInstanceDevicesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListInstanceDevicesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListInstanceDevicesResponse> transformer = ListInstanceDevicesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListInstanceDevicesRequest, ListInstanceDevicesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListInstanceDevicesRequest, ListInstanceDevicesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListInstanceDevicesRequest, ListInstanceDevicesResponse> onSuccess = new SuccessConsumer<ListInstanceDevicesRequest, ListInstanceDevicesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListInstanceDevicesRequest> onError = new ErrorConsumer<ListInstanceDevicesRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListInstanceDevicesRequest, ListInstanceDevicesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListInstanceDevicesRequest, ListInstanceDevicesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListInstanceDevicesRequest> onError = handler == null ? null : new ErrorConsumer<ListInstanceDevicesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListInstanceDevicesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListInstanceDevicesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListInstancesResponse> listInstances(ListInstancesRequest request, AsyncHandler<ListInstancesRequest, ListInstancesResponse> handler) {
        LOG.trace("Called async listInstances");
        final ListInstancesRequest interceptedRequest = ListInstancesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListInstancesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListInstancesResponse> transformer = ListInstancesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListInstancesRequest, ListInstancesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListInstancesRequest, ListInstancesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListInstancesRequest, ListInstancesResponse> onSuccess = new SuccessConsumer<ListInstancesRequest, ListInstancesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListInstancesRequest> onError = new ErrorConsumer<ListInstancesRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListInstancesRequest, ListInstancesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListInstancesRequest, ListInstancesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListInstancesRequest> onError = handler == null ? null : new ErrorConsumer<ListInstancesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListInstancesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListInstancesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListShapesResponse> listShapes(ListShapesRequest request, AsyncHandler<ListShapesRequest, ListShapesResponse> handler) {
        LOG.trace("Called async listShapes");
        final ListShapesRequest interceptedRequest = ListShapesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListShapesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListShapesResponse> transformer = ListShapesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListShapesRequest, ListShapesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListShapesRequest, ListShapesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListShapesRequest, ListShapesResponse> onSuccess = new SuccessConsumer<ListShapesRequest, ListShapesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListShapesRequest> onError = new ErrorConsumer<ListShapesRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListShapesRequest, ListShapesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListShapesRequest, ListShapesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListShapesRequest> onError = handler == null ? null : new ErrorConsumer<ListShapesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListShapesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListShapesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListVnicAttachmentsResponse> listVnicAttachments(ListVnicAttachmentsRequest request, AsyncHandler<ListVnicAttachmentsRequest, ListVnicAttachmentsResponse> handler) {
        LOG.trace("Called async listVnicAttachments");
        final ListVnicAttachmentsRequest interceptedRequest = ListVnicAttachmentsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListVnicAttachmentsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListVnicAttachmentsResponse> transformer = ListVnicAttachmentsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListVnicAttachmentsRequest, ListVnicAttachmentsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListVnicAttachmentsRequest, ListVnicAttachmentsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListVnicAttachmentsRequest, ListVnicAttachmentsResponse> onSuccess = new SuccessConsumer<ListVnicAttachmentsRequest, ListVnicAttachmentsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListVnicAttachmentsRequest> onError = new ErrorConsumer<ListVnicAttachmentsRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListVnicAttachmentsRequest, ListVnicAttachmentsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListVnicAttachmentsRequest, ListVnicAttachmentsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListVnicAttachmentsRequest> onError = handler == null ? null : new ErrorConsumer<ListVnicAttachmentsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListVnicAttachmentsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListVnicAttachmentsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListVolumeAttachmentsResponse> listVolumeAttachments(ListVolumeAttachmentsRequest request, AsyncHandler<ListVolumeAttachmentsRequest, ListVolumeAttachmentsResponse> handler) {
        LOG.trace("Called async listVolumeAttachments");
        final ListVolumeAttachmentsRequest interceptedRequest = ListVolumeAttachmentsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListVolumeAttachmentsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListVolumeAttachmentsResponse> transformer = ListVolumeAttachmentsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListVolumeAttachmentsRequest, ListVolumeAttachmentsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListVolumeAttachmentsRequest, ListVolumeAttachmentsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListVolumeAttachmentsRequest, ListVolumeAttachmentsResponse> onSuccess = new SuccessConsumer<ListVolumeAttachmentsRequest, ListVolumeAttachmentsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListVolumeAttachmentsRequest> onError = new ErrorConsumer<ListVolumeAttachmentsRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListVolumeAttachmentsRequest, ListVolumeAttachmentsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListVolumeAttachmentsRequest, ListVolumeAttachmentsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListVolumeAttachmentsRequest> onError = handler == null ? null : new ErrorConsumer<ListVolumeAttachmentsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListVolumeAttachmentsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListVolumeAttachmentsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<TerminateInstanceResponse> terminateInstance(TerminateInstanceRequest request, AsyncHandler<TerminateInstanceRequest, TerminateInstanceResponse> handler) {
        LOG.trace("Called async terminateInstance");
        final TerminateInstanceRequest interceptedRequest = TerminateInstanceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = TerminateInstanceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, TerminateInstanceResponse> transformer = TerminateInstanceConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<TerminateInstanceRequest, TerminateInstanceResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<TerminateInstanceRequest, TerminateInstanceResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<TerminateInstanceRequest, TerminateInstanceResponse> onSuccess = new SuccessConsumer<TerminateInstanceRequest, TerminateInstanceResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<TerminateInstanceRequest> onError = new ErrorConsumer<TerminateInstanceRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<TerminateInstanceRequest, TerminateInstanceResponse> onSuccess = handler == null ? null : new SuccessConsumer<TerminateInstanceRequest, TerminateInstanceResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<TerminateInstanceRequest> onError = handler == null ? null : new ErrorConsumer<TerminateInstanceRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, TerminateInstanceResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, TerminateInstanceResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateConsoleHistoryResponse> updateConsoleHistory(UpdateConsoleHistoryRequest request, AsyncHandler<UpdateConsoleHistoryRequest, UpdateConsoleHistoryResponse> handler) {
        LOG.trace("Called async updateConsoleHistory");
        final UpdateConsoleHistoryRequest interceptedRequest = UpdateConsoleHistoryConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateConsoleHistoryConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateConsoleHistoryResponse> transformer = UpdateConsoleHistoryConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateConsoleHistoryRequest, UpdateConsoleHistoryResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateConsoleHistoryRequest, UpdateConsoleHistoryResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateConsoleHistoryRequest, UpdateConsoleHistoryResponse> onSuccess = new SuccessConsumer<UpdateConsoleHistoryRequest, UpdateConsoleHistoryResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateConsoleHistoryRequest> onError = new ErrorConsumer<UpdateConsoleHistoryRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.put(ib, interceptedRequest.getUpdateConsoleHistoryDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateConsoleHistoryRequest, UpdateConsoleHistoryResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateConsoleHistoryRequest, UpdateConsoleHistoryResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateConsoleHistoryRequest> onError = handler == null ? null : new ErrorConsumer<UpdateConsoleHistoryRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateConsoleHistoryDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateConsoleHistoryResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.put(ib, interceptedRequest.getUpdateConsoleHistoryDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateConsoleHistoryResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateDedicatedVmHostResponse> updateDedicatedVmHost(UpdateDedicatedVmHostRequest request, AsyncHandler<UpdateDedicatedVmHostRequest, UpdateDedicatedVmHostResponse> handler) {
        LOG.trace("Called async updateDedicatedVmHost");
        final UpdateDedicatedVmHostRequest interceptedRequest = UpdateDedicatedVmHostConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateDedicatedVmHostConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateDedicatedVmHostResponse> transformer = UpdateDedicatedVmHostConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateDedicatedVmHostRequest, UpdateDedicatedVmHostResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateDedicatedVmHostRequest, UpdateDedicatedVmHostResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateDedicatedVmHostRequest, UpdateDedicatedVmHostResponse> onSuccess = new SuccessConsumer<UpdateDedicatedVmHostRequest, UpdateDedicatedVmHostResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateDedicatedVmHostRequest> onError = new ErrorConsumer<UpdateDedicatedVmHostRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.put(ib, interceptedRequest.getUpdateDedicatedVmHostDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateDedicatedVmHostRequest, UpdateDedicatedVmHostResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateDedicatedVmHostRequest, UpdateDedicatedVmHostResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateDedicatedVmHostRequest> onError = handler == null ? null : new ErrorConsumer<UpdateDedicatedVmHostRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateDedicatedVmHostDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateDedicatedVmHostResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.put(ib, interceptedRequest.getUpdateDedicatedVmHostDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateDedicatedVmHostResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateImageResponse> updateImage(UpdateImageRequest request, AsyncHandler<UpdateImageRequest, UpdateImageResponse> handler) {
        LOG.trace("Called async updateImage");
        final UpdateImageRequest interceptedRequest = UpdateImageConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateImageConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateImageResponse> transformer = UpdateImageConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateImageRequest, UpdateImageResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateImageRequest, UpdateImageResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateImageRequest, UpdateImageResponse> onSuccess = new SuccessConsumer<UpdateImageRequest, UpdateImageResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateImageRequest> onError = new ErrorConsumer<UpdateImageRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.put(ib, interceptedRequest.getUpdateImageDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateImageRequest, UpdateImageResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateImageRequest, UpdateImageResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateImageRequest> onError = handler == null ? null : new ErrorConsumer<UpdateImageRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateImageDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateImageResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.put(ib, interceptedRequest.getUpdateImageDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateImageResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateInstanceResponse> updateInstance(UpdateInstanceRequest request, AsyncHandler<UpdateInstanceRequest, UpdateInstanceResponse> handler) {
        LOG.trace("Called async updateInstance");
        final UpdateInstanceRequest interceptedRequest = UpdateInstanceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateInstanceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateInstanceResponse> transformer = UpdateInstanceConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateInstanceRequest, UpdateInstanceResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateInstanceRequest, UpdateInstanceResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateInstanceRequest, UpdateInstanceResponse> onSuccess = new SuccessConsumer<UpdateInstanceRequest, UpdateInstanceResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateInstanceRequest> onError = new ErrorConsumer<UpdateInstanceRequest>(this, interceptedRequest);
                    ComputeAsyncClient.this.client.put(ib, interceptedRequest.getUpdateInstanceDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateInstanceRequest, UpdateInstanceResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateInstanceRequest, UpdateInstanceResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateInstanceRequest> onError = handler == null ? null : new ErrorConsumer<UpdateInstanceRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateInstanceDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateInstanceResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeAsyncClient.this.client.put(ib, interceptedRequest.getUpdateInstanceDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateInstanceResponse>(responseFuture, transformer);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ComputeAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        @Override
        public ComputeAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new ComputeAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

